/*! For license information please see officebrowserfeedback_floodgate.js.LICENSE.txt */
!function(n){var A={};function e(t){if(A[t])return A[t].exports;var l=A[t]={i:t,l:!1,exports:{}};return n[t].call(l.exports,l,l.exports,e),l.l=!0,l.exports}e.m=n,e.c=A,e.d=function(n,A,t){e.o(n,A)||Object.defineProperty(n,A,{enumerable:!0,get:t})},e.r=function(n){"undefined"!==typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(n,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(n,"__esModule",{value:!0})},e.t=function(n,A){if(1&A&&(n=e(n)),8&A)return n;if(4&A&&"object"===typeof n&&n&&n.__esModule)return n;var t=Object.create(null);if(e.r(t),Object.defineProperty(t,"default",{enumerable:!0,value:n}),2&A&&"string"!=typeof n)for(var l in n)e.d(t,l,function(A){return n[A]}.bind(null,l));return t},e.n=function(n){var A=n&&n.__esModule?function(){return n.default}:function(){return n};return e.d(A,"a",A),A},e.o=function(n,A){return Object.prototype.hasOwnProperty.call(n,A)},e.p="",e(e.s=0)}({"../FloodgateCore/dist/index.js":function(module,exports,__webpack_require__){"use strict";eval('\n/**\n * Main entry point.\n */\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.Utils = exports.Api = void 0;\nvar floodgate_shared_typings_1 = __webpack_require__(/*! @ms-ofb/floodgate-shared-typings */ "../FloodgateCore/node_modules/@ms-ofb/floodgate-shared-typings/dist/index.js");\nObject.defineProperty(exports, "Api", { enumerable: true, get: function () { return floodgate_shared_typings_1.Api; } });\nvar Utils = __webpack_require__(/*! ./src/Utils */ "../FloodgateCore/dist/src/Utils.js");\nexports.Utils = Utils;\nvar FloodgateEngine_1 = __webpack_require__(/*! ./src/FloodgateEngine */ "../FloodgateCore/dist/src/FloodgateEngine.js");\nObject.defineProperty(exports, "FloodgateEngine", { enumerable: true, get: function () { return FloodgateEngine_1.FloodgateEngine; } });\nvar TelemetryLogger_1 = __webpack_require__(/*! ./src/TelemetryLogger */ "../FloodgateCore/dist/src/TelemetryLogger.js");\nObject.defineProperty(exports, "TelemetryLogger", { enumerable: true, get: function () { return TelemetryLogger_1.TelemetryLogger; } });\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vaW5kZXgudHM/Yjg1ZSJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7O0dBRUc7OztBQUVILDZLQUF1RDtBQUs5QyxvRkFMQSw4QkFBRyxPQUtBO0FBSloseUZBQXFDO0FBSXZCLHNCQUFLO0FBRm5CLHlIQUF3RDtBQUEvQyxpSUFBZTtBQUN4Qix5SEFBd0Q7QUFBL0MsaUlBQWUiLCJmaWxlIjoiLi4vRmxvb2RnYXRlQ29yZS9kaXN0L2luZGV4LmpzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXHJcbiAqIE1haW4gZW50cnkgcG9pbnQuXHJcbiAqL1xyXG5cclxuaW1wb3J0IHsgQXBpIH0gZnJvbSBcIkBtcy1vZmIvZmxvb2RnYXRlLXNoYXJlZC10eXBpbmdzXCI7XHJcbmltcG9ydCAqIGFzIFV0aWxzIGZyb20gXCIuL3NyYy9VdGlsc1wiO1xyXG5cclxuZXhwb3J0IHsgRmxvb2RnYXRlRW5naW5lIH0gZnJvbSBcIi4vc3JjL0Zsb29kZ2F0ZUVuZ2luZVwiO1xyXG5leHBvcnQgeyBUZWxlbWV0cnlMb2dnZXIgfSBmcm9tIFwiLi9zcmMvVGVsZW1ldHJ5TG9nZ2VyXCI7XHJcbmV4cG9ydCB7IEFwaSwgVXRpbHMgfTtcclxuIl0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/index.js\n')},"../FloodgateCore/dist/src/ActivityTracker.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\n/**\n * Class to track ticks against a list of expected counts in a thread-safe way\n * Main API of interest is incrementActivity, which returns an enumerated value indicating\n * whether or not the increment resulted in no thresholds crossed, a single activity threshold crossed,\n * or the final activity threshold crossed.\n */\nvar ActivityTracker = /** @class */ (function () {\n    function ActivityTracker(trackingSet) {\n        if (!trackingSet) {\n            throw new Error("trackingSet must not be null");\n        }\n        if (trackingSet.getList().length > 32) {\n            throw new Error("trackingSet list size must be less than 32");\n        }\n        this.isOrdered = trackingSet.getIsOrdered();\n        this.trackedActivities = trackingSet.getList();\n        /**\n         * For ordered sets, the current index.\n         */\n        this.currentIndex = 0;\n        this.activationMask = 0;\n        this.currentActivationFlags = 0;\n        this.isActivationByInitPending = false;\n        this.currentCounts = new Array(this.trackedActivities.length);\n        this.currentStartTimes = new Array(this.trackedActivities.length);\n        this.currentSessionCounts = new Array(this.trackedActivities.length);\n        for (var i = 0; i < this.trackedActivities.length; i++) {\n            this.currentCounts[i] = 0;\n            this.currentSessionCounts[i] = 0;\n        }\n        for (var i = 0; i < this.trackedActivities.length; i++) {\n            this.activationMask |= 0x1 << i;\n            if (this.trackedActivities[i].getCount() < 1) {\n                this.trackedActivities[i].setCount(1);\n            }\n        }\n    }\n    /**\n     * Get the count for the activity at the specified index. Returns 0 for out-of-range indices\n     *\n     * @param index index\n     */\n    ActivityTracker.prototype.getCount = function (index) {\n        if (!this.isValidIndex(index)) {\n            return 0;\n        }\n        return this.currentCounts[index];\n    };\n    /**\n     * Get the count for the activity at the specified index, as tracked only for this session.\n     * Returns 0 for out-of-range indices\n     *\n     * @param index index\n     */\n    ActivityTracker.prototype.getSessionCount = function (index) {\n        if (!this.isValidIndex(index)) {\n            return 0;\n        }\n        return this.currentSessionCounts[index];\n    };\n    /**\n     * Get the StartTime for the activity at the specified index. Returns null for out-of-range indices\n     *\n     * @param index index\n     */\n    ActivityTracker.prototype.getStartTime = function (index) {\n        if (!this.isValidIndex(index)) {\n            return null;\n        }\n        return this.currentStartTimes[index];\n    };\n    /**\n     * A get-and-set method. Returns the current SessionCount, resetting it to zero and adding it into\n     * the established baseline.\n     *\n     * @param index index\n     */\n    ActivityTracker.prototype.moveSessionCountIntoBaseCount = function (index) {\n        if (!this.isValidIndex(index)) {\n            return 0;\n        }\n        var sessionCount = this.currentSessionCounts[index];\n        this.currentSessionCounts[index] = 0;\n        return sessionCount;\n    };\n    /**\n     * Forcibly set the counts for the activities in the trackingSet.\n     * Unlike other APIs, this expects vector indices to match the order\n     * of the ActivityTrackingSet.List initially used to construct this tracker.\n     * (When data is copied from a different IndexedTracker, it will properly use the IndexedTracker.Index to query internals)\n     * Note:\n     * 1) Assumes a count of 0 for any missing index in undersized arrays.\n     * 2) Respects and enforces ordered list initialization (i.e. all init values are ignored once a unfinished activity is\n     * encountered in an ordered tracking list).\n     * 3) If the tracker is fully Activated as a result of this call, the next call to IncrementActivity will raise the\n     * IncrementEdgeResult.AllActivitiesActivated, for any valid index accepted by IsPermittedIndexForActivationByInit().\n     */\n    ActivityTracker.prototype.initCounts = function (baselineCounts, otherTrackers, wasAlreadyActivatedThisSession) {\n        // NOTE: baselineIncrements and sessionIncrements are sorted the same as the initial trackedActivity set, which\n        // for this class is the same as trackedActivities\n        if (wasAlreadyActivatedThisSession === void 0) { wasAlreadyActivatedThisSession = false; }\n        for (var i = 0; i < this.trackedActivities.length; i++) {\n            // Only accept values up to the current index, when ordered\n            if (this.isOrdered && i > this.currentIndex) {\n                break;\n            }\n            // Start off by pulling values from this session\n            if (i < otherTrackers.length && otherTrackers[i]) {\n                this.currentSessionCounts[i] = this.currentCounts[i] = otherTrackers[i].tracker.getSessionCount(otherTrackers[i].index);\n                this.currentStartTimes[i] = otherTrackers[i].tracker.getStartTime(otherTrackers[i].index);\n            }\n            // If we\'ve got a baseline from previous sessions, add it in as well\n            if (this.trackedActivities[i].getIsAggregate() && i < baselineCounts.length) {\n                this.currentCounts[i] += baselineCounts[i];\n            }\n            if (this.hasCountCrossedThreshold(i)) {\n                this.finishActivityAtIndex(i);\n            }\n        }\n        if (this.isActivated() && !wasAlreadyActivatedThisSession) {\n            // Mark this object so that the next time any permitted activation event is logged, the survey will activate\n            this.isActivationByInitPending = true;\n        }\n    };\n    ActivityTracker.prototype.generateActivityIndexList = function () {\n        var indexList = new Array();\n        for (var i = 0; i < this.trackedActivities.length; i++) {\n            var current = new ActivityTracker.ActivityIndex();\n            current.activity = this.trackedActivities[i].getActivity();\n            current.index = i;\n            indexList.push(current);\n        }\n        return indexList;\n    };\n    /**\n     * Increments the count at the specified index by the given increment.  Returns a value indicating whether\n     * or not this call triggered a transition edge (activating the activity at \'index\', or finishing the activation\n     * of the final pending activity)\n     */\n    ActivityTracker.prototype.incrementActivity = function (index, increment) {\n        if (!this.isValidIndex(index)) {\n            return 0 /* Pending */;\n        }\n        if (increment < 0) {\n            throw new Error("increment must be non-negative");\n        }\n        // Ordered sets must be triggered in order.  We can only track at the current index, or before\n        if (this.isOrdered && index > this.currentIndex) {\n            return 0 /* Pending */;\n        }\n        // Add to our counts after storing off our current state\n        var startedLessThanThreshold = !this.hasCountCrossedThreshold(index);\n        this.currentCounts[index] += increment;\n        this.currentSessionCounts[index] += increment;\n        if (this.isActivationByInitPending) {\n            if (this.isPermittedIndexForActivationByInit(index)) {\n                // This tracker was completed due to the initialization from previous increment data\n                // now that we\'ve store this activities increments, raise the AllActivitiesActivated signal\n                return this.commitActivation();\n            }\n            else {\n                // Still waiting for a valid re-activation activity\n                return 0 /* Pending */;\n            }\n        }\n        if (!(startedLessThanThreshold && this.hasCountCrossedThreshold(index))) {\n            // Still waiting for this activity to finish\n            return 0 /* Pending */;\n        }\n        // Mark this activity as complete in our flag collection\n        this.finishActivityAtIndex(index);\n        if (this.isActivated()) {\n            return this.commitActivation();\n        }\n        return 1 /* SingleActivityActivated */;\n    };\n    /**\n     * Explicitly sets a start timestamp (now if startTime is null) for the specified activity index. Overwrites any previous StartTime.\n     */\n    ActivityTracker.prototype.startTime = function (index, startTime) {\n        if (!this.isValidIndex(index)) {\n            return;\n        }\n        this.currentStartTimes[index] = (!startTime) ? new Date() : startTime;\n    };\n    /**\n     * Computes the "count" delta (delta in whatever units are appropriate for a subsequent call to IncrementActivity)\n     * elapsed between now and a previously logged StartTime for this activity index.\n     * Always clears the previous StartTime.\n     * Returns 0 if no previous StartTime was logged, or if StartTime > StopTime\n     */\n    ActivityTracker.prototype.stopTime = function (index, stopTime) {\n        if (!this.isValidIndex(index)) {\n            return 0;\n        }\n        var startTime = this.currentStartTimes[index];\n        this.currentStartTimes[index] = null;\n        if (!startTime) {\n            return 0;\n        }\n        stopTime = (!stopTime) ? new Date() : stopTime;\n        if (startTime > stopTime) {\n            return 0;\n        }\n        var deltaMS = stopTime.getTime() - startTime.getTime();\n        // Currently all timer activities return seconds as the increment unit\n        var diff = deltaMS / 1000;\n        // Adding 1ms to the count so it can have the decimal place\n        // So that we can distinguish the Time activity\n        if (diff % 1 === 0) {\n            diff += 0.001;\n        }\n        return diff;\n    };\n    /**\n     * Returns true if the index is valid for accessing the stored activity counts, false otherwise\n     */\n    ActivityTracker.prototype.isValidIndex = function (index) {\n        return index < this.trackedActivities.length;\n    };\n    /**\n     * Gets whether or not the full set of activities for this tracker have exceeded their trigger thresholds\n     */\n    ActivityTracker.prototype.isActivated = function () {\n        return (this.currentActivationFlags & this.activationMask) === this.activationMask;\n    };\n    /**\n        * Marks the activity at the index as finished. Includes setting the proper\n        * activation flags and potentially advancing the current index for ordered tracking sets\n        */\n    ActivityTracker.prototype.finishActivityAtIndex = function (index) {\n        if (!this.isValidIndex(index)) {\n            throw new Error("Index is not valid");\n        }\n        this.currentActivationFlags |= 0x1 << index;\n        if (index + 1 < this.trackedActivities.length) {\n            this.currentIndex = index + 1;\n        }\n    };\n    /**\n     * @param index index\n     * @return true if the counts for the activity at the specified index have met or exceeded the threshold count.\n     */\n    ActivityTracker.prototype.hasCountCrossedThreshold = function (index) {\n        if (!this.isValidIndex(index)) {\n            throw new Error("Index is not valid");\n        }\n        return this.currentCounts[index] >= this.trackedActivities[index].getCount();\n    };\n    /**\n     * Returns true if the index refers to an activity that can re-activate a tracked object (aka return AllActivitiesActivated)\n     * that was initialized as "complete" via initCounts.\n     * Note: For unordered sets, any activity is valid. For ordered sequences, only the final activity is valid\n     */\n    ActivityTracker.prototype.isPermittedIndexForActivationByInit = function (index) {\n        return !this.isOrdered || ((index + 1) === this.currentCounts.length);\n    };\n    ActivityTracker.prototype.commitActivation = function () {\n        this.isActivationByInitPending = false;\n        return 2 /* AllActivitiesActivated */;\n    };\n    return ActivityTracker;\n}());\n(function (ActivityTracker) {\n    /**\n     * Structure returned by an ActivityTracker to call back into\n     * IncrementActivity with valid index values\n     */\n    var ActivityIndex = /** @class */ (function () {\n        function ActivityIndex() {\n        }\n        return ActivityIndex;\n    }());\n    ActivityTracker.ActivityIndex = ActivityIndex;\n})(ActivityTracker || (ActivityTracker = {}));\nexports.default = ActivityTracker;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/ActivityTracker.js\n')},"../FloodgateCore/dist/src/ActivityTrackingContract.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.ActivityTrackingContract = void 0;\nvar ActivityTrackingContract = /** @class */ (function () {\n    function ActivityTrackingContract(surveyId, trackingSet) {\n        this.surveyId = surveyId;\n        this.trackingSet = trackingSet;\n    }\n    return ActivityTrackingContract;\n}());\nexports.ActivityTrackingContract = ActivityTrackingContract;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vc3JjL0FjdGl2aXR5VHJhY2tpbmdDb250cmFjdC50cz80NDk1Il0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUVBO0lBSUMsa0NBQW1CLFFBQWdCLEVBQUUsV0FBaUM7UUFDckUsSUFBSSxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUM7UUFDekIsSUFBSSxDQUFDLFdBQVcsR0FBRyxXQUFXLENBQUM7SUFDaEMsQ0FBQztJQUNGLCtCQUFDO0FBQUQsQ0FBQztBQVJZLDREQUF3QiIsImZpbGUiOiIuLi9GbG9vZGdhdGVDb3JlL2Rpc3Qvc3JjL0FjdGl2aXR5VHJhY2tpbmdDb250cmFjdC5qcy5qcyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElBY3Rpdml0eVRyYWNraW5nQ29udHJhY3QsIElBY3Rpdml0eVRyYWNraW5nU2V0IH0gZnJvbSBcIkBtcy1vZmIvZmxvb2RnYXRlLXNoYXJlZC10eXBpbmdzXCI7XHJcblxyXG5leHBvcnQgY2xhc3MgQWN0aXZpdHlUcmFja2luZ0NvbnRyYWN0IGltcGxlbWVudHMgSUFjdGl2aXR5VHJhY2tpbmdDb250cmFjdCB7XHJcblx0cHVibGljIHN1cnZleUlkOiBzdHJpbmc7XHJcblx0cHVibGljIHRyYWNraW5nU2V0OiBJQWN0aXZpdHlUcmFja2luZ1NldDtcclxuXHJcblx0cHVibGljIGNvbnN0cnVjdG9yKHN1cnZleUlkOiBzdHJpbmcsIHRyYWNraW5nU2V0OiBJQWN0aXZpdHlUcmFja2luZ1NldCkge1xyXG5cdFx0dGhpcy5zdXJ2ZXlJZCA9IHN1cnZleUlkO1xyXG5cdFx0dGhpcy50cmFja2luZ1NldCA9IHRyYWNraW5nU2V0O1xyXG5cdH1cclxufVxyXG4iXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/ActivityTrackingContract.js\n')},"../FloodgateCore/dist/src/ActivityTrackingData.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.ActivityTrackingData = void 0;\n/**\n * Basic structure used to configure an ActivityTracker\n */\nvar ActivityTrackingData = /** @class */ (function () {\n    function ActivityTrackingData(activity, count, isAggregate) {\n        this.activity = activity;\n        this.count = count;\n        this.isAggregate = isAggregate;\n    }\n    ActivityTrackingData.prototype.getActivity = function () {\n        return this.activity;\n    };\n    ActivityTrackingData.prototype.getCount = function () {\n        return this.count;\n    };\n    ActivityTrackingData.prototype.setCount = function (count) {\n        this.count = count;\n    };\n    ActivityTrackingData.prototype.getIsAggregate = function () {\n        return this.isAggregate;\n    };\n    return ActivityTrackingData;\n}());\nexports.ActivityTrackingData = ActivityTrackingData;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vc3JjL0FjdGl2aXR5VHJhY2tpbmdEYXRhLnRzP2Q5M2YiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBRUE7O0dBRUc7QUFDSDtJQUtDLDhCQUFtQixRQUFnQixFQUFFLEtBQWEsRUFBRSxXQUFvQjtRQUN2RSxJQUFJLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQztRQUN6QixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUNuQixJQUFJLENBQUMsV0FBVyxHQUFHLFdBQVcsQ0FBQztJQUNoQyxDQUFDO0lBRU0sMENBQVcsR0FBbEI7UUFDQyxPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDdEIsQ0FBQztJQUVNLHVDQUFRLEdBQWY7UUFDQyxPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDbkIsQ0FBQztJQUVNLHVDQUFRLEdBQWYsVUFBZ0IsS0FBYTtRQUM1QixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBRU0sNkNBQWMsR0FBckI7UUFDQyxPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDekIsQ0FBQztJQUNGLDJCQUFDO0FBQUQsQ0FBQztBQTFCWSxvREFBb0IiLCJmaWxlIjoiLi4vRmxvb2RnYXRlQ29yZS9kaXN0L3NyYy9BY3Rpdml0eVRyYWNraW5nRGF0YS5qcy5qcyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElBY3Rpdml0eVRyYWNraW5nRGF0YSB9IGZyb20gXCJAbXMtb2ZiL2Zsb29kZ2F0ZS1zaGFyZWQtdHlwaW5nc1wiO1xyXG5cclxuLyoqXHJcbiAqIEJhc2ljIHN0cnVjdHVyZSB1c2VkIHRvIGNvbmZpZ3VyZSBhbiBBY3Rpdml0eVRyYWNrZXJcclxuICovXHJcbmV4cG9ydCBjbGFzcyBBY3Rpdml0eVRyYWNraW5nRGF0YSBpbXBsZW1lbnRzIElBY3Rpdml0eVRyYWNraW5nRGF0YSB7XHJcblx0cHJpdmF0ZSBhY3Rpdml0eTogc3RyaW5nO1xyXG5cdHByaXZhdGUgY291bnQ6IG51bWJlcjtcclxuXHRwcml2YXRlIGlzQWdncmVnYXRlOiBib29sZWFuO1xyXG5cclxuXHRwdWJsaWMgY29uc3RydWN0b3IoYWN0aXZpdHk6IHN0cmluZywgY291bnQ6IG51bWJlciwgaXNBZ2dyZWdhdGU6IGJvb2xlYW4pIHtcclxuXHRcdHRoaXMuYWN0aXZpdHkgPSBhY3Rpdml0eTtcclxuXHRcdHRoaXMuY291bnQgPSBjb3VudDtcclxuXHRcdHRoaXMuaXNBZ2dyZWdhdGUgPSBpc0FnZ3JlZ2F0ZTtcclxuXHR9XHJcblxyXG5cdHB1YmxpYyBnZXRBY3Rpdml0eSgpOiBzdHJpbmcge1xyXG5cdFx0cmV0dXJuIHRoaXMuYWN0aXZpdHk7XHJcblx0fVxyXG5cclxuXHRwdWJsaWMgZ2V0Q291bnQoKTogbnVtYmVyIHtcclxuXHRcdHJldHVybiB0aGlzLmNvdW50O1xyXG5cdH1cclxuXHJcblx0cHVibGljIHNldENvdW50KGNvdW50OiBudW1iZXIpOiB2b2lkIHtcclxuXHRcdHRoaXMuY291bnQgPSBjb3VudDtcclxuXHR9XHJcblxyXG5cdHB1YmxpYyBnZXRJc0FnZ3JlZ2F0ZSgpOiBib29sZWFuIHtcclxuXHRcdHJldHVybiB0aGlzLmlzQWdncmVnYXRlO1xyXG5cdH1cclxufVxyXG4iXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/ActivityTrackingData.js\n')},"../FloodgateCore/dist/src/ActivityTrackingSet.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.ActivityTrackingSet = void 0;\nvar Utils_1 = __webpack_require__(/*! ./Utils */ "../FloodgateCore/dist/src/Utils.js");\n/**\n * Class to hold a collection of Activity Tracking Data\n */\nvar ActivityTrackingSet = /** @class */ (function () {\n    function ActivityTrackingSet(isOrdered, list) {\n        this.isOrdered = isOrdered;\n        this.list = list;\n    }\n    ActivityTrackingSet.prototype.getIsOrdered = function () {\n        return this.isOrdered;\n    };\n    ActivityTrackingSet.prototype.getList = function () {\n        return this.list;\n    };\n    // returns a stringified json with the list and isOrdered info.\n    ActivityTrackingSet.prototype.getActivityTrackingInfo = function (activityListener, surveyId) {\n        var activitiesInfoObject;\n        if (this.list.length === 0) {\n            activitiesInfoObject = {\n                Activities: [],\n                IsListOrdered: this.isOrdered,\n            };\n            return JSON.stringify(activitiesInfoObject);\n        }\n        for (var _i = 0, _a = this.list; _i < _a.length; _i++) {\n            var trackingData = _a[_i];\n            var actualCount = activityListener.getCount(trackingData.getActivity(), surveyId);\n            var tempActivities = {\n                Activity: trackingData.getActivity(),\n                ActualCount: actualCount,\n                Count: trackingData.getCount(),\n                IsAggregate: trackingData.getIsAggregate(),\n                IsDiscrete: actualCount % 1 === 0,\n            };\n            if (Utils_1.isNOU(activitiesInfoObject)) {\n                activitiesInfoObject = {\n                    Activities: [tempActivities],\n                    IsListOrdered: this.isOrdered,\n                };\n            }\n            else {\n                activitiesInfoObject.Activities.push(tempActivities);\n            }\n        }\n        return JSON.stringify(activitiesInfoObject);\n    };\n    return ActivityTrackingSet;\n}());\nexports.ActivityTrackingSet = ActivityTrackingSet;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/ActivityTrackingSet.js\n')},"../FloodgateCore/dist/src/Campaign/CampaignDefinitionProvider.js":function(module,exports,__webpack_require__){"use strict";eval('\nvar __extends = (this && this.__extends) || (function () {\n    var extendStatics = function (d, b) {\n        extendStatics = Object.setPrototypeOf ||\n            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||\n            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };\n        return extendStatics(d, b);\n    };\n    return function (d, b) {\n        extendStatics(d, b);\n        function __() { this.constructor = d; }\n        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());\n    };\n})();\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.setDynamicUxSchemaVariables = exports.DynamicCampaignDefinitionProvider = exports.FileSystemCampaignDefinitionProvider = exports.FilterValidCampaignDefinitions = exports.CampaignDefinition = exports.CampaignSurveyTemplateIntercept = exports.CampaignSurveyTemplateGenericMessagingSurface = exports.CampaignSurveyTemplateNps11PointStatic = exports.CampaignSurveyTemplateNps5PointStatic = exports.CampaignSurveyTemplateNps = exports.CampaignSurveyTemplateNlqs = exports.CampaignSurveyTemplateFps = exports.CampaignSurveyTemplate = exports.CampaignSurveyMetadata = exports.CampaignSurveyContentComment = exports.CampaignSurveyContentRating = exports.CampaignSurveyContentIntercept = exports.CampaignSurveyContentPrompt = exports.CampaignSurveyContentCVSurvey = exports.CampaignSurveyContentMultipleChoice = exports.CampaignSurveyContent = exports.CampaignSurveyEventCountedActivitySequence = exports.CampaignSurveyEventCountedActivity = exports.CampaignSurveyEvent = exports.CampaignNominationSchemeRatioPercentage = exports.CampaignNominationScheme = exports.CampaignDistributionRamp = exports.CampaignDistribution = exports.CampaignAdditionalDataRequested = exports.CampaignDurationSingleBuildChange = exports.CampaignDurationTimeInterval = exports.CampaignDuration = exports.CampaignScopeUserFactAll = exports.CampaignScopeUserFactAny = exports.CampaignScopeEnvironmentCrossProduct = exports.CampaignScopeAny = exports.CampaignScope = exports.CampaignLanguageRangeLanguageSubtag = exports.CampaignLanguageRange = void 0;\nvar floodgate_shared_typings_1 = __webpack_require__(/*! @ms-ofb/floodgate-shared-typings */ "../FloodgateCore/node_modules/@ms-ofb/floodgate-shared-typings/dist/index.js");\nvar Constants_1 = __webpack_require__(/*! ../Constants */ "../FloodgateCore/dist/src/Constants.js");\nvar UserFactHelper_1 = __webpack_require__(/*! ../UserFact/UserFactHelper */ "../FloodgateCore/dist/src/UserFact/UserFactHelper.js");\nvar Utils = __webpack_require__(/*! ../Utils */ "../FloodgateCore/dist/src/Utils.js");\nvar TelemetryLogger_1 = __webpack_require__(/*! ../TelemetryLogger */ "../FloodgateCore/dist/src/TelemetryLogger.js");\nvar getDistantFuture = Utils.getDistantFuture, isBoolean = Utils.isBoolean, isNOU = Utils.isNOU, isNumber = Utils.isNumber, isString = Utils.isString, isUtcDatetimeString = Utils.isUtcDatetimeString, stringToDate = Utils.stringToDate;\nvar dynamicUxSchemaVariables = {};\n// region Language Range\n/**\n * Base class representing a language range in a campaign setting\n */\nvar CampaignLanguageRange = /** @class */ (function () {\n    function CampaignLanguageRange() {\n    }\n    CampaignLanguageRange.deserialize = function (input) {\n        var result;\n        if (input && input.Type === 0) {\n            result = CampaignLanguageRangeLanguageSubtag.deserialize(input);\n        }\n        if (result === undefined) {\n            return null;\n        }\n        return result;\n    };\n    CampaignLanguageRange.prototype.validate = function () {\n        return true;\n    };\n    return CampaignLanguageRange;\n}());\nexports.CampaignLanguageRange = CampaignLanguageRange;\n/**\n * Represents a range matching on the "language subtag" against fully specified language tags, according to RFC 5646\n */\nvar CampaignLanguageRangeLanguageSubtag = /** @class */ (function (_super) {\n    __extends(CampaignLanguageRangeLanguageSubtag, _super);\n    // public for UT only\n    function CampaignLanguageRangeLanguageSubtag() {\n        return _super.call(this) || this;\n    }\n    CampaignLanguageRangeLanguageSubtag.deserialize = function (input) {\n        var result = new CampaignLanguageRangeLanguageSubtag();\n        if (input) {\n            result.languageSubTag = input.Value;\n        }\n        if (!result.validate()) {\n            return null;\n        }\n        return result;\n    };\n    // @Override\n    CampaignLanguageRangeLanguageSubtag.prototype.isInRange = function (language) {\n        if (isNOU(language)) {\n            return false;\n        }\n        var extractedLanguageSubTag = Utils.extractLanguageSubtag(language);\n        if (isNOU(extractedLanguageSubTag)) {\n            return false;\n        }\n        // compare strings ignoring case\n        return extractedLanguageSubTag.toLocaleUpperCase() === this.languageSubTag.toLocaleUpperCase();\n    };\n    // @Override\n    CampaignLanguageRangeLanguageSubtag.prototype.validate = function () {\n        if (!_super.prototype.validate.call(this)) {\n            return false;\n        }\n        if (isNOU(this.languageSubTag) || !isString(this.languageSubTag)) {\n            return false;\n        }\n        // Reject any spec that isn\'t exactly a language subtag\n        if (!Utils.isValidLanguageSubTag(this.languageSubTag)) {\n            return false;\n        }\n        return true;\n    };\n    return CampaignLanguageRangeLanguageSubtag;\n}(CampaignLanguageRange));\nexports.CampaignLanguageRangeLanguageSubtag = CampaignLanguageRangeLanguageSubtag;\n// endregion\n// region Scope\nvar CampaignScope = /** @class */ (function () {\n    function CampaignScope() {\n    }\n    CampaignScope.deserialize = function (input) {\n        var result;\n        if (isNOU(input)) {\n            return null;\n        }\n        switch (input.Type) {\n            case 0 /* CampaignScopeAny */:\n                result = CampaignScopeAny.deserialize(input);\n                break;\n            case 1 /* CampaignScopeEnvironmentCrossProduct */:\n                result = CampaignScopeEnvironmentCrossProduct.deserialize(input);\n                break;\n            case 2 /* CampaignScopeUserFactAny */:\n                result = CampaignScopeUserFactAny.deserialize(input);\n                break;\n            case 3 /* CampaignScopeUserFactAll */:\n                result = CampaignScopeUserFactAll.deserialize(input);\n                break;\n        }\n        if (result === undefined) {\n            return null;\n        }\n        return result;\n    };\n    CampaignScope.prototype.validate = function () {\n        return true;\n    };\n    return CampaignScope;\n}());\nexports.CampaignScope = CampaignScope;\nvar CampaignScopeAny = /** @class */ (function (_super) {\n    __extends(CampaignScopeAny, _super);\n    // public for UT only\n    function CampaignScopeAny() {\n        return _super.call(this) || this;\n    }\n    CampaignScopeAny.deserialize = function (input) {\n        return new CampaignScopeAny();\n    };\n    // @Override\n    CampaignScopeAny.prototype.isInScope = function () {\n        return true;\n    };\n    // @Override\n    CampaignScopeAny.prototype.validate = function () {\n        if (!_super.prototype.validate.call(this)) {\n            return false;\n        }\n        return true;\n    };\n    return CampaignScopeAny;\n}(CampaignScope));\nexports.CampaignScopeAny = CampaignScopeAny;\nvar CampaignScopeEnvironmentCrossProduct = /** @class */ (function (_super) {\n    __extends(CampaignScopeEnvironmentCrossProduct, _super);\n    // public for UT only\n    function CampaignScopeEnvironmentCrossProduct() {\n        return _super.call(this) || this;\n    }\n    CampaignScopeEnvironmentCrossProduct.deserialize = function (input) {\n        var result = new CampaignScopeEnvironmentCrossProduct();\n        var languageRanges = [];\n        if (isNOU(input)) {\n            return null;\n        }\n        for (var key in input.Languages) {\n            if (Object.prototype.hasOwnProperty.call(input.Languages, key)) {\n                var readRange = input.Languages[key];\n                if (readRange) {\n                    languageRanges.push(CampaignLanguageRange.deserialize(readRange));\n                }\n            }\n        }\n        if (languageRanges.length === 0) {\n            languageRanges = null;\n        }\n        result.languageRanges = languageRanges;\n        if (!result.validate()) {\n            return null;\n        }\n        return result;\n    };\n    CampaignScopeEnvironmentCrossProduct.prototype.setEnvironmentProvider = function (environmentProvider) {\n        this.environmentProvider = environmentProvider;\n    };\n    // @Override\n    CampaignScopeEnvironmentCrossProduct.prototype.isInScope = function () {\n        if (isNOU(this.languageRanges)) {\n            return true;\n        }\n        if (isNOU(this.environmentProvider) || !this.environmentProvider.getLanguage()) {\n            return false;\n        }\n        var language = this.environmentProvider.getLanguage();\n        // If the environment matches a single pattern, then this is a yes\n        for (var key in this.languageRanges) {\n            if (Object.prototype.hasOwnProperty.call(this.languageRanges, key)) {\n                var range = this.languageRanges[key];\n                if (range.isInRange(language)) {\n                    return true;\n                }\n            }\n        }\n        return false;\n    };\n    // @Override\n    CampaignScopeEnvironmentCrossProduct.prototype.validate = function () {\n        if (!_super.prototype.validate.call(this)) {\n            return false;\n        }\n        // Null languageRanges is allowed, means will match with everything.\n        if (this.languageRanges) {\n            for (var key in this.languageRanges) {\n                if (Object.prototype.hasOwnProperty.call(this.languageRanges, key) && !this.languageRanges[key]) {\n                    return false;\n                }\n            }\n        }\n        return true;\n    };\n    return CampaignScopeEnvironmentCrossProduct;\n}(CampaignScope));\nexports.CampaignScopeEnvironmentCrossProduct = CampaignScopeEnvironmentCrossProduct;\nvar CampaignScopeUserFactAny = /** @class */ (function (_super) {\n    __extends(CampaignScopeUserFactAny, _super);\n    // public for UT only\n    function CampaignScopeUserFactAny() {\n        return _super.call(this) || this;\n    }\n    CampaignScopeUserFactAny.deserialize = function (input) {\n        var result = new CampaignScopeUserFactAny();\n        result.userFacts = UserFactHelper_1.deserializeUserFacts(input);\n        if (!result.validate()) {\n            return null;\n        }\n        return result;\n    };\n    CampaignScopeUserFactAny.prototype.setUserFactsProvider = function (userFactsProvider) {\n        this.userFactsProvider = userFactsProvider;\n    };\n    // @Override\n    CampaignScopeUserFactAny.prototype.isInScope = function () {\n        var _this = this;\n        if (isNOU(this.userFacts)) {\n            return true;\n        }\n        if (!this.userFactsProvider) {\n            return false;\n        }\n        // If one of the user fact matches, then this is a yes\n        return this.userFacts.some(function (userFact) {\n            var rawUserFact = _this.userFactsProvider.getUserFact(userFact.getName());\n            return userFact.isAMatch(rawUserFact);\n        });\n    };\n    // @Override\n    CampaignScopeUserFactAny.prototype.validate = function () {\n        if (!_super.prototype.validate.call(this)) {\n            return false;\n        }\n        return UserFactHelper_1.validateUserFacts(this.userFacts);\n    };\n    return CampaignScopeUserFactAny;\n}(CampaignScope));\nexports.CampaignScopeUserFactAny = CampaignScopeUserFactAny;\nvar CampaignScopeUserFactAll = /** @class */ (function (_super) {\n    __extends(CampaignScopeUserFactAll, _super);\n    // public for UT only\n    function CampaignScopeUserFactAll() {\n        return _super.call(this) || this;\n    }\n    CampaignScopeUserFactAll.deserialize = function (input) {\n        var result = new CampaignScopeUserFactAll();\n        result.userFacts = UserFactHelper_1.deserializeUserFacts(input);\n        if (!result.validate()) {\n            return null;\n        }\n        return result;\n    };\n    CampaignScopeUserFactAll.prototype.setUserFactsProvider = function (userFactsProvider) {\n        this.userFactsProvider = userFactsProvider;\n    };\n    // @Override\n    CampaignScopeUserFactAll.prototype.isInScope = function () {\n        var _this = this;\n        if (isNOU(this.userFacts)) {\n            return true;\n        }\n        if (!this.userFactsProvider) {\n            return false;\n        }\n        // Get all of the mismatched user facts\n        var mismatchedFacts = this.userFacts.filter(function (userFact) {\n            var rawUserFact = _this.userFactsProvider.getUserFact(userFact.getName());\n            return !userFact.isAMatch(rawUserFact);\n        });\n        if (mismatchedFacts.length > 0) {\n            var mismatchedNames = mismatchedFacts.map(function (userFact) { return userFact.getName(); });\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.Floodgate.UserFactsSpecIsAMatch.Summary, {\n                Count: mismatchedFacts.length,\n                Message: mismatchedNames.toString(),\n            });\n            return false;\n        }\n        // If all of the user facts match, then this is a yes\n        return true;\n    };\n    // @Override\n    CampaignScopeUserFactAll.prototype.validate = function () {\n        if (!_super.prototype.validate.call(this)) {\n            return false;\n        }\n        return UserFactHelper_1.validateUserFacts(this.userFacts);\n    };\n    return CampaignScopeUserFactAll;\n}(CampaignScope));\nexports.CampaignScopeUserFactAll = CampaignScopeUserFactAll;\n// endregion\n// region Durations\n/**\n * Base class representing a duration in a campaign setting\n */\nvar CampaignDuration = /** @class */ (function () {\n    function CampaignDuration() {\n    }\n    CampaignDuration.deserialize = function (input) {\n        var result;\n        if (isNOU(input)) {\n            return null;\n        }\n        switch (input.Type) {\n            case 0:\n                result = CampaignDurationTimeInterval.deserialize(input);\n                break;\n            case 1:\n                result = CampaignDurationSingleBuildChange.deserialize(input);\n                break;\n        }\n        if (result === undefined) {\n            return null;\n        }\n        return result;\n    };\n    CampaignDuration.prototype.validate = function () {\n        return true;\n    };\n    return CampaignDuration;\n}());\nexports.CampaignDuration = CampaignDuration;\n/**\n * A Duration expressed in seconds. UTC datetime comparisons are used to determine expiration.\n */\nvar CampaignDurationTimeInterval = /** @class */ (function (_super) {\n    __extends(CampaignDurationTimeInterval, _super);\n    // public for UT only\n    function CampaignDurationTimeInterval() {\n        return _super.call(this) || this;\n    }\n    CampaignDurationTimeInterval.deserialize = function (input) {\n        var result = new CampaignDurationTimeInterval();\n        if (input) {\n            result.intervalSeconds = input.IntervalSeconds;\n        }\n        if (!result.validate()) {\n            return null;\n        }\n        return result;\n    };\n    // @Override\n    CampaignDurationTimeInterval.prototype.asTimeIntervalSeconds = function () {\n        return this.intervalSeconds;\n    };\n    // @Override\n    CampaignDurationTimeInterval.prototype.validate = function () {\n        if (!_super.prototype.validate.call(this)) {\n            return false;\n        }\n        if (!isNumber(this.intervalSeconds)) {\n            return false;\n        }\n        return true;\n    };\n    return CampaignDurationTimeInterval;\n}(CampaignDuration));\nexports.CampaignDurationTimeInterval = CampaignDurationTimeInterval;\n/**\n * A Duration representing exactly 1 change in build number\n */\nvar CampaignDurationSingleBuildChange = /** @class */ (function (_super) {\n    __extends(CampaignDurationSingleBuildChange, _super);\n    // public for UT only\n    function CampaignDurationSingleBuildChange() {\n        return _super.call(this) || this;\n    }\n    CampaignDurationSingleBuildChange.deserialize = function (input) {\n        return new CampaignDurationSingleBuildChange();\n    };\n    // @Override\n    CampaignDurationSingleBuildChange.prototype.asTimeIntervalSeconds = function () {\n        return null;\n    };\n    return CampaignDurationSingleBuildChange;\n}(CampaignDuration));\nexports.CampaignDurationSingleBuildChange = CampaignDurationSingleBuildChange;\n/**\n * Class representing AdditionalDataRequested in CampaignDefinition\n */\nvar CampaignAdditionalDataRequested = /** @class */ (function () {\n    function CampaignAdditionalDataRequested() {\n    }\n    CampaignAdditionalDataRequested.deserialize = function (additionalDataRequested) {\n        var result = new CampaignAdditionalDataRequested();\n        if (!isNOU(additionalDataRequested)) {\n            // Convert from AdditionalDataRequested string to enum\n            result.additionalData = [];\n            for (var _i = 0, additionalDataRequested_1 = additionalDataRequested; _i < additionalDataRequested_1.length; _i++) {\n                var additionalData = additionalDataRequested_1[_i];\n                if (additionalData === "EmailAddress") {\n                    result.additionalData.push(0 /* EmailAddress */);\n                }\n            }\n        }\n        if (!result.validate()) {\n            return null;\n        }\n        return result;\n    };\n    CampaignAdditionalDataRequested.prototype.validate = function () {\n        if (isNOU(this.additionalData)) {\n            return false;\n        }\n        return true;\n    };\n    return CampaignAdditionalDataRequested;\n}());\nexports.CampaignAdditionalDataRequested = CampaignAdditionalDataRequested;\n// endregion\n// region Distribution Schemes\nvar CampaignDistribution = /** @class */ (function () {\n    function CampaignDistribution() {\n    }\n    CampaignDistribution.deserialize = function (input) {\n        var result;\n        if (input && input.Type === 0) {\n            result = CampaignDistributionRamp.deserialize(input);\n        }\n        if (result === undefined) {\n            return null;\n        }\n        return result;\n    };\n    CampaignDistribution.prototype.validate = function () {\n        return true;\n    };\n    return CampaignDistribution;\n}());\nexports.CampaignDistribution = CampaignDistribution;\nvar CampaignDistributionRamp = /** @class */ (function (_super) {\n    __extends(CampaignDistributionRamp, _super);\n    function CampaignDistributionRamp() {\n        return _super.call(this) || this;\n    }\n    CampaignDistributionRamp.deserialize = function (input) {\n        var result = new CampaignDistributionRamp();\n        if (input) {\n            result.maxDelaySeconds = input.MaxDelaySeconds;\n            result.chunks = input.Chunks;\n        }\n        if (!result.validate()) {\n            return null;\n        }\n        return result;\n    };\n    // @Override\n    CampaignDistributionRamp.prototype.validate = function () {\n        if (!_super.prototype.validate.call(this)) {\n            return false;\n        }\n        if (!isNumber(this.maxDelaySeconds) || this.maxDelaySeconds < 0) {\n            return false;\n        }\n        if (!isNumber(this.chunks) || this.chunks < 0) {\n            return false;\n        }\n        return true;\n    };\n    return CampaignDistributionRamp;\n}(CampaignDistribution));\nexports.CampaignDistributionRamp = CampaignDistributionRamp;\n// endregion\n// region Nomination Scheme\nvar CampaignNominationScheme = /** @class */ (function () {\n    function CampaignNominationScheme() {\n    }\n    CampaignNominationScheme.deserialize = function (input) {\n        var result;\n        if (input && input.Type === 0) {\n            result = CampaignNominationSchemeRatioPercentage.deserialize(input);\n        }\n        if (result === undefined) {\n            return null;\n        }\n        return result;\n    };\n    /**\n     * @return The amount of time the survey should be active, in seconds. Abstracts the difference between nominationPeriod and the fallback\n     */\n    CampaignNominationScheme.prototype.getActiveSurveyTimeIntervalSeconds = function () {\n        var nominationTimIntervalSeconds = this.nominationPeriod.asTimeIntervalSeconds();\n        if (isNumber(nominationTimIntervalSeconds)) {\n            return nominationTimIntervalSeconds;\n        }\n        return this.fallbackSurveyDurationSeconds;\n    };\n    /**\n     * @return The survey start time, possibly adjusted by an underlying DistributionModel.\n     */\n    CampaignNominationScheme.prototype.calculateSurveyStartTimeFromDate = function (soonestStartTime) {\n        // No adjustment in base class.  Derived classes can override and implement delays like a "ramp"\n        return soonestStartTime ? soonestStartTime : new Date();\n    };\n    /**\n     * @return The survey expiration time, based on the nomination periods and the survey\'s adjusted start time\n     */\n    CampaignNominationScheme.prototype.calculateSurveyExpirationTimeFromSurveyStartTime = function (surveyStartTime) {\n        surveyStartTime = surveyStartTime ? surveyStartTime : new Date();\n        return Utils.addSecondsWithoutOverflow(surveyStartTime, this.getActiveSurveyTimeIntervalSeconds());\n    };\n    /**\n     * @return The appropriate campaign cool down based on whether or not the user activated the survey\n     */\n    CampaignNominationScheme.prototype.getCampaignCooldown = function (didUserActivateSurvey) {\n        if (didUserActivateSurvey) {\n            return this.cooldownPeriod;\n        }\n        else {\n            return this.nominationPeriod;\n        }\n    };\n    CampaignNominationScheme.prototype.validate = function () {\n        if (isNOU(this.nominationPeriod)) {\n            return false;\n        }\n        if (isNOU(this.cooldownPeriod)) {\n            this.cooldownPeriod = this.nominationPeriod;\n        }\n        if (!isNumber(this.nominationPeriod.asTimeIntervalSeconds())) {\n            if (!isNumber(this.fallbackSurveyDurationSeconds) || this.fallbackSurveyDurationSeconds <= 0) {\n                return false;\n            }\n        }\n        return true;\n    };\n    return CampaignNominationScheme;\n}());\nexports.CampaignNominationScheme = CampaignNominationScheme;\n/**\n * Class representing a set of campaign nomination rules to evaluate for in-scope campaigns:\n * percentage\n * re-election durations\n * distribution model (for "nominated" candidates)\n */\nvar CampaignNominationSchemeRatioPercentage = /** @class */ (function (_super) {\n    __extends(CampaignNominationSchemeRatioPercentage, _super);\n    function CampaignNominationSchemeRatioPercentage() {\n        return _super.call(this) || this;\n    }\n    CampaignNominationSchemeRatioPercentage.deserialize = function (input) {\n        var result = new CampaignNominationSchemeRatioPercentage();\n        if (isNOU(input)) {\n            return null;\n        }\n        if (input.DistributionModel) {\n            result.distributionModel = CampaignDistribution.deserialize(input.DistributionModel);\n        }\n        if (input.CooldownPeriod) {\n            result.cooldownPeriod = CampaignDuration.deserialize(input.CooldownPeriod);\n        }\n        if (input.NominationPeriod) {\n            result.nominationPeriod = CampaignDuration.deserialize(input.NominationPeriod);\n        }\n        result.fallbackSurveyDurationSeconds = input.FallbackSurveyDurationSeconds;\n        result.percentageDenominator = input.PercentageDenominator;\n        result.percentageNumerator = input.PercentageNumerator;\n        if (!result.validate()) {\n            return null;\n        }\n        return result;\n    };\n    // @Override\n    CampaignNominationSchemeRatioPercentage.prototype.evaluateNominationRules = function () {\n        var rand = Math.random();\n        // Creates a random number between [0 to (percentageDenominator - 1)]\n        // In range [0 to (percentageDenominator - 1)] exactly \'percentageNumerator\' values are < percentageNumerator\n        return Math.floor(rand * this.percentageDenominator) < this.percentageNumerator;\n    };\n    // @Override\n    CampaignNominationSchemeRatioPercentage.prototype.validate = function () {\n        if (!_super.prototype.validate.call(this)) {\n            return false;\n        }\n        if (!isNumber(this.percentageDenominator) || !isNumber(this.percentageNumerator)) {\n            return false;\n        }\n        if (this.percentageDenominator <= 0 || this.percentageNumerator < 0) {\n            return false;\n        }\n        if (this.percentageNumerator > this.percentageDenominator) {\n            return false;\n        }\n        // distribution model may be null\n        return true;\n    };\n    return CampaignNominationSchemeRatioPercentage;\n}(CampaignNominationScheme));\nexports.CampaignNominationSchemeRatioPercentage = CampaignNominationSchemeRatioPercentage;\n// endregion\n// region Survey Event Definitions\nvar CampaignSurveyEvent = /** @class */ (function () {\n    function CampaignSurveyEvent() {\n    }\n    CampaignSurveyEvent.deserialize = function (input) {\n        var result;\n        if (isNOU(input)) {\n            return null;\n        }\n        switch (input.Type) {\n            case 0:\n                result = CampaignSurveyEventCountedActivity.deserialize(input);\n                break;\n            case 1:\n                result = CampaignSurveyEventCountedActivitySequence.deserialize(input);\n                break;\n        }\n        if (result === undefined) {\n            return null;\n        }\n        return result;\n    };\n    CampaignSurveyEvent.prototype.validate = function () {\n        return true;\n    };\n    return CampaignSurveyEvent;\n}());\nexports.CampaignSurveyEvent = CampaignSurveyEvent;\nvar CampaignSurveyEventCountedActivity = /** @class */ (function (_super) {\n    __extends(CampaignSurveyEventCountedActivity, _super);\n    // public for UT only\n    function CampaignSurveyEventCountedActivity() {\n        return _super.call(this) || this;\n    }\n    CampaignSurveyEventCountedActivity.deserialize = function (input) {\n        var result = new CampaignSurveyEventCountedActivity();\n        if (isNOU(input)) {\n            return null;\n        }\n        result.activity = input.Activity;\n        result.count = input.Count;\n        result.isAggregate = input.IsAggregate;\n        if (!result.validate()) {\n            return null;\n        }\n        return result;\n    };\n    // @Override\n    CampaignSurveyEventCountedActivity.prototype.validate = function () {\n        if (!_super.prototype.validate.call(this)) {\n            return false;\n        }\n        if (isNOU(this.activity) || !isString(this.activity)) {\n            return false;\n        }\n        if (!isNumber(this.count) || this.count <= 0) {\n            return false;\n        }\n        if (!isBoolean(this.isAggregate)) {\n            return false;\n        }\n        return true;\n    };\n    return CampaignSurveyEventCountedActivity;\n}(CampaignSurveyEvent));\nexports.CampaignSurveyEventCountedActivity = CampaignSurveyEventCountedActivity;\nvar CampaignSurveyEventCountedActivitySequence = /** @class */ (function (_super) {\n    __extends(CampaignSurveyEventCountedActivitySequence, _super);\n    // public for UT only\n    function CampaignSurveyEventCountedActivitySequence() {\n        return _super.call(this) || this;\n    }\n    CampaignSurveyEventCountedActivitySequence.deserialize = function (input) {\n        var result = new CampaignSurveyEventCountedActivitySequence();\n        var sequence = [];\n        if (isNOU(input)) {\n            return null;\n        }\n        for (var key in input.Sequence) {\n            if (Object.prototype.hasOwnProperty.call(input.Sequence, key)) {\n                var readActivity = input.Sequence[key];\n                if (readActivity) {\n                    sequence.push(CampaignSurveyEventCountedActivity.deserialize(readActivity));\n                }\n            }\n        }\n        if (sequence.length === 0) {\n            sequence = null;\n        }\n        result.sequence = sequence;\n        if (!result.validate()) {\n            return null;\n        }\n        return result;\n    };\n    // @Override\n    CampaignSurveyEventCountedActivitySequence.prototype.validate = function () {\n        if (!_super.prototype.validate.call(this)) {\n            return false;\n        }\n        if (isNOU(this.sequence)) {\n            return false;\n        }\n        for (var key in this.sequence) {\n            if (Object.prototype.hasOwnProperty.call(this.sequence, key) && !this.sequence[key]) {\n                return false;\n            }\n        }\n        return true;\n    };\n    return CampaignSurveyEventCountedActivitySequence;\n}(CampaignSurveyEvent));\nexports.CampaignSurveyEventCountedActivitySequence = CampaignSurveyEventCountedActivitySequence;\n// endregion\n// region Survey Content Definitions\nvar CampaignSurveyContent = /** @class */ (function () {\n    function CampaignSurveyContent() {\n    }\n    CampaignSurveyContent.deserialize = function (input, optionalComponents) {\n        var result = new CampaignSurveyContent();\n        if (isNOU(input)) {\n            return null;\n        }\n        result.prompt = CampaignSurveyContentPrompt.deserialize(input.Prompt);\n        result.rating = CampaignSurveyContentRating.deserialize(input.Rating);\n        result.comment = CampaignSurveyContentComment.deserialize(input.Question);\n        result.multipleChoice = CampaignSurveyContentMultipleChoice.deserialize(input.MultipleChoice);\n        result.intercept = CampaignSurveyContentIntercept.deserialize(input.Intercept);\n        result.cvSurvey = CampaignSurveyContentCVSurvey.deserialize(input.CVSurveyParams);\n        if (!result.validate(optionalComponents)) {\n            return null;\n        }\n        return result;\n    };\n    CampaignSurveyContent.prototype.validate = function (optionalComponents) {\n        if (!isNOU(this.intercept)) {\n            // An intercept survey only requires intercept.\n            return true;\n        }\n        if (isNOU(this.prompt)) {\n            return false;\n        }\n        if (optionalComponents) {\n            return !isNOU(this.rating) ||\n                !isNOU(this.multipleChoice) ||\n                !isNOU(this.comment);\n        }\n        return !isNOU(this.rating) && !isNOU(this.comment);\n    };\n    return CampaignSurveyContent;\n}());\nexports.CampaignSurveyContent = CampaignSurveyContent;\nvar CampaignSurveyContentMultipleChoice = /** @class */ (function () {\n    function CampaignSurveyContentMultipleChoice() {\n    }\n    CampaignSurveyContentMultipleChoice.deserialize = function (input) {\n        var result = new CampaignSurveyContentMultipleChoice();\n        if (isNOU(input)) {\n            return null;\n        }\n        result.question = input.Question;\n        result.availableOptions = input.AvailableOptions;\n        result.minNumberOfSelectedOptions = input.MinNumberOfSelectedOptions;\n        result.maxNumberOfSelectedOptions = input.MaxNumberOfSelectedOptions;\n        if (!result.validate()) {\n            return null;\n        }\n        return result;\n    };\n    CampaignSurveyContentMultipleChoice.prototype.validate = function () {\n        if (isNOU(this.question) || !isString(this.question) ||\n            isNOU(this.availableOptions) || !Array.isArray(this.availableOptions) || this.availableOptions.length < 2 ||\n            isNOU(this.minNumberOfSelectedOptions) || !isNumber(this.minNumberOfSelectedOptions) ||\n            isNOU(this.maxNumberOfSelectedOptions) || !isNumber(this.maxNumberOfSelectedOptions)) {\n            return false;\n        }\n        // expect all availableOptions values to be string\n        for (var key in this.availableOptions) {\n            if (Object.prototype.hasOwnProperty.call(this.availableOptions, key)) {\n                if (!isString(this.availableOptions[key])) {\n                    return false;\n                }\n            }\n        }\n        return true;\n    };\n    return CampaignSurveyContentMultipleChoice;\n}());\nexports.CampaignSurveyContentMultipleChoice = CampaignSurveyContentMultipleChoice;\nvar CampaignSurveyContentCVSurvey = /** @class */ (function () {\n    function CampaignSurveyContentCVSurvey() {\n    }\n    CampaignSurveyContentCVSurvey.deserialize = function (input) {\n        var result = new CampaignSurveyContentCVSurvey();\n        if (isNOU(input)) {\n            return null;\n        }\n        result.customerVoiceFormId = input.CustomerVoiceFormId;\n        if (!result.validate()) {\n            return null;\n        }\n        return result;\n    };\n    CampaignSurveyContentCVSurvey.prototype.validate = function () {\n        return (!isNOU(this.customerVoiceFormId) && isString(this.customerVoiceFormId));\n    };\n    return CampaignSurveyContentCVSurvey;\n}());\nexports.CampaignSurveyContentCVSurvey = CampaignSurveyContentCVSurvey;\nvar CampaignSurveyContentPrompt = /** @class */ (function () {\n    function CampaignSurveyContentPrompt() {\n    }\n    CampaignSurveyContentPrompt.deserialize = function (input) {\n        var result = new CampaignSurveyContentPrompt();\n        if (isNOU(input)) {\n            return null;\n        }\n        result.title = input.Title;\n        result.question = input.Question;\n        result.yesLabel = input.YesLabel;\n        result.noLabel = input.NoLabel;\n        if (!result.validate()) {\n            return null;\n        }\n        return result;\n    };\n    CampaignSurveyContentPrompt.prototype.validate = function () {\n        if (isNOU(this.title) || !isString(this.title) ||\n            isNOU(this.question) || !isString(this.question) ||\n            isNOU(this.yesLabel) || !isString(this.yesLabel) ||\n            isNOU(this.noLabel) || !isString(this.noLabel)) {\n            return false;\n        }\n        return true;\n    };\n    return CampaignSurveyContentPrompt;\n}());\nexports.CampaignSurveyContentPrompt = CampaignSurveyContentPrompt;\nvar CampaignSurveyContentIntercept = /** @class */ (function () {\n    function CampaignSurveyContentIntercept() {\n    }\n    CampaignSurveyContentIntercept.deserialize = function (input) {\n        var result = new CampaignSurveyContentIntercept();\n        if (isNOU(input)) {\n            return null;\n        }\n        result.title = input.Title;\n        result.question = input.Question;\n        result.url = input.Url;\n        if (!result.validate()) {\n            return null;\n        }\n        return result;\n    };\n    CampaignSurveyContentIntercept.prototype.validate = function () {\n        if (isNOU(this.title) || !isString(this.title) ||\n            isNOU(this.question) || !isString(this.question) ||\n            isNOU(this.url) || !isString(this.url)) {\n            return false;\n        }\n        return true;\n    };\n    return CampaignSurveyContentIntercept;\n}());\nexports.CampaignSurveyContentIntercept = CampaignSurveyContentIntercept;\nvar CampaignSurveyContentRating = /** @class */ (function () {\n    function CampaignSurveyContentRating() {\n    }\n    CampaignSurveyContentRating.deserialize = function (input) {\n        var result = new CampaignSurveyContentRating();\n        if (isNOU(input)) {\n            return null;\n        }\n        result.isZeroBased = input.IsZeroBased;\n        result.question = input.Question;\n        result.ratingValuesAscending = input.RatingValuesAscending;\n        if (!result.validate()) {\n            return null;\n        }\n        return result;\n    };\n    CampaignSurveyContentRating.prototype.validate = function () {\n        // expect ratingValuesAscending to contain between 2 to 11 values\n        if (isNOU(this.question) || !isString(this.question) ||\n            isNOU(this.ratingValuesAscending) || !Array.isArray(this.ratingValuesAscending) ||\n            this.ratingValuesAscending.length < 2 || this.ratingValuesAscending.length > 11) {\n            return false;\n        }\n        if (isNOU(this.isZeroBased)) {\n            // default to false if not provided\n            this.isZeroBased = false;\n        }\n        else if (!isBoolean(this.isZeroBased)) {\n            // fail validation if non boolean value is provided\n            return false;\n        }\n        // expect all ratingValuesAscending values to be string\n        for (var key in this.ratingValuesAscending) {\n            if (Object.prototype.hasOwnProperty.call(this.ratingValuesAscending, key)) {\n                if (!isString(this.ratingValuesAscending[key])) {\n                    return false;\n                }\n            }\n        }\n        return true;\n    };\n    return CampaignSurveyContentRating;\n}());\nexports.CampaignSurveyContentRating = CampaignSurveyContentRating;\nvar CampaignSurveyContentComment = /** @class */ (function () {\n    function CampaignSurveyContentComment() {\n    }\n    CampaignSurveyContentComment.deserialize = function (input) {\n        var result = new CampaignSurveyContentComment();\n        if (isNOU(input)) {\n            return null;\n        }\n        // @SerializedName("Question")\n        result.question = input.Question;\n        if (!result.validate()) {\n            return null;\n        }\n        return result;\n    };\n    CampaignSurveyContentComment.prototype.validate = function () {\n        if (isNOU(this.question) || !isString(this.question)) {\n            return false;\n        }\n        return true;\n    };\n    return CampaignSurveyContentComment;\n}());\nexports.CampaignSurveyContentComment = CampaignSurveyContentComment;\n// endregion\n// region Survey Metadata Definitions\nvar CampaignSurveyMetadata = /** @class */ (function () {\n    function CampaignSurveyMetadata() {\n    }\n    CampaignSurveyMetadata.deserialize = function (input) {\n        if (isNOU(input)) {\n            return null;\n        }\n        var result = new CampaignSurveyMetadata();\n        result.contentMetadata = input.ContentMetadata;\n        if (!result.validate()) {\n            return null;\n        }\n        return result;\n    };\n    CampaignSurveyMetadata.prototype.validate = function () {\n        if (isNOU(this.contentMetadata) || !Utils.isObject(this.contentMetadata)) {\n            return false;\n        }\n        return true;\n    };\n    return CampaignSurveyMetadata;\n}());\nexports.CampaignSurveyMetadata = CampaignSurveyMetadata;\n// endregion\n// region Survey Template definitions\nvar CampaignSurveyTemplate = /** @class */ (function () {\n    function CampaignSurveyTemplate() {\n    }\n    CampaignSurveyTemplate.deserialize = function (input) {\n        var _a, _b, _c, _d, _e, _f, _g;\n        var result;\n        var validationError = \'\';\n        if (isNOU(input)) {\n            return [null, \'deserialize parameter is null\'];\n        }\n        switch (input.Type) {\n            case 0 /* Nps5PointStatic */:\n                _a = CampaignSurveyTemplateNps5PointStatic.deserialize(input), result = _a[0], validationError = _a[1];\n                break;\n            case 1 /* Nps11PointStatic */:\n                _b = CampaignSurveyTemplateNps11PointStatic.deserialize(input), result = _b[0], validationError = _b[1];\n                break;\n            case 2 /* Fps */:\n                _c = CampaignSurveyTemplateFps.deserialize(input), result = _c[0], validationError = _c[1];\n                break;\n            case 3 /* Nlqs */:\n                _d = CampaignSurveyTemplateNlqs.deserialize(input), result = _d[0], validationError = _d[1];\n                break;\n            case 4 /* Nps */:\n                _e = CampaignSurveyTemplateNps.deserialize(input), result = _e[0], validationError = _e[1];\n                break;\n            case 22 /* GenericMessagingSurface */:\n                _f = CampaignSurveyTemplateGenericMessagingSurface.deserialize(input), result = _f[0], validationError = _f[1];\n                break;\n            case 5 /* Intercept */:\n                _g = CampaignSurveyTemplateIntercept.deserialize(input), result = _g[0], validationError = _g[1];\n                break;\n        }\n        if (isNOU(result)) {\n            return [null, validationError];\n        }\n        return [result, validationError];\n    };\n    CampaignSurveyTemplate.prototype.validate = function () {\n        var _this = this;\n        var _a, _b, _c;\n        if (isNOU(this.activationEvent)) {\n            return \'The survey template is missing the activation event.\';\n        }\n        // Validate UX Schema\n        if (this.uxSchema) {\n            // Schema pages validation\n            var pagesValidityError = this.validatePages(this.uxSchema.pages);\n            if (pagesValidityError) {\n                return pagesValidityError;\n            }\n            // Schema variables validation\n            if (this.uxSchema.variables) {\n                for (var _i = 0, _d = Object.keys(this.uxSchema.variables); _i < _d.length; _i++) {\n                    var key = _d[_i];\n                    if (this.uxSchema.variables[key] === null || this.uxSchema.variables[key] === undefined) {\n                        return "Schema variable of key " + key + " does not have a corresponding value.";\n                    }\n                    if (Object.prototype.hasOwnProperty.call(dynamicUxSchemaVariables, key)) {\n                        this.uxSchema.variables[key] = dynamicUxSchemaVariables[key];\n                    }\n                    else {\n                        return "Host app does not provide Schema variable of key " + key + ".";\n                    }\n                }\n            }\n            // Additional capabilities validation\n            if (this.uxSchema.additionalCapabilities) {\n                if (((_a = this.uxSchema.additionalCapabilities[floodgate_shared_typings_1.IUxSchemaAdditionalCapabilitiesTypes.Email]) === null || _a === void 0 ? void 0 : _a.targetPage) == null) {\n                    return \'Schema additional capability of Email is defined but has no target page.\';\n                }\n                else {\n                    var targetPage = (_b = this.uxSchema.additionalCapabilities[floodgate_shared_typings_1.IUxSchemaAdditionalCapabilitiesTypes.Email]) === null || _b === void 0 ? void 0 : _b.targetPage;\n                    if (targetPage < 0 || targetPage >= this.uxSchema.pages.length) {\n                        return "Schema additional capability of Email has its target page equal to " + targetPage + " which is out of range.";\n                    }\n                }\n            }\n            // Branching rules validation\n            if (this.uxSchema.branchingRules && Array.isArray(this.uxSchema.branchingRules) && this.uxSchema.branchingRules.length > 0) {\n                for (var _e = 0, _f = this.uxSchema.branchingRules; _e < _f.length; _e++) {\n                    var rule = _f[_e];\n                    if (rule.conditions && Array.isArray(rule.conditions) && rule.conditions.length > 0) {\n                        var _loop_1 = function (condition) {\n                            if (condition.conditionType == null ||\n                                condition.conditionValue == null ||\n                                condition.sourceId == null ||\n                                condition.sourceType == null) {\n                                return { value: \'A condition in the branching rules is missing a type/value/sourceId/sourceType.\' };\n                            }\n                            else {\n                                if (condition.sourceType === floodgate_shared_typings_1.ConditionSourceType.Variable) {\n                                    if (!this_1.uxSchema.variables ||\n                                        !Object.keys(this_1.uxSchema.variables).includes(condition.sourceId)) {\n                                        return { value: "The variable " + condition.sourceId + " is used in the branching rules but not defined among the schema variables." };\n                                    }\n                                }\n                                else {\n                                    if (condition.sourcePageIndex == null) {\n                                        return { value: \'A condition in the branching rules of type question is missing a sourcePageIndex.\' };\n                                    }\n                                    else {\n                                        var questionIndex = (_c = this_1.uxSchema.pages[condition.sourcePageIndex]) === null || _c === void 0 ? void 0 : _c.questions.findIndex(function (question) { return question.id === condition.sourceId; });\n                                        if (questionIndex == null || questionIndex < 0) {\n                                            return { value: "The target question with id " + condition.sourceId + " does not exist." };\n                                        }\n                                        else if (condition.subSourceIndex) {\n                                            if (this_1.uxSchema.pages[condition.sourcePageIndex].questions[questionIndex].type != floodgate_shared_typings_1.QuestionType.Likert) {\n                                                return { value: "A subsource page index of " + condition.subSourceIndex + " is provided\\nbut the question with id " + condition.sourceId + " is not of type Likert." };\n                                            }\n                                            else {\n                                                var likertQuestion = this_1.uxSchema.pages[condition.sourcePageIndex].questions[questionIndex];\n                                                if (likertQuestion.horizontalStatements.length <= condition.subSourceIndex) {\n                                                    return { value: "The likert question with id " + condition.sourceId + " doesn\'t have\\na horizontal option with index " + condition.subSourceIndex + "." };\n                                                }\n                                            }\n                                        }\n                                    }\n                                }\n                            }\n                        };\n                        var this_1 = this;\n                        for (var _g = 0, _h = rule.conditions; _g < _h.length; _g++) {\n                            var condition = _h[_g];\n                            var state_1 = _loop_1(condition);\n                            if (typeof state_1 === "object")\n                                return state_1.value;\n                        }\n                    }\n                    if (rule.targets && Array.isArray(rule.targets) && rule.targets.length > 0) {\n                        var _loop_2 = function (target) {\n                            if (target.type === floodgate_shared_typings_1.BranchingTargetType.Page) {\n                                var pageTarget = target;\n                                if (pageTarget.hiddenPageIndices.filter(function (index) { return index < 0; }).length > 0 ||\n                                    pageTarget.hiddenPageIndices.filter(function (index) { return index >= _this.uxSchema.pages.length; }).length > 0) {\n                                    return { value: \'Some of the hidden pages indexes are out of range.\' };\n                                }\n                            }\n                            else {\n                                var overrideTarget_1 = target;\n                                if (overrideTarget_1.targetPageIndex < 0 || overrideTarget_1.targetPageIndex >= this_2.uxSchema.pages.length) {\n                                    return { value: \'An override target has its page index out of range.\' };\n                                }\n                                else {\n                                    var overrideTargetQuestion = this_2.uxSchema.pages[overrideTarget_1.targetPageIndex].questions.find(function (question) {\n                                        return question.id === overrideTarget_1.targetOverrideId;\n                                    });\n                                    if (!overrideTargetQuestion) {\n                                        return { value: "An override target\'s question on page " + overrideTarget_1.targetPageIndex + " does not exist" };\n                                    }\n                                }\n                            }\n                        };\n                        var this_2 = this;\n                        for (var _j = 0, _k = rule.targets; _j < _k.length; _j++) {\n                            var target = _k[_j];\n                            var state_2 = _loop_2(target);\n                            if (typeof state_2 === "object")\n                                return state_2.value;\n                        }\n                    }\n                }\n            }\n        }\n        return \'\';\n    };\n    CampaignSurveyTemplate.prototype.validatePages = function (schemaPages) {\n        if (!schemaPages || !Array.isArray(schemaPages) || schemaPages.length === 0) {\n            return \'Schema has no pages.\';\n        }\n        else {\n            for (var _i = 0, schemaPages_1 = schemaPages; _i < schemaPages_1.length; _i++) {\n                var page = schemaPages_1[_i];\n                if (!page.id) {\n                    return \'Page is missing an id.\';\n                }\n                else if (page.displayName == null) {\n                    return \'Page is missing a displayName.\';\n                }\n                else if (!page.questions || !Array.isArray(page.questions) || page.questions.length === 0) {\n                    return "Page " + page.id + " does not have any questions.";\n                }\n                else {\n                    for (var _a = 0, _b = page.questions; _a < _b.length; _a++) {\n                        var question = _b[_a];\n                        var questionError = this.validateQuestion(question);\n                        if (questionError) {\n                            return "On page " + page.id + " " + questionError;\n                        }\n                    }\n                }\n            }\n        }\n        return \'\';\n    };\n    CampaignSurveyTemplate.prototype.validateQuestion = function (question) {\n        var questionError = \'\';\n        if (!question.id || !question.questionLabel || !question.type) {\n            questionError += \'the question is missing one of the following properties: id, label or question type.\';\n        }\n        else {\n            if (question.type === floodgate_shared_typings_1.QuestionType.SingleSelect &&\n                (!question.availableOptions || !Array.isArray(question.availableOptions) ||\n                    question.availableOptions.length < 2 || question.availableOptions.length > 11)) {\n                questionError += "the question " + question.id + " of type SingleSelect must have at least 2 and at most 11 available options.";\n            }\n            if (question.type == floodgate_shared_typings_1.QuestionType.MultipleChoice &&\n                (!question.availableOptions || !Array.isArray(question.availableOptions) ||\n                    question.availableOptions.length < 2 || question.availableOptions.length > 11)) {\n                questionError += "the question " + question.id + " of type MultipleChoice must have at least 2 and at most 11 available options.";\n            }\n            if (question.type === floodgate_shared_typings_1.QuestionType.Rating && (!question.leftLegendValue || !question.rightLegendValue ||\n                !question.ratingValues || !Array.isArray(question.ratingValues) ||\n                question.ratingValues.length < 2 || question.ratingValues.length > 11)) {\n                questionError +=\n                    "the question " + question.id + " of type rating must have a right and left legend and have at least 2 and at most 11 rating values.";\n            }\n            if (question.type === floodgate_shared_typings_1.QuestionType.Likert &&\n                (!question.horizontalStatements || !Array.isArray(question.horizontalStatements) ||\n                    !question.verticalOptions || !Array.isArray(question.verticalOptions) ||\n                    question.horizontalStatements.length < 1 || question.horizontalStatements.length > 10 ||\n                    question.verticalOptions.length < 2 || question.verticalOptions.length > 7)) {\n                questionError += "the question " + question.id + " of type Likert must have\\nat least 2 and at most 7 vertical options and at least 1 and at most 10 horizontal options.";\n            }\n        }\n        return questionError;\n    };\n    return CampaignSurveyTemplate;\n}());\nexports.CampaignSurveyTemplate = CampaignSurveyTemplate;\nvar CampaignSurveyTemplateFps = /** @class */ (function (_super) {\n    __extends(CampaignSurveyTemplateFps, _super);\n    // public for UT only\n    function CampaignSurveyTemplateFps() {\n        return _super.call(this) || this;\n    }\n    CampaignSurveyTemplateFps.deserialize = function (input) {\n        var result = new CampaignSurveyTemplateFps();\n        if (isNOU(input)) {\n            return [null, \'deserialize parameter is null\'];\n        }\n        result.activationEvent = CampaignSurveyEvent.deserialize(input.ActivationEvent);\n        result.content = CampaignSurveyContent.deserialize(input.Content, true /* optionalComponents */);\n        result.uxSchema = input.UxSchema;\n        var validationError = result.validate();\n        if (validationError) {\n            result = null;\n        }\n        return [result, validationError];\n    };\n    CampaignSurveyTemplateFps.prototype.validate = function () {\n        var validationError = _super.prototype.validate.call(this);\n        if (validationError) {\n            return validationError;\n        }\n        else if ((isNOU(this.content) && isNOU(this.uxSchema))) {\n            return \'The survey schema does not have any content or ux schema\';\n        }\n        return \'\';\n    };\n    return CampaignSurveyTemplateFps;\n}(CampaignSurveyTemplate));\nexports.CampaignSurveyTemplateFps = CampaignSurveyTemplateFps;\nvar CampaignSurveyTemplateNlqs = /** @class */ (function (_super) {\n    __extends(CampaignSurveyTemplateNlqs, _super);\n    // public for UT only\n    function CampaignSurveyTemplateNlqs() {\n        return _super.call(this) || this;\n    }\n    CampaignSurveyTemplateNlqs.deserialize = function (input) {\n        var result = new CampaignSurveyTemplateNlqs();\n        if (isNOU(input)) {\n            return [null, \'deserialize parameter is null\'];\n        }\n        result.activationEvent = CampaignSurveyEvent.deserialize(input.ActivationEvent);\n        result.content = CampaignSurveyContent.deserialize(input.Content);\n        var validationError = result.validate();\n        if (validationError) {\n            result = null;\n        }\n        return [result, validationError];\n    };\n    CampaignSurveyTemplateNlqs.prototype.validate = function () {\n        var validationError = _super.prototype.validate.call(this);\n        if (validationError) {\n            return validationError;\n        }\n        else if (isNOU(this.content)) {\n            return \'The survey schema does not have any content\';\n        }\n        return \'\';\n    };\n    return CampaignSurveyTemplateNlqs;\n}(CampaignSurveyTemplate));\nexports.CampaignSurveyTemplateNlqs = CampaignSurveyTemplateNlqs;\nvar CampaignSurveyTemplateNps = /** @class */ (function (_super) {\n    __extends(CampaignSurveyTemplateNps, _super);\n    // public for UT only\n    function CampaignSurveyTemplateNps() {\n        return _super.call(this) || this;\n    }\n    CampaignSurveyTemplateNps.deserialize = function (input) {\n        var result = new CampaignSurveyTemplateNps();\n        if (isNOU(input)) {\n            return [null, \'deserialize parameter is null\'];\n        }\n        result.activationEvent = CampaignSurveyEvent.deserialize(input.ActivationEvent);\n        result.content = CampaignSurveyContent.deserialize(input.Content);\n        result.uxSchema = input.UxSchema;\n        var validationError = result.validate();\n        if (validationError) {\n            result = null;\n        }\n        return [result, validationError];\n    };\n    CampaignSurveyTemplateNps.prototype.validate = function () {\n        var validationError = _super.prototype.validate.call(this);\n        if (validationError) {\n            return validationError;\n        }\n        else if (isNOU(this.content) && isNOU(this.uxSchema)) {\n            return \'The survey schema does not have any content or ux schema\';\n        }\n        return \'\';\n    };\n    return CampaignSurveyTemplateNps;\n}(CampaignSurveyTemplate));\nexports.CampaignSurveyTemplateNps = CampaignSurveyTemplateNps;\nvar CampaignSurveyTemplateNps5PointStatic = /** @class */ (function (_super) {\n    __extends(CampaignSurveyTemplateNps5PointStatic, _super);\n    // public for UT only\n    function CampaignSurveyTemplateNps5PointStatic() {\n        return _super.call(this) || this;\n    }\n    CampaignSurveyTemplateNps5PointStatic.deserialize = function (input) {\n        var result = new CampaignSurveyTemplateNps5PointStatic();\n        if (isNOU(input)) {\n            return [null, \'deserialize parameter is null\'];\n        }\n        result.activationEvent = CampaignSurveyEvent.deserialize(input.ActivationEvent);\n        var validationError = result.validate();\n        if (validationError) {\n            result = null;\n        }\n        return [result, validationError];\n    };\n    CampaignSurveyTemplateNps5PointStatic.prototype.validate = function () {\n        return _super.prototype.validate.call(this);\n    };\n    return CampaignSurveyTemplateNps5PointStatic;\n}(CampaignSurveyTemplate));\nexports.CampaignSurveyTemplateNps5PointStatic = CampaignSurveyTemplateNps5PointStatic;\nvar CampaignSurveyTemplateNps11PointStatic = /** @class */ (function (_super) {\n    __extends(CampaignSurveyTemplateNps11PointStatic, _super);\n    function CampaignSurveyTemplateNps11PointStatic() {\n        return _super.call(this) || this;\n    }\n    CampaignSurveyTemplateNps11PointStatic.deserialize = function (input) {\n        var result = new CampaignSurveyTemplateNps11PointStatic();\n        if (isNOU(input)) {\n            return [null, \'deserialize parameter is null\'];\n        }\n        result.activationEvent = CampaignSurveyEvent.deserialize(input.ActivationEvent);\n        var validationError = result.validate();\n        if (validationError) {\n            result = null;\n        }\n        return [result, validationError];\n    };\n    CampaignSurveyTemplateNps11PointStatic.prototype.validate = function () {\n        return _super.prototype.validate.call(this);\n    };\n    return CampaignSurveyTemplateNps11PointStatic;\n}(CampaignSurveyTemplate));\nexports.CampaignSurveyTemplateNps11PointStatic = CampaignSurveyTemplateNps11PointStatic;\nvar CampaignSurveyTemplateGenericMessagingSurface = /** @class */ (function (_super) {\n    __extends(CampaignSurveyTemplateGenericMessagingSurface, _super);\n    function CampaignSurveyTemplateGenericMessagingSurface() {\n        return _super.call(this) || this;\n    }\n    CampaignSurveyTemplateGenericMessagingSurface.deserialize = function (input) {\n        if (isNOU(input)) {\n            return [null, \'deserialize parameter is null\'];\n        }\n        var result = new CampaignSurveyTemplateGenericMessagingSurface();\n        result.activationEvent = CampaignSurveyEvent.deserialize(input.ActivationEvent);\n        result.metadata = CampaignSurveyMetadata.deserialize(input.Metadata);\n        result.maxLaunches = input.MaxLaunches;\n        result.maxLaunchesPerSession = input.MaxLaunchesPerSession;\n        result.preferredLaunchType = input.PreferredLaunchType;\n        var validationError = result.validate();\n        if (validationError) {\n            result = null;\n        }\n        return [result, validationError];\n    };\n    CampaignSurveyTemplateGenericMessagingSurface.prototype.validate = function () {\n        var validationError = _super.prototype.validate.call(this);\n        if (validationError) {\n            return validationError;\n        }\n        else if (isNOU(this.metadata)) {\n            return \'The metadata is undefined\';\n        }\n        else if ((!isNOU(this.maxLaunches) && (!isNumber(this.maxLaunches) || this.maxLaunches <= 0)) ||\n            (!isNOU(this.maxLaunchesPerSession) && (!isNumber(this.maxLaunchesPerSession) || this.maxLaunchesPerSession <= 0))) {\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_LocalError("Invalid Multi Launch settings", this.maxLaunches, this.maxLaunchesPerSession);\n            return \'Invalid Multi Launch settings\';\n        }\n        // check for valid values\n        if (isNumber(this.maxLaunches) &&\n            isNumber(this.maxLaunchesPerSession) &&\n            this.maxLaunchesPerSession > this.maxLaunches) {\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_LocalError("Invalid Multi launch settings", this.maxLaunches, this.maxLaunchesPerSession);\n            return \'Invalid Multi Launch settings\';\n        }\n        if (!isNOU(this.preferredLaunchType) && !isString(this.preferredLaunchType)) {\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_LocalError("Invalid launcher type", this.preferredLaunchType);\n            return \'Invalid launcher type\';\n        }\n        return \'\';\n    };\n    return CampaignSurveyTemplateGenericMessagingSurface;\n}(CampaignSurveyTemplate));\nexports.CampaignSurveyTemplateGenericMessagingSurface = CampaignSurveyTemplateGenericMessagingSurface;\nvar CampaignSurveyTemplateIntercept = /** @class */ (function (_super) {\n    __extends(CampaignSurveyTemplateIntercept, _super);\n    // public for UT only\n    function CampaignSurveyTemplateIntercept() {\n        return _super.call(this) || this;\n    }\n    CampaignSurveyTemplateIntercept.deserialize = function (input) {\n        var result = new CampaignSurveyTemplateIntercept();\n        if (isNOU(input)) {\n            return [null, \'deserialize parameter is null\'];\n        }\n        result.activationEvent = CampaignSurveyEvent.deserialize(input.ActivationEvent);\n        result.content = CampaignSurveyContent.deserialize(input.Content);\n        var validationError = result.validate();\n        if (validationError) {\n            result = null;\n        }\n        return [result, validationError];\n    };\n    CampaignSurveyTemplateIntercept.prototype.validate = function () {\n        var validationError = _super.prototype.validate.call(this);\n        if (validationError) {\n            return validationError;\n        }\n        else if (isNOU(this.content)) {\n            return \'The survey schema does not have any content\';\n        }\n        return \'\';\n    };\n    return CampaignSurveyTemplateIntercept;\n}(CampaignSurveyTemplate));\nexports.CampaignSurveyTemplateIntercept = CampaignSurveyTemplateIntercept;\n// endregion\n// region Campaign Definition\nvar CampaignDefinition = /** @class */ (function () {\n    function CampaignDefinition() {\n    }\n    /**\n     * Method to deserialize a JSON object to class object\n     * @param input: JSON object\n     * Returns result of validation check\n     */\n    CampaignDefinition.deserialize = function (input) {\n        var _a;\n        var result = new CampaignDefinition();\n        var validationError;\n        if (isNOU(input)) {\n            return null;\n        }\n        result.campaignId = input.CampaignId;\n        result.governedChannelType = input.GovernedChannelType;\n        result.startTime = input.StartTimeUtc;\n        result.endTime = input.EndTimeUtc;\n        result.launcherType = input.LauncherType;\n        result.primaryPriority = input.PrimaryPriority;\n        result.tags = input.Tags;\n        var additionalDataRequested = CampaignAdditionalDataRequested.deserialize(input.AdditionalDataRequested);\n        result.additionalDataRequested = additionalDataRequested ? additionalDataRequested.additionalData : [];\n        if (input.SurveyTemplate) {\n            _a = CampaignSurveyTemplate.deserialize(input.SurveyTemplate), result.surveyTemplate = _a[0], validationError = _a[1];\n            if (validationError) {\n                TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.CampaignDefinitionProvider.CampaignSurveyTemplate.SchemaValidationError, {\n                    CampaignId: input.CampaignId,\n                    ErrorMessage: validationError\n                });\n            }\n        }\n        if (input.NominationScheme) {\n            result.nominationScheme = CampaignNominationScheme.deserialize(input.NominationScheme);\n        }\n        if (input.Scope) {\n            result.scope = CampaignScope.deserialize(input.Scope);\n        }\n        if (!isNOU(input.TreatmentType)) {\n            result.treatmentType = input.TreatmentType;\n        }\n        else {\n            result.treatmentType = 255 /* none */;\n        }\n        if (!isNOU(input.BusinessLevel)) {\n            result.businessLevel = input.BusinessLevel;\n        }\n        if (!result.validate()) {\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_LocalError("Invalid definition", input);\n            return null;\n        }\n        return result;\n    };\n    CampaignDefinition.prototype.validate = function () {\n        var _a, _b;\n        if (isNOU(this.scope)) {\n            this.scope = new CampaignScopeAny();\n        }\n        if (isNOU(this.campaignId) || !isString(this.campaignId)) {\n            return false;\n        }\n        if (!isNumber(this.governedChannelType) || !Utils.isEnumValue(this.governedChannelType, floodgate_shared_typings_1.GovernedChannelType)) {\n            return false;\n        }\n        if (isNOU(this.nominationScheme)) {\n            return false;\n        }\n        if (isNOU(this.surveyTemplate)) {\n            return false;\n        }\n        if (!isNOU(this.launcherType) && !isString(this.launcherType)) {\n            return false;\n        }\n        if (this.launcherType === "customervoice" && isNOU((_b = (_a = this.surveyTemplate.content) === null || _a === void 0 ? void 0 : _a.cvSurvey) === null || _b === void 0 ? void 0 : _b.customerVoiceFormId)) {\n            return false;\n        }\n        if (!isNOU(this.primaryPriority) && !isNumber(this.primaryPriority)) {\n            return false;\n        }\n        if (this.tags && !Array.isArray(this.tags)) {\n            return false;\n        }\n        // Campaigns with no start date are effectively disabled, in fact, this is the supported way to stage a definition but have it be turned off\n        if (isNOU(this.startTime)) {\n            this.startTime = getDistantFuture();\n        }\n        else if (isUtcDatetimeString(this.startTime)) {\n            this.startTime = stringToDate(this.startTime);\n        }\n        else {\n            return false;\n        }\n        // Campaigns with no end date are effectively on indefinitely\n        if (isNOU(this.endTime) ||\n            (typeof (this.endTime) === "string" && this.endTime === "")) {\n            this.endTime = getDistantFuture();\n        }\n        else if (isUtcDatetimeString(this.endTime)) {\n            this.endTime = stringToDate(this.endTime);\n        }\n        else {\n            return false;\n        }\n        return true;\n    };\n    return CampaignDefinition;\n}());\nexports.CampaignDefinition = CampaignDefinition;\n/**\n * Given an array of campaign definitions, returns the valid ones and errors if any are invalid.\n * @param input: JSON object\n * Returns the valid definitions and the error as string if any.\n */\nfunction FilterValidCampaignDefinitions(campaignDefinitions) {\n    var result = [];\n    if (isNOU(campaignDefinitions)) {\n        return { result: result, error: "Empty", invalidIndexes: [] };\n    }\n    if (!Array.isArray(campaignDefinitions)) {\n        return { result: result, error: "Not an array", invalidIndexes: [] };\n    }\n    var badIndexes = [];\n    for (var i = 0; i < campaignDefinitions.length; i++) {\n        var definition = campaignDefinitions[i];\n        if (definition) {\n            var newDefinition = CampaignDefinition.deserialize(definition);\n            newDefinition\n                ? result.push(newDefinition)\n                : badIndexes.push(i);\n        }\n        else {\n            badIndexes.push(i);\n        }\n    }\n    var error = badIndexes.length > 0 ? "Invalid campaign definitions at indexes: " + badIndexes.toString() : undefined;\n    return { result: result, error: error, invalidIndexes: badIndexes };\n}\nexports.FilterValidCampaignDefinitions = FilterValidCampaignDefinitions;\n// endregion\nvar FileSystemCampaignDefinitionProvider = /** @class */ (function () {\n    function FileSystemCampaignDefinitionProvider(storage) {\n        if (isNOU(storage)) {\n            throw new Error("storage must not be null");\n        }\n        this.storage = storage;\n    }\n    FileSystemCampaignDefinitionProvider.prototype.load = function () {\n        var definitionString = this.storage.read(floodgate_shared_typings_1.FloodgateStorageProviderFileType.CampaignDefinitions);\n        if (isNOU(definitionString)) {\n            return [];\n        }\n        var readDefinitions;\n        try {\n            readDefinitions = JSON.parse(definitionString);\n        }\n        catch (e) {\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_CampaignLoad_Failed(e.toString());\n            return [];\n        }\n        // This ignores errors in validation for now.\n        return FilterValidCampaignDefinitions(readDefinitions).result;\n    };\n    FileSystemCampaignDefinitionProvider.prototype.loadAsync = function () {\n        var definitions = this.load();\n        return new Promise(function onFulfilled(resolve, reject) {\n            resolve(definitions);\n        });\n    };\n    FileSystemCampaignDefinitionProvider.prototype.hasDataChanged = function () {\n        // Not implemented - return false\n        return false;\n    };\n    return FileSystemCampaignDefinitionProvider;\n}());\nexports.FileSystemCampaignDefinitionProvider = FileSystemCampaignDefinitionProvider;\nvar DynamicCampaignDefinitionProvider = /** @class */ (function () {\n    function DynamicCampaignDefinitionProvider(storageProvider) {\n        this.prefixRegex = new RegExp(/^(Floodgate_Campaign_)/im);\n        if (isNOU(storageProvider)) {\n            throw new Error("storage must not be null");\n        }\n        this.ecsCampaignDefintionProvider = storageProvider;\n    }\n    DynamicCampaignDefinitionProvider.prototype.hasDataChanged = function () {\n        var ecsResponse = this.ecsCampaignDefintionProvider.getConfig();\n        var newEtag = ecsResponse === null || ecsResponse === void 0 ? void 0 : ecsResponse.eTag;\n        // If the etag changes, switch the flag so the campaign loading will refresh next time\n        // the eTag will be updated later when the DefinitionProvider is loading\n        return newEtag !== this.eTag;\n    };\n    DynamicCampaignDefinitionProvider.prototype.load = function () {\n        var _this = this;\n        var ecsCampaignDefinitions = [];\n        var ecsResponse = this.ecsCampaignDefintionProvider.getConfig();\n        this.eTag = ecsResponse === null || ecsResponse === void 0 ? void 0 : ecsResponse.eTag;\n        if (Utils.isNOU(ecsResponse)) {\n            // Potentially first boot, no config yet.\n            return ecsCampaignDefinitions;\n        }\n        else if (Object.keys(ecsResponse === null || ecsResponse === void 0 ? void 0 : ecsResponse.config).length === 0) {\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.DynamicCampaignDefinitionProvider.Load.EmptyEcsConfig, {\n                Count: 0,\n                Message: "Empty config returned from ECS",\n            }, 0.1);\n            return ecsCampaignDefinitions;\n        }\n        Object.entries(ecsResponse.config).forEach(function (_a) {\n            var key = _a[0], val = _a[1];\n            if (_this.prefixRegex.test(key)) {\n                if (!Utils.isObject(val)) {\n                    return false;\n                }\n                ecsCampaignDefinitions.push(val);\n            }\n        });\n        var filteredEcsCampaignDefinitions = FilterValidCampaignDefinitions(ecsCampaignDefinitions);\n        if (filteredEcsCampaignDefinitions.invalidIndexes.length > 0) {\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.DynamicCampaignDefinitionProvider.Load.InvalidEcsConfig, {\n                Count: filteredEcsCampaignDefinitions.invalidIndexes.length,\n                Message: filteredEcsCampaignDefinitions.invalidIndexes.toString(),\n            });\n        }\n        return filteredEcsCampaignDefinitions.result;\n    };\n    DynamicCampaignDefinitionProvider.prototype.loadAsync = function () {\n        return Promise.resolve(this.load());\n    };\n    return DynamicCampaignDefinitionProvider;\n}());\nexports.DynamicCampaignDefinitionProvider = DynamicCampaignDefinitionProvider;\nfunction setDynamicUxSchemaVariables(dynamicVariables) {\n    dynamicUxSchemaVariables = dynamicVariables !== null && dynamicVariables !== void 0 ? dynamicVariables : {};\n}\nexports.setDynamicUxSchemaVariables = setDynamicUxSchemaVariables;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/Campaign/CampaignDefinitionProvider.js\n')},"../FloodgateCore/dist/src/Campaign/CampaignManager.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.CampaignManager = void 0;\nvar Utils = __webpack_require__(/*! ../Utils */ "../FloodgateCore/dist/src/Utils.js");\nvar floodgate_shared_typings_1 = __webpack_require__(/*! @ms-ofb/floodgate-shared-typings */ "../FloodgateCore/node_modules/@ms-ofb/floodgate-shared-typings/dist/index.js");\nvar CampaignDefinitionProvider_1 = __webpack_require__(/*! ./CampaignDefinitionProvider */ "../FloodgateCore/dist/src/Campaign/CampaignDefinitionProvider.js");\nvar CampaignStateProvider_1 = __webpack_require__(/*! ./CampaignStateProvider */ "../FloodgateCore/dist/src/Campaign/CampaignStateProvider.js");\nvar CampaignSurveyFactory_1 = __webpack_require__(/*! ./CampaignSurveyFactory */ "../FloodgateCore/dist/src/Campaign/CampaignSurveyFactory.js");\nvar Constants_1 = __webpack_require__(/*! ../Constants */ "../FloodgateCore/dist/src/Constants.js");\nvar FeatureGateProvider_1 = __webpack_require__(/*! ../FeatureGateProvider */ "../FloodgateCore/dist/src/FeatureGateProvider.js");\nvar TelemetryLogger_1 = __webpack_require__(/*! ../TelemetryLogger */ "../FloodgateCore/dist/src/TelemetryLogger.js");\nvar getDistantFuture = Utils.getDistantFuture, getDistantPast = Utils.getDistantPast, isArray = Utils.isArray, isNOU = Utils.isNOU;\n/**\n * The standard campaign manager implementation.\n */\nvar CampaignManager = /** @class */ (function () {\n    function CampaignManager(stateProvider, definitionProviders, stringProvider, environmentProvider, currentBuildNumber, currentDate, isPriorityEnabled, userFactsProvider, surveyCandidacyChecker, logExperimentTrigger, campaignTelemetrySamplingConfig, messagingEnabled, surveyEnabled) {\n        var _a, _b;\n        if (!stateProvider) {\n            throw new Error("stateProvider must not be null");\n        }\n        if (!isArray(definitionProviders)) {\n            throw new Error("definitionProviders is either null or not an array type");\n        }\n        if (!stringProvider) {\n            throw new Error("stringProvider must not be null");\n        }\n        if (isNOU(currentBuildNumber)) {\n            throw new Error("currentBuildNumber must not be null");\n        }\n        // these settings help determine what type of messaging surface / Floodgate capability is available\n        this.messagingEnabled = messagingEnabled;\n        this.surveyEnabled = surveyEnabled;\n        this.campaignStates = {};\n        this.campaignDefinitions = {};\n        this.userFacts = [];\n        this.stateProvider = stateProvider;\n        this.definitionProviders = definitionProviders;\n        this.stringProvider = stringProvider;\n        this.surveyCandidacyChecker = surveyCandidacyChecker;\n        this.userFactsProvider = userFactsProvider;\n        this.environmentProvider = environmentProvider; // Can be null\n        this.currentBuildNumber = currentBuildNumber;\n        currentDate = currentDate ? currentDate : new Date();\n        this.isPriorityEnabled = isPriorityEnabled;\n        this.logExperimentTrigger = logExperimentTrigger;\n        this.campaignTelemetrySamplingConfig = campaignTelemetrySamplingConfig;\n        this.isFloodgateEnabledConfigAvailable = (_a = FeatureGateProvider_1.getFeatureGateProvider()) === null || _a === void 0 ? void 0 : _a.getBoolFeatureStatus("FloodgateEnabledConfigAvailable", false);\n        this.floodgateEnabledTelemetrySamplingRate = (_b = FeatureGateProvider_1.getFeatureGateProvider()) === null || _b === void 0 ? void 0 : _b.getIntFeatureStatus("FloodgateEnabledTelemetrySamplingRate", 0.1);\n    }\n    CampaignManager.isStateUpForNomination = function (state, definition, date, buildNumber) {\n        if (!state || !definition) {\n            return false;\n        }\n        date = date ? date : new Date();\n        // Check manual override\n        if (state.ForceCandidacy) {\n            return true;\n        }\n        // Figure out which duration we\'re using based on whether or not the user triggered the survey\n        var campaignCooldownDuration = definition.nominationScheme.getCampaignCooldown(state.IsCandidate && state.DidCandidateTriggerSurvey);\n        if (!campaignCooldownDuration) {\n            return false;\n        }\n        // First check for build-based rules. Eventually this could get more complex if we supported counting differently seen build numbers\n        if (CampaignManager.hasBuildChangeDurationElapsed(campaignCooldownDuration, state.LastNominationBuildNumber, buildNumber)) {\n            return true;\n        }\n        // Next check date rules\n        return CampaignManager.hasTimeIntervalDurationElapsed(campaignCooldownDuration, state.getCooldownStartDate(), date);\n    };\n    CampaignManager.isDateInRange = function (date, startDate, endDate) {\n        date = date ? date : new Date();\n        startDate = startDate ? startDate : getDistantPast();\n        endDate = endDate ? endDate : getDistantFuture();\n        // Check Start/Expire date range\n        if (startDate.getTime() <= date.getTime() && endDate.getTime() >= date.getTime()) {\n            return true;\n        }\n        return false;\n    };\n    CampaignManager.hasTimeIntervalDurationElapsed = function (duration, startDate, date) {\n        if (isNOU(duration) || !(duration instanceof CampaignDefinitionProvider_1.CampaignDurationTimeInterval)) {\n            return false;\n        }\n        if (!startDate || !date) {\n            return false;\n        }\n        var endDate = Utils.addSecondsWithoutOverflow(startDate, duration.intervalSeconds);\n        return date.getTime() >= endDate.getTime();\n    };\n    CampaignManager.hasBuildChangeDurationElapsed = function (duration, startBuild, build) {\n        if (isNOU(duration) || !(duration instanceof CampaignDefinitionProvider_1.CampaignDurationSingleBuildChange)) {\n            return false;\n        }\n        if (isNOU(startBuild) || isNOU(build)) {\n            return (startBuild === null) !== (build === null);\n        }\n        return !(startBuild === build);\n    };\n    CampaignManager.isCampaignInScope = function (definition, date, environmentProvider, userFactsProvider) {\n        if (!definition) {\n            return false;\n        }\n        date = date ? date : new Date();\n        // Check Start/Expire date range\n        if (!CampaignManager.isDateInRangeWithDefinition(date, definition)) {\n            return false;\n        }\n        if (definition.scope) {\n            if (definition.scope instanceof CampaignDefinitionProvider_1.CampaignScopeUserFactAny || definition.scope instanceof CampaignDefinitionProvider_1.CampaignScopeUserFactAll) {\n                definition.scope.setUserFactsProvider(userFactsProvider);\n            }\n            if (definition.scope instanceof CampaignDefinitionProvider_1.CampaignScopeEnvironmentCrossProduct) {\n                definition.scope.setEnvironmentProvider(environmentProvider);\n            }\n            if (!definition.scope.isInScope()) {\n                return false;\n            }\n        }\n        // If we get here, the definition is relevant\n        return true;\n    };\n    CampaignManager.isDateInRangeWithDefinition = function (date, definition) {\n        if (!definition) {\n            return false;\n        }\n        date = date ? date : new Date();\n        return CampaignManager.isDateInRange(date, \n        // null start dates should be impossible, but if set, should mean the campaign is disabled\n        definition.startTime ? definition.startTime : getDistantFuture(), definition.endTime);\n    };\n    CampaignManager.prototype.LogExperimentTrigger = function (triggerDetails) {\n        if (isNOU(this.logExperimentTrigger)) {\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Error(Constants_1.TelemetryEvent.CampaignGovernance.LogExperimentTrigger.Undefined, "LogExperimentTrigger does not exist");\n        }\n        else {\n            try {\n                this.logExperimentTrigger.LogExperimentTrigger(triggerDetails);\n            }\n            catch (error) {\n                TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Error(Constants_1.TelemetryEvent.CampaignGovernance.LogExperimentTrigger.Failed, "Failed to run LogExperimentTrigger " + error);\n            }\n        }\n    };\n    // @Override\n    CampaignManager.prototype.getActiveSurveys = function () {\n        var surveys = {};\n        var prioritizedCampaigns = this.getPrioritizedCampaigns();\n        var activeCampaignIds = [];\n        for (var key in this.campaignStates) {\n            if (Object.prototype.hasOwnProperty.call(this.campaignStates, key)) {\n                var state = this.campaignStates[key];\n                if (!state.IsCandidate) {\n                    continue;\n                }\n                // This is a requirement because we keep some otherwise "stale" campaigns around for the save routine\n                var definition = prioritizedCampaigns[state.CampaignId];\n                if (!definition) {\n                    continue;\n                }\n                var survey = CampaignSurveyFactory_1.CampaignSurveyFactory.makeSurvey(state, definition, this.stringProvider);\n                if (!survey) {\n                    continue;\n                }\n                if (this.surveyCandidacyChecker && !this.surveyCandidacyChecker.isSurveyTrackable(survey)) {\n                    continue;\n                }\n                surveys[survey.getSurveyInfo().getId()] = survey;\n                activeCampaignIds.push(survey.getCampaignId());\n            }\n        }\n        this.logActiveSurveys(prioritizedCampaigns, activeCampaignIds);\n        return surveys;\n    };\n    // This function will log a json of all the CampaignStates during creating active surveys. The purpose of this log is for us to be able to detect\n    // whether the campaign is selected correctly with nomination and prioritization.\n    // The sampling rate of this log is dependent on what rate was received from the campaignTelemetrySamplingConfig\n    // This telemetry gets logged at every floodgate.start. So we need to keep the sampling rate low.\n    // Default sampling rate: 0% - it\'s turned off by default. We will enable it from the Host app side if needed.\n    CampaignManager.prototype.logActiveSurveys = function (prioritizedCampaigns, activeCampaignIds) {\n        var currentCampaignStates = [];\n        for (var key in this.campaignStates) {\n            var state = this.campaignStates[key];\n            var payload = {\n                CampaignId: key,\n                IsCandidate: state.IsCandidate,\n                DidCandidateTriggerSurvey: state.DidCandidateTriggerSurvey,\n                SurveyId: state.LastSurveyId\n            };\n            currentCampaignStates.push(payload);\n        }\n        TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.GetActiveSurveys, { Message: JSON.stringify({\n                CampaignStates: currentCampaignStates,\n                PrioritizedCampaigns: Object.keys(prioritizedCampaigns),\n                ActiveCampaigns: activeCampaignIds,\n                NewNominationCampaigns: this.newNominationCampaigns\n            }) }, 0);\n    };\n    // @Override\n    CampaignManager.prototype.modifyCampaignSurveyTakenDate = function (campaignId, takenDate, isSurveyComplete) {\n        var state = this.campaignStates[campaignId];\n        if (!state) {\n            return;\n        }\n        takenDate = takenDate ? takenDate : new Date();\n        var cooldownSeconds = this.campaignDefinitions[campaignId].nominationScheme.cooldownPeriod.asTimeIntervalSeconds();\n        state.markCurrentSurveyTakenOnDate(takenDate, cooldownSeconds, isSurveyComplete);\n        this.saveCurrentState();\n    };\n    CampaignManager.prototype.getCampaignStates = function () {\n        return this.campaignStates;\n    };\n    // @Override\n    CampaignManager.prototype.getCampaignDefinitions = function () {\n        return this.campaignDefinitions;\n    };\n    CampaignManager.prototype.getUserFacts = function () {\n        return this.userFacts;\n    };\n    // region ISurveyClient methods\n    // @Override\n    CampaignManager.prototype.onSurveyActivated = function (surveyInfo, isSurveyComplete) {\n        if (!surveyInfo) {\n            return;\n        }\n        this.modifyCampaignSurveyTakenDate(surveyInfo.getBackEndId(), new Date(), isSurveyComplete);\n    };\n    // @Override\n    CampaignManager.prototype.refreshSurveyDefinitions = function (channelTypes, date) {\n        this.refreshSurveyDefinitionsPrivate(channelTypes, (date ? date : new Date()));\n    };\n    // @Override\n    CampaignManager.prototype.refreshSurveyDefinitionsAsync = function (channelTypes, date) {\n        var _this = this;\n        return new Promise(function (resolve, reject) {\n            _this.refreshSurveyDefinitionsPrivateAsync(channelTypes, (date ? date : new Date())).then(function onFulfilled() {\n                resolve();\n            }).catch(function OnRejected(errReason) {\n                reject(errReason);\n            });\n        });\n    };\n    // @Override\n    CampaignManager.prototype.getAppSurveys = function () {\n        return this.getActiveSurveys();\n    };\n    // @Override\n    CampaignManager.prototype.saveCurrentState = function () {\n        // Sort by campaignId, ascending for uniformity\n        var states = Utils.makeArrayFromObjectValuesSortedByKeyString(this.campaignStates);\n        this.stateProvider.save(states);\n    };\n    // endregion\n    CampaignManager.prototype.refreshSurveyDefinitionsPrivate = function (channelTypes, date) {\n        if (this.needRefreshSurveyDefinitions()) {\n            this.lastCampaignRefreshTime = new Date();\n            this.campaignDefinitions = {};\n            this.userFacts = [];\n            this.loadFilterCampaigns(date, channelTypes);\n        }\n        else {\n            this.FilterCampaignsOnRestart(date, channelTypes);\n        }\n        this.campaignStates = {};\n        this.LoadFilterCampaignStates(date);\n        this.evaluateCampaigns(date);\n    };\n    CampaignManager.prototype.refreshSurveyDefinitionsPrivateAsync = function (channelTypes, date) {\n        var _this = this;\n        var _a;\n        this.campaignStates = {};\n        this.campaignDefinitions = {};\n        this.userFacts = [];\n        this.lastCampaignRefreshTime = (_a = this.lastCampaignRefreshTime) !== null && _a !== void 0 ? _a : new Date();\n        return new Promise(function (resolve, reject) {\n            _this.loadAndFilterCampaignDataAsync(date, channelTypes).then(function () {\n                _this.evaluateCampaigns(date);\n                resolve();\n            }).catch(function OnRejected(errReason) {\n                reject(errReason);\n            });\n        });\n    };\n    /**\n     * Load and filter the campaigns definitions and states\n     */\n    CampaignManager.prototype.loadAndFilterCampaignDataAsync = function (currentDate, channelTypes) {\n        var _this = this;\n        currentDate = currentDate ? currentDate : new Date();\n        var loadedDefinitions = [];\n        var promises = [];\n        var userFactsPromise = this.userFactsProvider && this.userFactsProvider.loadAsync();\n        for (var _i = 0, _a = Object.keys(this.definitionProviders); _i < _a.length; _i++) {\n            var i = _a[_i];\n            var provider = this.definitionProviders[i];\n            var promise = provider && provider.loadAsync();\n            if (!isNOU(promise)) {\n                // Promise.all fails even if one promise fails.\n                // We want to ignore the promise that failed and continue with the ones\n                // those are succesful, hence overriding the catch to always resolve.\n                // responsibility of logging failures should be with the provider.\n                promise = promise.catch(function () {\n                    TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_CampaignLoad_Failed("Failed to load from campaign definition provider");\n                    Promise.resolve();\n                });\n                promises.push(promise);\n            }\n        }\n        return new Promise(function (resolve, reject) {\n            Promise.all(promises).then(function (values) {\n                var _a;\n                for (var _i = 0, _b = Object.keys(values); _i < _b.length; _i++) {\n                    var i = _b[_i];\n                    var campaignDefinitions = values[i];\n                    if (isArray(campaignDefinitions)) {\n                        // If there are campaign defintions with duplicate campaign Id\'s\n                        // Floodgate will load the last one it found. FilterCampaignData does this filteration\n                        loadedDefinitions = loadedDefinitions.concat(campaignDefinitions);\n                    }\n                }\n                _this.logInitialLoadCampaigns(loadedDefinitions, "loadAsync", (_a = _this.campaignTelemetrySamplingConfig) === null || _a === void 0 ? void 0 : _a.campaignInitialLoadSamplingRate);\n                var setUserFacts = function (userFacts) {\n                    _this.userFacts = userFacts || [];\n                    _this.FilterCampaignData(currentDate, channelTypes, loadedDefinitions);\n                    resolve();\n                };\n                // Before filtering and evaluating the campaign definitions,\n                // wait until the user facts are loaded as they will be used in evaluating campaign scopes\n                if (!isNOU(userFactsPromise)) {\n                    userFactsPromise.then(function (userFacts) {\n                        setUserFacts(userFacts);\n                    }).catch(function () {\n                        // this should never happen as user facts promise will always be resolved by the user facts provider\n                        TelemetryLogger_1.TelemetryLogger.getTelemetryLogger()\n                            .log_Error(Constants_1.TelemetryEvent.Floodgate.UserFactsLoad.Failed, "Failed to load from user facts provider");\n                        setUserFacts();\n                    });\n                }\n                else {\n                    setUserFacts();\n                }\n            }).catch(function OnRejected(error) {\n                // this should never happen as Promise.all will always be resolved\n                // because of hack at the top of the function.\n                TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_CampaignLoad_Failed("Failed to load from campaign definition provider");\n            });\n        });\n    };\n    // This function will log a json of all the definitions received on initial load. The purpose of this log is for us to be able to detect\n    // what campaigns users initially recieved and trace which campaigns from the original pool were successfully nominated / launched\n    // The sampling rate of this log is dependent on what rate was received from the campaignTelemetrySamplingConfig\n    // This telemetry gets logged once per floodgate session\n    // Default sampling rate: 10%\n    CampaignManager.prototype.logInitialLoadCampaigns = function (loadedDefinitions, loadMethod, initialLoadSamplingRate) {\n        var _a, _b, _c;\n        if (initialLoadSamplingRate === void 0) { initialLoadSamplingRate = 0.1; }\n        if (initialLoadSamplingRate > 0) {\n            var loggedDefinitions = [];\n            for (var key in loadedDefinitions) {\n                var definition = loadedDefinitions[key];\n                var payload = {\n                    id: definition.campaignId,\n                    businessLevel: definition.businessLevel,\n                    treatmentType: definition.treatmentType,\n                    scope: definition.scope,\n                    telemetryEventName: (_c = (_b = (_a = definition === null || definition === void 0 ? void 0 : definition.surveyTemplate) === null || _a === void 0 ? void 0 : _a.metadata) === null || _b === void 0 ? void 0 : _b.contentMetadata) === null || _c === void 0 ? void 0 : _c["telemetryEventName"],\n                    userHost: this.environmentProvider,\n                    governedChannelType: definition.governedChannelType,\n                    loadMethod: loadMethod,\n                };\n                loggedDefinitions.push(payload);\n            }\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.InitialLoadedDefinitions, { Message: JSON.stringify(loggedDefinitions) }, initialLoadSamplingRate);\n        }\n    };\n    CampaignManager.prototype.isCampaignTypeEnabled = function (governedChannelType) {\n        // default to true unless stated otherwise by the associated enabled settings\n        var isCampaignTypeEnabled = true;\n        // feature gate for Floodgate Enabled feature- if this is on we will use the settings to determine whether to filter at this stage\n        if (this.isFloodgateEnabledConfigAvailable) {\n            // LPP campaigns depend on the messagingEnabled check (currently teaching message or busbar)\n            if (governedChannelType == floodgate_shared_typings_1.GovernedChannelType.TeachingMessage || governedChannelType == floodgate_shared_typings_1.GovernedChannelType.BusinessBar) {\n                isCampaignTypeEnabled = this.messagingEnabled;\n            }\n            else {\n                // Quip surveys will depend on the surveyEnabled check\n                isCampaignTypeEnabled = this.surveyEnabled;\n            }\n        }\n        // we return default true if we did not receive floodgate enabled config or the feature gate is not on\n        return isCampaignTypeEnabled;\n    };\n    CampaignManager.prototype.loadFilterCampaigns = function (currentDate, channelTypes) {\n        var _a, _b;\n        currentDate = currentDate ? currentDate : new Date();\n        var loadedDefinitions = [];\n        for (var _i = 0, _c = Object.keys(this.definitionProviders); _i < _c.length; _i++) {\n            var index = _c[_i];\n            try {\n                var definitions = this.definitionProviders[index] && this.definitionProviders[index].load();\n                if (isArray(definitions)) {\n                    // If there are campaign defintions with duplicate campaign Id\'s\n                    // Floodgate will load the last one it found. FilterCampaignData does this filteration\n                    loadedDefinitions = loadedDefinitions.concat(definitions);\n                }\n            }\n            catch (error) {\n                // Log error, but continue with other providers\n                // It should be the responsibility of provider to log detailed errors\n                TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_CampaignLoad_Failed("Failed to load from campaign definition provider. " + error.toString());\n            }\n        }\n        this.logInitialLoadCampaigns(loadedDefinitions, "load", (_a = this.campaignTelemetrySamplingConfig) === null || _a === void 0 ? void 0 : _a.campaignInitialLoadSamplingRate);\n        // Load the user facts before all the campaign definitions are evaluated\n        try {\n            this.userFacts = (this.userFactsProvider && this.userFactsProvider.load()) || [];\n        }\n        catch (error) {\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Error(Constants_1.TelemetryEvent.Floodgate.UserFactsLoad.Failed, "Failed to load from user facts provider. " + error);\n        }\n        // array that lists the skipped campaigns due to the campaign type not being enabled\n        var disabledCampaigns = new Array();\n        // array that will be passed to LPP scorecard callback\n        var triggerDetails = new Array();\n        // array that lists campaign ids which passed governed channel type / business level checks\n        var channelCleared = new Array();\n        // array that lists campaign ids that are in scope \n        var inScope = new Array();\n        // array that lists campaign ids that are not control campaigns (added to activityListener)\n        var nominated = new Array();\n        // Load filtered campaign definitions\n        for (var key in loadedDefinitions) {\n            if (Object.prototype.hasOwnProperty.call(loadedDefinitions, key)) {\n                var definition = loadedDefinitions[key];\n                // checks if this definition should be included in nomination process based on Floodgate Enabled configuration\n                if (!this.isCampaignTypeEnabled(definition.governedChannelType)) {\n                    disabledCampaigns.push(definition.campaignId);\n                    continue;\n                }\n                // this needs to be done here before adding to campaignDefinitions in case there are multiple definitions with different language scopes\n                if (!CampaignManager.isCampaignInScope(definition, currentDate, this.environmentProvider, this.userFactsProvider)) {\n                    continue;\n                }\n                inScope.push(definition.campaignId);\n                // filtering for campaign trigger logging\n                if (definition.treatmentType !== 255 /* none */) {\n                    // campaign trigger info for scorecards\n                    var triggerDetail = this.RetrieveTriggerEventDetail(definition);\n                    if (!isNOU(triggerDetail)) {\n                        triggerDetails.push(triggerDetail);\n                    }\n                }\n                if (channelTypes &&\n                    (channelTypes.indexOf(definition.governedChannelType) < 0) &&\n                    (definition.businessLevel !== floodgate_shared_typings_1.SurveyInfoBusinessLevel.Critical)) {\n                    continue;\n                }\n                channelCleared.push(definition.campaignId);\n                // to remove control campaigns from activityListener list \n                if (definition.treatmentType === 0 /* Control */) {\n                    continue;\n                }\n                // log the definitions which are nominated\n                nominated.push(definition.campaignId);\n                // Overwrite the campaign definition if it already exists with the latest one.\n                this.campaignDefinitions[definition.campaignId] = definition;\n            }\n        }\n        // log the campaigns which were skipped due to the campaign type being disabled\n        this.CampaignTypeDisabledTelemetry(disabledCampaigns, this.messagingEnabled, this.surveyEnabled);\n        // if sampling is on for governance check telemetry, log telemetry\n        this.GovernanceCheckTelemetry(channelCleared, inScope, nominated, (_b = this.campaignTelemetrySamplingConfig) === null || _b === void 0 ? void 0 : _b.passedCampaignGovernanceSamplingRate);\n        // call new scorecard trigger callback only if feature gate is on and there are campaign definitions available\n        if (triggerDetails.length > 0) {\n            this.LogExperimentTrigger(triggerDetails);\n        }\n    };\n    CampaignManager.prototype.RetrieveTriggerEventDetail = function (definition) {\n        var _a, _b, _c;\n        try {\n            var eventInfo = {\n                id: definition.campaignId,\n                telemetryEventName: (_c = (_b = (_a = definition === null || definition === void 0 ? void 0 : definition.surveyTemplate) === null || _a === void 0 ? void 0 : _a.metadata) === null || _b === void 0 ? void 0 : _b.contentMetadata) === null || _c === void 0 ? void 0 : _c["telemetryEventName"],\n                treatmentType: isNOU(definition.treatmentType) ? 255 /* none */ : definition.treatmentType\n            };\n            var triggerDetail = {\n                triggerEvent: eventInfo.telemetryEventName,\n                eventInfo: eventInfo\n            };\n            // return info needed for scorecards for this campaign to the list to the array\n            return triggerDetail;\n        }\n        catch (error) {\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Error(Constants_1.TelemetryEvent.CampaignGovernance.RetrieveTriggerEventDetail.Failed, "Failed to add trigger event detail " + error);\n            return null;\n        }\n    };\n    // creating a json object to log campaigns which passed various governance checks, logs once per floodgate session\n    // Default sampling rate: 10%\n    CampaignManager.prototype.GovernanceCheckTelemetry = function (channelCleared, inScope, nominated, samplingRate) {\n        if (samplingRate === void 0) { samplingRate = 0.1; }\n        if (samplingRate > 0) {\n            var payload = {\n                channelCleared: channelCleared.length > 0 ? channelCleared : undefined,\n                inScope: inScope.length > 0 ? inScope : undefined,\n                nominated: nominated.length > 0 ? nominated : undefined,\n            };\n            if (Object.values(payload).some(function (v) { return v != undefined; })) {\n                TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.CampaignGovernance.NominationCheckCampaigns, { Message: JSON.stringify(payload) }, samplingRate);\n            }\n        }\n    };\n    CampaignManager.prototype.CampaignTypeDisabledTelemetry = function (disabledCampaigns, messagingEnabled, surveyEnabled) {\n        if (messagingEnabled === void 0) { messagingEnabled = true; }\n        if (surveyEnabled === void 0) { surveyEnabled = true; }\n        if (this.isFloodgateEnabledConfigAvailable && disabledCampaigns.length > 0) {\n            var payload = {\n                disabledCampaigns: disabledCampaigns,\n                messagingEnabled: messagingEnabled,\n                surveyEnabled: surveyEnabled,\n            };\n            // default we will log the telemetry at 10%, we can change this later on if needed\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.CampaignTypeDisabledDefinitions, { Message: JSON.stringify(payload) }, this.floodgateEnabledTelemetrySamplingRate);\n        }\n    };\n    /**\n     * Load and filter the campaigns definitions and states\n     */\n    CampaignManager.prototype.FilterCampaignData = function (currentDate, channelTypes, loadedDefinitions) {\n        var _a;\n        var loadedDefinitionsMap = {};\n        var triggerDetails = new Array();\n        // array that lists the skipped campaigns due to the campaign type not being enabled\n        var campaignTypeDisabledCampaigns = new Array();\n        // array that lists campaign ids which passed governed channel type / business level checks\n        var channelCleared = new Array();\n        // array that lists campaign ids that are in scope \n        var inScope = new Array();\n        // array that lists campaign ids that are not control campaigns (added to activityListener)\n        var nominated = new Array();\n        // Load filtered campaign definitions\n        for (var key in loadedDefinitions) {\n            if (Object.prototype.hasOwnProperty.call(loadedDefinitions, key)) {\n                var definition = loadedDefinitions[key];\n                loadedDefinitionsMap[definition.campaignId] = definition;\n                // checks if this definition should be included in nomination process based on Floodgate Enabled configuration\n                if (!this.isCampaignTypeEnabled(definition.governedChannelType)) {\n                    campaignTypeDisabledCampaigns.push(definition.campaignId);\n                    continue;\n                }\n                // this needs to be done here before adding to campaignDefinitions in case there are multiple definitions with different language scopes\n                if (!CampaignManager.isCampaignInScope(definition, currentDate, this.environmentProvider, this.userFactsProvider)) {\n                    continue;\n                }\n                inScope.push(definition.campaignId);\n                // filtering for campaign trigger logging\n                if (definition.treatmentType !== 255 /* none */) {\n                    // campaign trigger info for scorecards\n                    var triggerDetail = this.RetrieveTriggerEventDetail(definition);\n                    if (!isNOU(triggerDetail)) {\n                        triggerDetails.push(triggerDetail);\n                    }\n                }\n                if (channelTypes &&\n                    (channelTypes.indexOf(definition.governedChannelType) < 0) &&\n                    (definition.businessLevel !== floodgate_shared_typings_1.SurveyInfoBusinessLevel.Critical)) {\n                    continue;\n                }\n                channelCleared.push(definition.campaignId);\n                // to remove control campaigns from activityListener list \n                if (definition.treatmentType === 0 /* Control */) {\n                    continue;\n                }\n                // log the definitions which are nominated\n                nominated.push(definition.campaignId);\n                // Overwrite the campaign definition if it already exists with the latest one.\n                this.campaignDefinitions[definition.campaignId] = definition;\n            }\n        }\n        // log the campaigns which were skipped due to the campaign type being disabled\n        this.CampaignTypeDisabledTelemetry(campaignTypeDisabledCampaigns, this.messagingEnabled, this.surveyEnabled);\n        // if sampling is on for governance check telemetry, log telemetry\n        this.GovernanceCheckTelemetry(channelCleared, inScope, nominated, (_a = this.campaignTelemetrySamplingConfig) === null || _a === void 0 ? void 0 : _a.passedCampaignGovernanceSamplingRate);\n        // call new scorecard trigger callback only if feature gate is on and there are campaign definitions available\n        if (triggerDetails.length > 0) {\n            this.LogExperimentTrigger(triggerDetails);\n        }\n        // Load campaign state, filtering out the expired definitions\n        var loadedStates = this.stateProvider.load();\n        var staleLoadedStates = [];\n        for (var key in loadedStates) {\n            if (Object.prototype.hasOwnProperty.call(loadedStates, key)) {\n                var state = loadedStates[key];\n                if (!Object.prototype.hasOwnProperty.call(this.campaignDefinitions, state.CampaignId)) {\n                    staleLoadedStates.push(state);\n                }\n                this.campaignStates[state.CampaignId] = state;\n            }\n        }\n        /*\n            * Stale State data cleanup\n            * State needs to be cleaned up when:\n            * 1) The campaign has expired\n            * 2) The campaign is no longer present in the definitions (think ECS or other outages or very old expirations)\n            *    In this case the state should still be cleaned up on it\'s reelection date\n            * 3) When the user is out of scope (for an otherwise active campaign) and is up for nomination\n\r\n            * This optimizes the user experience in case the campaign pops up or gets renewed when we would have preferred the user remain in cool down\n\r\n            * 2&3 are basically the same, and 1 is a special case optimization on top of 2&3 for earlier clean up\n\r\n            * To do 2 & 3, we just look at states with no matching definition (after filtering), and reject them if they are past their nomination period\n            * To do 1, we just need to keep a list/hash of the definitions that we filtered out this load cycle, specifically for expiration dates, and bypass\n            * the cool down "wait" for these specifically\n\r\n            * For now, allowing some "grace" for "missing"/"blippy" campaign definitions (in case they pop in and out of ECS) by deferring missing\n            * deletion by a delay-time specified by the original campaign.\n            */\n        for (var key in staleLoadedStates) {\n            if (Object.prototype.hasOwnProperty.call(staleLoadedStates, key)) {\n                var state = staleLoadedStates[key];\n                if (!state) {\n                    continue;\n                }\n                var definition = loadedDefinitionsMap[state.CampaignId];\n                var shouldRemove = false;\n                if (!definition) {\n                    if (state.LastNominationTimeUtc\n                        .getTime() <= Utils.subtractSecondsWithoutOverflow(currentDate, state.DeleteAfterSecondsWhenStale).getTime()) {\n                        shouldRemove = true;\n                    }\n                }\n                else if (CampaignManager.isStateUpForNomination(state, definition, currentDate, this.currentBuildNumber)) {\n                    shouldRemove = true;\n                }\n                // The next time we write to storage, these will be removed\n                if (shouldRemove) {\n                    delete this.campaignStates[state.CampaignId];\n                }\n            }\n        }\n    };\n    // Filter lower priority campaigns that are on same channel and have a matching tag\n    CampaignManager.prototype.getPrioritizedCampaigns = function () {\n        var _this = this;\n        var prioritizedCampaigns = {};\n        // build <tagId_channel, campaign[]> map\n        var matchingTagCampaigns = {};\n        Object.keys(this.campaignDefinitions || []).forEach(function (key) {\n            var definition = _this.campaignDefinitions[key];\n            if (Object.prototype.hasOwnProperty.call(_this.campaignStates, key)) {\n                var state = _this.campaignStates[key];\n                // only add the campaign if it\'s nominated\n                if (state.IsCandidate) {\n                    prioritizedCampaigns[key] = definition;\n                    // if tags are not defined, use empty tag to fallback to channel level aggregation\n                    var definitionTags = definition.tags && definition.tags.length > 0 ? definition.tags : [""];\n                    definitionTags.forEach(function (tagId) {\n                        var mapKey = tagId + "_" + definition.governedChannelType;\n                        matchingTagCampaigns[mapKey] = matchingTagCampaigns[mapKey] || [];\n                        matchingTagCampaigns[mapKey].push(definition);\n                    });\n                }\n            }\n        });\n        // remove lower priority campaigns\n        Object.keys(matchingTagCampaigns).forEach(function (key) {\n            var _a;\n            // Check if the priority filter is enabled for standard channel\n            if (!_this.isPriorityEnabled && key.endsWith("_" + floodgate_shared_typings_1.GovernedChannelType.Standard)) {\n                return;\n            }\n            var definitions = matchingTagCampaigns[key];\n            if (definitions.length <= 1) {\n                return;\n            }\n            // Get definition that has max priority value (0/null/undefined has highest prioirty)\n            var _b = Utils.findHighestPriorityDefinition(definitions), maxPriorityDefinition = _b[0], hasLowerPriorityDefinitions = _b[1];\n            var maxPriority = (_a = maxPriorityDefinition.primaryPriority) !== null && _a !== void 0 ? _a : 0;\n            if (!hasLowerPriorityDefinitions) {\n                // nothing to filter because all priorities are the same\n                return;\n            }\n            // delete lower priority campaigns while preserving all the matching higher priority items\n            definitions.forEach(function (current) {\n                var currentPriority = current.primaryPriority;\n                // for mso compatability ignore campaigns without priority set so that they are always considered\n                if (!isNOU(current.primaryPriority) && currentPriority > maxPriority) {\n                    delete prioritizedCampaigns[current.campaignId];\n                }\n            });\n        });\n        return prioritizedCampaigns;\n    };\n    /**\n     * Given the loaded campaign definitions and states from previous sessions, run anything up for nomination\n     */\n    CampaignManager.prototype.evaluateCampaigns = function (currentDate) {\n        // Loop through campaigns definitions, and update their state if necessary\n        currentDate = currentDate ? currentDate : new Date();\n        this.newNominationCampaigns = [];\n        for (var key in this.campaignDefinitions) {\n            if (Object.prototype.hasOwnProperty.call(this.campaignDefinitions, key)) {\n                var definition = this.campaignDefinitions[key];\n                var state = this.campaignStates[definition.campaignId];\n                if (!state || CampaignManager.isStateUpForNomination(state, definition, currentDate, this.currentBuildNumber)) {\n                    var lastSurveyId = state ? state.LastSurveyId : "";\n                    var lastSurveyStartTime = state ? state.LastSurveyStartTimeUtc : getDistantPast();\n                    var lastSurveyExpirationTime = state ? state.LastSurveyExpirationTimeUtc : getDistantPast();\n                    var lastSurveyActivatedTime = state ? state.LastSurveyActivatedTimeUtc : getDistantPast();\n                    var lastCooldownEndTimeUtc = state ? state.LastCooldownEndTimeUtc : getDistantPast();\n                    this.newNominationCampaigns.push(definition.campaignId);\n                    // Run the nomination\n                    var isCandidate = (state && state.ForceCandidacy) || definition.nominationScheme.evaluateNominationRules();\n                    if (isCandidate) {\n                        // Make new survey properties for the next call to get the active surveys\n                        lastSurveyId = Utils.guid();\n                        lastSurveyStartTime = definition.nominationScheme.calculateSurveyStartTimeFromDate(currentDate);\n                        lastSurveyExpirationTime = definition.nominationScheme.calculateSurveyExpirationTimeFromSurveyStartTime(lastSurveyStartTime);\n                    }\n                    var newState = new CampaignStateProvider_1.CampaignState(definition.campaignId, currentDate, this.currentBuildNumber, definition.nominationScheme.getActiveSurveyTimeIntervalSeconds(), false, isCandidate, false, lastSurveyActivatedTime, lastSurveyId, lastSurveyStartTime, lastSurveyExpirationTime, lastCooldownEndTimeUtc);\n                    // Save the new state to our local cache\n                    this.campaignStates[newState.CampaignId] = newState;\n                }\n            }\n        }\n    };\n    CampaignManager.prototype.needRefreshSurveyDefinitions = function () {\n        var _a;\n        // Check for data has changed\n        var updateNeeded = false;\n        var reloadFeatureEnabled = (_a = FeatureGateProvider_1.getFeatureGateProvider()) === null || _a === void 0 ? void 0 : _a.getBoolFeatureStatus("ReloadOnCampaignDefinitionChanged", false);\n        if (reloadFeatureEnabled) {\n            for (var _i = 0, _b = Object.keys(this.definitionProviders); _i < _b.length; _i++) {\n                var i = _b[_i];\n                var provider = this.definitionProviders[i];\n                updateNeeded = provider.hasDataChanged();\n                // Breakout singe we just need one true to refresh campaigns\n                if (updateNeeded) {\n                    break;\n                }\n            }\n        }\n        return !this.lastCampaignRefreshTime || updateNeeded;\n    };\n    CampaignManager.prototype.FilterCampaignsOnRestart = function (currentDate, channelTypes) {\n        for (var key in this.campaignDefinitions) {\n            if (Object.prototype.hasOwnProperty.call(this.campaignDefinitions, key)) {\n                var definition = this.campaignDefinitions[key];\n                // checks if this definition should be included in nomination process based on Floodgate Enabled configuration\n                if (!this.isCampaignTypeEnabled(definition.governedChannelType)) {\n                    delete this.campaignDefinitions[definition.campaignId];\n                    continue;\n                }\n                if (channelTypes &&\n                    (channelTypes.indexOf(definition.governedChannelType) < 0) &&\n                    (definition.businessLevel !== floodgate_shared_typings_1.SurveyInfoBusinessLevel.Critical)) {\n                    delete this.campaignDefinitions[definition.campaignId];\n                    continue;\n                }\n                if (!CampaignManager.isCampaignInScope(definition, currentDate, this.environmentProvider, this.userFactsProvider)) {\n                    delete this.campaignDefinitions[definition.campaignId];\n                    continue;\n                }\n                // new campaign governance only applies if feature gate is on, removes control campaigns from activityListener list \n                if (definition.treatmentType === 0 /* Control */) {\n                    delete this.campaignDefinitions[definition.campaignId];\n                    continue;\n                }\n            }\n        }\n    };\n    /**\n     * Load and filter the campaigns definitions and states\n     */\n    CampaignManager.prototype.LoadFilterCampaignStates = function (currentDate) {\n        // Load campaign state, filtering out the expired definitions\n        var loadedStates = this.stateProvider.load();\n        var staleLoadedStates = [];\n        for (var key in loadedStates) {\n            if (Object.prototype.hasOwnProperty.call(loadedStates, key)) {\n                var state = loadedStates[key];\n                if (!Object.prototype.hasOwnProperty.call(this.campaignDefinitions, state.CampaignId)) {\n                    staleLoadedStates.push(state);\n                }\n                this.campaignStates[state.CampaignId] = state;\n            }\n        }\n        /*\n         * Stale State data cleanup\n         * State needs to be cleaned up when:\n         * 1) The campaign has expired\n         * 2) The campaign is no longer present in the definitions (think ECS or other outages or very old expirations)\n         *    In this case the state should still be cleaned up on it\'s reelection date\n         * 3) When the user is out of scope (for an otherwise active campaign) and is up for nomination\n\r\n         * This optimizes the user experience in case the campaign pops up or gets renewed when we would have preferred the user remain in cool down\n\r\n         * 2&3 are basically the same, and 1 is a special case optimization on top of 2&3 for earlier clean up\n\r\n         * To do 2 & 3, we just look at states with no matching definition (after filtering), and reject them if they are past their nomination period\n         * To do 1, we just need to keep a list/hash of the definitions that we filtered out this load cycle, specifically for expiration dates, and bypass\n         * the cool down "wait" for these specifically\n\r\n         * For now, allowing some "grace" for "missing"/"blippy" campaign definitions (in case they pop in and out of ECS) by deferring missing\n         * deletion by a delay-time specified by the original campaign.\n         */\n        for (var key in staleLoadedStates) {\n            if (Object.prototype.hasOwnProperty.call(staleLoadedStates, key)) {\n                var state = staleLoadedStates[key];\n                if (!state) {\n                    continue;\n                }\n                var definition = this.campaignDefinitions[state.CampaignId];\n                var shouldRemove = false;\n                if (!definition) {\n                    if (state.LastNominationTimeUtc\n                        .getTime() <= Utils.subtractSecondsWithoutOverflow(currentDate, state.DeleteAfterSecondsWhenStale).getTime()) {\n                        shouldRemove = true;\n                    }\n                }\n                else if (CampaignManager.isStateUpForNomination(state, definition, currentDate, this.currentBuildNumber)) {\n                    shouldRemove = true;\n                }\n                // The next time we write to storage, these will be removed\n                if (shouldRemove) {\n                    delete this.campaignStates[state.CampaignId];\n                }\n            }\n        }\n    };\n    return CampaignManager;\n}());\nexports.CampaignManager = CampaignManager;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/Campaign/CampaignManager.js\n')},"../FloodgateCore/dist/src/Campaign/CampaignStateProvider.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.FileBasedCampaignStateProvider = exports.HostBasedCampaignStateProvider = exports.CampaignStateProviderFactory = exports.CampaignState = void 0;\nvar floodgate_shared_typings_1 = __webpack_require__(/*! @ms-ofb/floodgate-shared-typings */ "../FloodgateCore/node_modules/@ms-ofb/floodgate-shared-typings/dist/index.js");\nvar Constants_1 = __webpack_require__(/*! ../Constants */ "../FloodgateCore/dist/src/Constants.js");\nvar StateProviderHelpers = __webpack_require__(/*! ../StateProviderHelpers */ "../FloodgateCore/dist/src/StateProviderHelpers.js");\nvar Utils = __webpack_require__(/*! ../Utils */ "../FloodgateCore/dist/src/Utils.js");\nvar TelemetryLogger_1 = __webpack_require__(/*! ../TelemetryLogger */ "../FloodgateCore/dist/src/TelemetryLogger.js");\nvar getDistantPast = Utils.getDistantPast, isBoolean = Utils.isBoolean, isDate = Utils.isDate, isNOU = Utils.isNOU, isString = Utils.isString, isUtcDatetimeString = Utils.isUtcDatetimeString, stringToDate = Utils.stringToDate;\nvar CampaignState = /** @class */ (function () {\n    function CampaignState(campaignId, lastNominationTime, lastNominationBuildNumber, deleteAfterSecondsWhenStale, ForceCandidacy, isCandidate, didCandidateTriggerSurvey, lastSurveyActivatedTime, lastSurveyId, lastSurveyStartTime, lastSurveyExpirationTime, lastCooldownEndTimeUtc) {\n        this.CampaignId = campaignId;\n        this.LastNominationTimeUtc = lastNominationTime;\n        this.LastNominationBuildNumber = lastNominationBuildNumber;\n        this.DeleteAfterSecondsWhenStale = deleteAfterSecondsWhenStale;\n        this.ForceCandidacy = ForceCandidacy;\n        this.IsCandidate = isCandidate;\n        this.DidCandidateTriggerSurvey = didCandidateTriggerSurvey;\n        this.LastSurveyActivatedTimeUtc = lastSurveyActivatedTime;\n        this.LastSurveyId = lastSurveyId;\n        this.LastSurveyStartTimeUtc = lastSurveyStartTime;\n        this.LastSurveyExpirationTimeUtc = lastSurveyExpirationTime;\n        this.LastCooldownEndTimeUtc = lastCooldownEndTimeUtc;\n        if (!this.validate()) {\n            throw new Error("Constructor arguments are not valid");\n        }\n    }\n    /**\n     * Method to deserialize a JSON object to class object\n     * @param input: JSON object\n     * Returns class object\n     */\n    CampaignState.deserialize = function (input) {\n        var result;\n        if (!input) {\n            return null;\n        }\n        try {\n            result = new CampaignState(input.CampaignId, input.LastNominationTimeUtc, input.LastNominationBuildNumber, input.DeleteAfterSecondsWhenStale, false, // ForceCandidacy\n            input.IsCandidate, input.DidCandidateTriggerSurvey, input.LastSurveyActivatedTimeUtc, input.LastSurveyId, input.LastSurveyStartTimeUtc, input.LastSurveyExpirationTimeUtc, input.LastCooldownEndTimeUtc);\n        }\n        catch (e) {\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.CampaignState.Deserialize.Failed, { ErrorMessage: e.toString() });\n            return null;\n        }\n        return result;\n    };\n    CampaignState.prototype.validate = function () {\n        if (!this.CampaignId || !isString(this.CampaignId)) {\n            return false;\n        }\n        if (isNOU(this.LastNominationBuildNumber)\n            || !isString(this.LastNominationBuildNumber)) {\n            return false;\n        }\n        if (!Utils.isNumber(this.DeleteAfterSecondsWhenStale) || this.DeleteAfterSecondsWhenStale < 0) {\n            return false;\n        }\n        if (!isBoolean(this.IsCandidate) || !isBoolean(this.DidCandidateTriggerSurvey)) {\n            return false;\n        }\n        if (this.IsCandidate) {\n            // Disallow the following null\'s if isCandidate == true\n            if (isNOU(this.LastSurveyStartTimeUtc) || isNOU(this.LastSurveyExpirationTimeUtc)) {\n                return false;\n            }\n            // LastSurveyId could be ""\n            if (!isString(this.LastSurveyId)) {\n                return false;\n            }\n        }\n        if (this.DidCandidateTriggerSurvey) {\n            // Disallow the following null\'s if didCandidateTriggerSurvey == true\n            if (isNOU(this.LastSurveyActivatedTimeUtc)) {\n                return false;\n            }\n        }\n        if (isNOU(this.LastSurveyId)) {\n            this.LastSurveyId = "";\n        }\n        else if (!isString(this.LastSurveyId)) {\n            return false;\n        }\n        // LastNominationTime does not allow null\n        if (isUtcDatetimeString(this.LastNominationTimeUtc)) {\n            this.LastNominationTimeUtc = stringToDate(this.LastNominationTimeUtc);\n            // invalidate if it\'s not a Date object\n        }\n        else if (!isDate(this.LastNominationTimeUtc)) {\n            return false;\n        }\n        // Set value to distance past if value not provided\n        if (isNOU(this.LastSurveyActivatedTimeUtc)) {\n            this.LastSurveyActivatedTimeUtc = getDistantPast();\n            // check if it\'s UTC date time string, possibly coming from deserialize method\n        }\n        else if (isUtcDatetimeString(this.LastSurveyActivatedTimeUtc)) {\n            this.LastSurveyActivatedTimeUtc = stringToDate(this.LastSurveyActivatedTimeUtc);\n            // invalidate if it\'s not a Date object\n        }\n        else if (!isDate(this.LastSurveyActivatedTimeUtc)) {\n            return false;\n        }\n        // Set value to distance past if value not provided\n        if (isNOU(this.LastSurveyStartTimeUtc)) {\n            this.LastSurveyStartTimeUtc = getDistantPast();\n            // check if it\'s string, possibly coming from deserialize method\n        }\n        else if (isUtcDatetimeString(this.LastSurveyStartTimeUtc)) {\n            this.LastSurveyStartTimeUtc = stringToDate(this.LastSurveyStartTimeUtc);\n            // invalidate if it\'s not a Date object\n        }\n        else if (!isDate(this.LastSurveyStartTimeUtc)) {\n            return false;\n        }\n        // Set value to distance past if value not provided\n        if (isNOU(this.LastSurveyExpirationTimeUtc)) {\n            this.LastSurveyExpirationTimeUtc = getDistantPast();\n            // check if it\'s string, possibly coming from deserialize method\n        }\n        else if (isUtcDatetimeString(this.LastSurveyExpirationTimeUtc)) {\n            this.LastSurveyExpirationTimeUtc = stringToDate(this.LastSurveyExpirationTimeUtc);\n        }\n        else if (!isDate(this.LastSurveyExpirationTimeUtc)) {\n            return false;\n        }\n        // Set value to distance past if value not provided\n        if (isNOU(this.LastCooldownEndTimeUtc)) {\n            this.LastCooldownEndTimeUtc = getDistantPast();\n            // check if it\'s string, possibly coming from deserialize method\n        }\n        else if (isUtcDatetimeString(this.LastCooldownEndTimeUtc)) {\n            this.LastCooldownEndTimeUtc = stringToDate(this.LastCooldownEndTimeUtc);\n        }\n        else if (!isDate(this.LastCooldownEndTimeUtc)) {\n            return false;\n        }\n        return true;\n    };\n    /**\n     * Record that the current survey was taken on this date\n     *\n     * @param date date\n     * @param cooldownSeconds number\n     */\n    CampaignState.prototype.markCurrentSurveyTakenOnDate = function (date, cooldownSeconds, isSurveyComplete) {\n        this.DidCandidateTriggerSurvey = isSurveyComplete;\n        this.LastSurveyActivatedTimeUtc = date != null ? date : new Date();\n        this.LastCooldownEndTimeUtc = Utils.addSecondsWithoutOverflow(this.LastSurveyActivatedTimeUtc, cooldownSeconds);\n    };\n    CampaignState.prototype.getCooldownStartDate = function () {\n        if (!this.IsCandidate) {\n            return this.LastNominationTimeUtc;\n        }\n        if (this.DidCandidateTriggerSurvey) {\n            return this.LastSurveyActivatedTimeUtc;\n        }\n        // In practice this wil be equal to lastNominationTime, but\n        // distribution models like a ramp effectively cause us to\n        // shift our "effective nomination date" forward with the survey start date\n        return this.LastSurveyStartTimeUtc;\n    };\n    return CampaignState;\n}());\nexports.CampaignState = CampaignState;\nvar CampaignStateProviderFactory = /** @class */ (function () {\n    function CampaignStateProviderFactory() {\n    }\n    CampaignStateProviderFactory.make = function (fileBasedStorage, hostBasedStorage) {\n        if (hostBasedStorage) {\n            return new HostBasedCampaignStateProvider(fileBasedStorage, hostBasedStorage);\n        }\n        return new FileBasedCampaignStateProvider(fileBasedStorage);\n    };\n    return CampaignStateProviderFactory;\n}());\nexports.CampaignStateProviderFactory = CampaignStateProviderFactory;\n/**\n * Class representing what is stored in the file.\n */\nvar FileData = /** @class */ (function () {\n    function FileData() {\n    }\n    return FileData;\n}());\nvar HostBasedCampaignStateProvider = /** @class */ (function () {\n    function HostBasedCampaignStateProvider(fileBasedStorage, hostBasedStorage) {\n        if (!hostBasedStorage) {\n            throw new Error("host-based storage must not be null");\n        }\n        this.hostBasedStorage = hostBasedStorage;\n        // file-based provider is optional\n        if (fileBasedStorage) {\n            this.fileBasedStateProvider = new FileBasedCampaignStateProvider(fileBasedStorage);\n        }\n    }\n    // @Override\n    HostBasedCampaignStateProvider.prototype.load = function () {\n        var statesFromHost = this.getStatesFromHost();\n        var statesFromFile;\n        if (this.fileBasedStateProvider) {\n            statesFromFile = this.fileBasedStateProvider.load();\n        }\n        var StateCollections = StateProviderHelpers.MergeAndUpdateCampaignStates(statesFromFile, statesFromHost);\n        return StateCollections.find(0 /* Merged */);\n    };\n    // @Override\n    HostBasedCampaignStateProvider.prototype.save = function (campaignStates) {\n        var _this = this;\n        if (!campaignStates) {\n            return;\n        }\n        var statesFromHost = this.getStatesFromHost();\n        var StateCollections = StateProviderHelpers.MergeAndUpdateCampaignStates(campaignStates, statesFromHost);\n        var toBeUpdatedStates = StateCollections.find(1 /* ToBeUpdated */);\n        var mergedStates = StateCollections.find(0 /* Merged */);\n        // write delta_data to host\n        if (toBeUpdatedStates) {\n            toBeUpdatedStates.forEach(function (state) {\n                var stateValue = StateProviderHelpers.makeSettingItemValue(JSON.stringify(state));\n                _this.hostBasedStorage.upsertSettingItem(floodgate_shared_typings_1.FloodgateStorageProviderFileType[floodgate_shared_typings_1.FloodgateStorageProviderFileType.CampaignStates], state.CampaignId, stateValue);\n            });\n        }\n        // Write merged data to File\n        if (this.fileBasedStateProvider) {\n            this.fileBasedStateProvider.save(mergedStates);\n        }\n    };\n    HostBasedCampaignStateProvider.prototype.getStatesFromHost = function () {\n        var states = [];\n        var settings = this.hostBasedStorage.readSettingList(floodgate_shared_typings_1.FloodgateStorageProviderFileType[floodgate_shared_typings_1.FloodgateStorageProviderFileType.CampaignStates]);\n        for (var key in settings) {\n            if (!Object.prototype.hasOwnProperty.call(settings, key)) {\n                continue;\n            }\n            var value = settings[key];\n            var dataString = StateProviderHelpers.extractSettingItemValueSubString(value);\n            var itemObject = {};\n            try {\n                itemObject = JSON.parse(dataString);\n                var newState = CampaignState.deserialize(itemObject);\n                if (newState) {\n                    states.push(newState);\n                }\n            }\n            catch (e) {\n                TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.HostBasedCampaignStateProvider.GetStatesFromHost.Failed, { ErrorMessage: "Json parsing/deserializing failed. " + e.toString() + ".  Input:" + dataString });\n            }\n        }\n        return states;\n    };\n    return HostBasedCampaignStateProvider;\n}());\nexports.HostBasedCampaignStateProvider = HostBasedCampaignStateProvider;\nvar FileBasedCampaignStateProvider = /** @class */ (function () {\n    function FileBasedCampaignStateProvider(storage) {\n        if (!storage) {\n            throw new Error("storage must not be null");\n        }\n        this.storage = storage;\n    }\n    // @Override\n    FileBasedCampaignStateProvider.prototype.load = function () {\n        var readString = this.storage.read(floodgate_shared_typings_1.FloodgateStorageProviderFileType.CampaignStates);\n        if (!readString) {\n            return [];\n        }\n        var fileData;\n        try {\n            fileData = JSON.parse(readString);\n            var result_1 = [];\n            if (fileData && fileData.CampaignStates) {\n                fileData.CampaignStates.forEach(function (state) {\n                    var newState = CampaignState.deserialize(state);\n                    if (newState) {\n                        result_1.push(newState);\n                    }\n                });\n            }\n            return result_1;\n        }\n        catch (e) {\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FileBasedCampaignStateProvider.Load.Failed, { ErrorMessage: "Json parsing/deserializing failed. " + e.toString() + ".  Input:" + readString });\n            return [];\n        }\n    };\n    // @Override\n    FileBasedCampaignStateProvider.prototype.save = function (campaignStates) {\n        if (!campaignStates) {\n            return;\n        }\n        var fileData = new FileData();\n        fileData.CampaignStates = campaignStates;\n        var writeString = JSON.stringify(fileData);\n        this.storage.write(floodgate_shared_typings_1.FloodgateStorageProviderFileType.CampaignStates, writeString);\n    };\n    return FileBasedCampaignStateProvider;\n}());\nexports.FileBasedCampaignStateProvider = FileBasedCampaignStateProvider;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/Campaign/CampaignStateProvider.js\n')},"../FloodgateCore/dist/src/Campaign/CampaignSurveyFactory.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.CampaignSurveyFactory = void 0;\nvar floodgate_shared_typings_1 = __webpack_require__(/*! @ms-ofb/floodgate-shared-typings */ "../FloodgateCore/node_modules/@ms-ofb/floodgate-shared-typings/dist/index.js");\nvar SurveyEvents_1 = __webpack_require__(/*! ../SurveyEvents */ "../FloodgateCore/dist/src/SurveyEvents.js");\nvar SurveyMetadata_1 = __webpack_require__(/*! ../SurveyMetadata */ "../FloodgateCore/dist/src/SurveyMetadata.js");\nvar FpsSurvey_1 = __webpack_require__(/*! ../Surveys/FpsSurvey */ "../FloodgateCore/dist/src/Surveys/FpsSurvey.js");\nvar GenericMessagingSurfaceSurvey_1 = __webpack_require__(/*! ../Surveys/GenericMessagingSurfaceSurvey */ "../FloodgateCore/dist/src/Surveys/GenericMessagingSurfaceSurvey.js");\nvar InterceptSurvey_1 = __webpack_require__(/*! ../Surveys/InterceptSurvey */ "../FloodgateCore/dist/src/Surveys/InterceptSurvey.js");\nvar NlqsSurvey_1 = __webpack_require__(/*! ../Surveys/NlqsSurvey */ "../FloodgateCore/dist/src/Surveys/NlqsSurvey.js");\nvar NpsSurvey_1 = __webpack_require__(/*! ../Surveys/NpsSurvey */ "../FloodgateCore/dist/src/Surveys/NpsSurvey.js");\nvar SurveyDataSource_1 = __webpack_require__(/*! ../Surveys/SurveyDataSource */ "../FloodgateCore/dist/src/Surveys/SurveyDataSource.js");\nvar Utils = __webpack_require__(/*! ../Utils */ "../FloodgateCore/dist/src/Utils.js");\nvar CampaignDefinitionProvider_1 = __webpack_require__(/*! ./CampaignDefinitionProvider */ "../FloodgateCore/dist/src/Campaign/CampaignDefinitionProvider.js");\nvar dateToShortUtcString = Utils.dateToShortUtcString, isNOU = Utils.isNOU;\n/**\n * Contains methods to take a campaign definition + state and generate an ISurvey\n */\nvar CampaignSurveyFactory = /** @class */ (function () {\n    function CampaignSurveyFactory() {\n    }\n    CampaignSurveyFactory.makeSurvey = function (state, definition, stringProvider) {\n        if (!state || !definition || !definition.surveyTemplate || !stringProvider) {\n            return null;\n        }\n        var surveyDataSource = CampaignSurveyFactory.makeSurveyDataSourceData(state, definition);\n        var surveyModel = definition.surveyTemplate;\n        if (surveyModel instanceof CampaignDefinitionProvider_1.CampaignSurveyTemplateNps5PointStatic) {\n            return NpsSurvey_1.default.make5Point(surveyDataSource, stringProvider);\n        }\n        else if (surveyModel instanceof CampaignDefinitionProvider_1.CampaignSurveyTemplateNps11PointStatic) {\n            return NpsSurvey_1.default.make11Point(surveyDataSource, stringProvider);\n        }\n        else if (surveyModel instanceof CampaignDefinitionProvider_1.CampaignSurveyTemplateFps) {\n            return FpsSurvey_1.default.makeFps(surveyDataSource, stringProvider, surveyModel);\n        }\n        else if (surveyModel instanceof CampaignDefinitionProvider_1.CampaignSurveyTemplateNlqs) {\n            return NlqsSurvey_1.default.makeNlqs(surveyDataSource, stringProvider, surveyModel);\n        }\n        else if (surveyModel instanceof CampaignDefinitionProvider_1.CampaignSurveyTemplateNps) {\n            return NpsSurvey_1.default.makeCustom(surveyDataSource, stringProvider, surveyModel);\n        }\n        else if (surveyModel instanceof CampaignDefinitionProvider_1.CampaignSurveyTemplateGenericMessagingSurface) {\n            return GenericMessagingSurfaceSurvey_1.default.makeCustom(surveyDataSource);\n        }\n        else if (surveyModel instanceof CampaignDefinitionProvider_1.CampaignSurveyTemplateIntercept) {\n            return InterceptSurvey_1.default.makeIntercept(surveyDataSource, stringProvider, surveyModel);\n        }\n        else {\n            return null;\n        }\n    };\n    CampaignSurveyFactory.makeSurveyDataSourceData = function (state, definition) {\n        if (!state || !definition || !definition.surveyTemplate) {\n            return null;\n        }\n        var surveyModel = definition.surveyTemplate;\n        var surveyData = new SurveyDataSource_1.default.SurveyDataSourceData();\n        surveyData.activationEvent = CampaignSurveyFactory.makeEvent(state, surveyModel.activationEvent);\n        surveyData.metadata = CampaignSurveyFactory.makeMetadata(surveyModel.metadata);\n        surveyData.id = state.LastSurveyId;\n        surveyData.backEndIdentifier = state.CampaignId;\n        surveyData.expirationTimeUtc = dateToShortUtcString(state.LastSurveyExpirationTimeUtc);\n        surveyData.governedChannelType = definition.governedChannelType;\n        surveyData.startTimeUtc = dateToShortUtcString(state.LastSurveyStartTimeUtc);\n        surveyData.additionalDataRequested = definition.additionalDataRequested || [];\n        surveyData.launcherType = definition.launcherType || floodgate_shared_typings_1.LAUNCHER_TYPE_DEFAULT;\n        surveyData.preferredLaunchType = definition.surveyTemplate.preferredLaunchType || "Default" /* Default */;\n        surveyData.businessLevel = definition.businessLevel;\n        surveyData.tags = definition.tags;\n        surveyData.treatmentType = definition.treatmentType;\n        if (!isNOU(surveyModel.maxLaunches)) {\n            surveyData.maxLaunches = surveyModel.maxLaunches;\n        }\n        if (!isNOU(surveyModel.maxLaunchesPerSession)) {\n            surveyData.maxLaunchesPerSession = surveyModel.maxLaunchesPerSession;\n        }\n        return surveyData;\n    };\n    CampaignSurveyFactory.makeCountedActivityEventData = function (eventModel) {\n        if (!eventModel) {\n            return null;\n        }\n        var eventData = new SurveyEvents_1.CountedActivityEventData();\n        eventData.activity = eventModel.activity;\n        eventData.count = eventModel.count;\n        eventData.isAggregate = eventModel.isAggregate;\n        return eventData;\n    };\n    CampaignSurveyFactory.makeCountedActivityEvent = function (state, eventModel) {\n        if (!state || !eventModel) {\n            return null;\n        }\n        var eventData = CampaignSurveyFactory.makeCountedActivityEventData(eventModel);\n        if (!eventData) {\n            return null;\n        }\n        return new SurveyEvents_1.CountedActivityEvent(eventData);\n    };\n    CampaignSurveyFactory.makeCountedActivitySequenceEvent = function (state, eventModel) {\n        if (!state || !eventModel) {\n            return null;\n        }\n        var sequenceEventData = new SurveyEvents_1.CountedActivitySequenceEventData();\n        sequenceEventData.sequence = [];\n        for (var _i = 0, _a = eventModel.sequence; _i < _a.length; _i++) {\n            var event_1 = _a[_i];\n            var eventData = CampaignSurveyFactory.makeCountedActivityEventData(event_1);\n            if (!eventData) {\n                return null;\n            }\n            sequenceEventData.sequence.push(eventData);\n        }\n        return new SurveyEvents_1.CountedActivitySequenceEvent(sequenceEventData);\n    };\n    CampaignSurveyFactory.makeEvent = function (state, eventModel) {\n        if (eventModel instanceof CampaignDefinitionProvider_1.CampaignSurveyEventCountedActivity) {\n            return CampaignSurveyFactory.makeCountedActivityEvent(state, eventModel);\n        }\n        else if (eventModel instanceof CampaignDefinitionProvider_1.CampaignSurveyEventCountedActivitySequence) {\n            return CampaignSurveyFactory.makeCountedActivitySequenceEvent(state, eventModel);\n        }\n        else {\n            return null;\n        }\n    };\n    CampaignSurveyFactory.makeMetadata = function (metadataModel) {\n        if (isNOU(metadataModel) || isNOU(metadataModel.contentMetadata)) {\n            return null;\n        }\n        var metadata = new SurveyMetadata_1.Metadata();\n        metadata.contentMetadata = metadataModel.contentMetadata;\n        return new SurveyMetadata_1.SurveyMetadata(metadata);\n    };\n    return CampaignSurveyFactory;\n}());\nexports.CampaignSurveyFactory = CampaignSurveyFactory;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/Campaign/CampaignSurveyFactory.js\n')},"../FloodgateCore/dist/src/Constants.js":function(module,exports,__webpack_require__){"use strict";eval('\n/**\n * Constants.ts\n *\n * A module for all the constants.\n */\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.TelemetryEvent = void 0;\n/**\n * Telemetry events\n */\nvar TelemetryEvent = /** @class */ (function () {\n    function TelemetryEvent() {\n    }\n    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24;\n    TelemetryEvent.CampaignState = (_a = /** @class */ (function () {\n            function class_1() {\n            }\n            return class_1;\n        }()),\n        _a.Deserialize = (_b = /** @class */ (function () {\n                function class_2() {\n                }\n                return class_2;\n            }()),\n            _b.Failed = "FloodgateCore_CampaignState_Deserialize_Failed",\n            _b),\n        _a);\n    TelemetryEvent.FileBasedCampaignStateProvider = (_c = /** @class */ (function () {\n            function class_3() {\n            }\n            return class_3;\n        }()),\n        _c.Load = (_d = /** @class */ (function () {\n                function class_4() {\n                }\n                return class_4;\n            }()),\n            _d.Failed = "FloodgateCore_FileBasedCampaignStateProvider_Load_Failed",\n            _d),\n        _c);\n    TelemetryEvent.HostBasedCampaignStateProvider = (_e = /** @class */ (function () {\n            function class_5() {\n            }\n            return class_5;\n        }()),\n        _e.GetStatesFromHost = (_f = /** @class */ (function () {\n                function class_6() {\n                }\n                return class_6;\n            }()),\n            _f.Failed = "FloodgateCore_HostBasedCampaignStateProvider_GetStatesFromHost_Failed",\n            _f),\n        _e);\n    TelemetryEvent.Floodgate = (_g = /** @class */ (function () {\n            function class_7() {\n            }\n            return class_7;\n        }()),\n        _g.Initialize = (_h = /** @class */ (function () {\n                function class_8() {\n                }\n                return class_8;\n            }()),\n            _h.Failed = "FloodgateCore_Floodgate_Initialize_Failed",\n            _h),\n        _g.Start = (_j = /** @class */ (function () {\n                function class_9() {\n                }\n                return class_9;\n            }()),\n            _j.Failed = "FloodgateCore_Floodgate_Start_Failed",\n            _j.Warning = "FloodgateCore_Floodgate_Start_Warning",\n            _j.SurveysDisabled = "FloodgateCore_Floodgate_Start_SurveysDisabled",\n            _j.MessagingDisabled = "FloodgateCore_Floodgate_Start_MessagingDisabled",\n            _j.DynamicCampaignEnabled = "FloodgateCore_Floodgate_Start_DynamicCampaignEnabled",\n            _j.DynamicCampaignClientUndefined = "FloodgateCore_Floodgate_Start_DynamicCampaignClientUndefined",\n            _j),\n        _g.UserFactsLoad = (_k = /** @class */ (function () {\n                function class_10() {\n                }\n                return class_10;\n            }()),\n            _k.Failed = "FloodgateCore_Floodgate_UserFactsLoad_Failed",\n            _k),\n        _g.UserFactsSpecDeserialization = (_l = /** @class */ (function () {\n                function class_11() {\n                }\n                return class_11;\n            }()),\n            _l.Failed = "FloodgateCore_Floodgate_UserFactsSpecDeserialization_Failed",\n            _l),\n        _g.UserFactsSpecIsAMatch = (_m = /** @class */ (function () {\n                function class_12() {\n                }\n                return class_12;\n            }()),\n            _m.Failed = "FloodgateCore_Floodgate_UserFactsSpecIsAMatch_Failed",\n            _m.Mismatch = "FloodgateCore_Floodgate_UserFactsSpecIsAMatch_Mismatch",\n            _m.Summary = "FloodgateCore_Floodgate_UserFactsSpecIsAMatch_Summary",\n            _m),\n        _g.RenderSurvey = (_o = /** @class */ (function () {\n                function class_13() {\n                }\n                return class_13;\n            }()),\n            _o.Unsupported = "FloodgateCore_Floodgate_RenderSurvey_Unsupported",\n            _o),\n        _g);\n    TelemetryEvent.FloodgateEngine = (_p = /** @class */ (function () {\n            function class_14() {\n            }\n            return class_14;\n        }()),\n        _p.Make = (_q = /** @class */ (function () {\n                function class_15() {\n                }\n                return class_15;\n            }()),\n            _q.Failed = "FloodgateCore_FloodgateEngine_Make_Failed",\n            _q),\n        _p.Common = (_r = /** @class */ (function () {\n                function class_16() {\n                }\n                return class_16;\n            }()),\n            _r.Error = "FloodgateCore_FloodgateEngine_Common_Error",\n            _r.ActiveSurveys = "FloodgateCore_FloodgateEngine_Common_ActiveSurveys",\n            _r),\n        _p.Start = (_s = /** @class */ (function () {\n                function class_17() {\n                }\n                return class_17;\n            }()),\n            _s.Failed = "FloodgateCore_FloodgateEngine_Start_Failed",\n            _s),\n        _p.StartAsync = (_t = /** @class */ (function () {\n                function class_18() {\n                }\n                return class_18;\n            }()),\n            _t.Failed = "FloodgateCore_FloodgateEngine_StartAsync_Failed",\n            _t.Stopped = "FloodgateCore_FloodgateEngine_StartAsync_Stopped",\n            _t),\n        _p.InitialLoadedDefinitions = "FloodgateCore_FloodgateEngine_InitialLoadedDefinitions",\n        _p.CampaignTypeDisabledDefinitions = "FloodgateCore_FloodgateEngine_CampaignTypeDisabledDefinitions",\n        _p.CampaignInitialTriggerMet = "FloodgateCore_FloodgateEngine_CampaignInitialTriggerMet",\n        _p.GetActiveSurveys = "FloodgateCore_FloodgateEngine_GetActiveSurveys",\n        _p.OnSurveyActivated = (_u = /** @class */ (function () {\n                function class_19() {\n                }\n                return class_19;\n            }()),\n            _u.ActivationStatsSuppressedSurvey = "FloodgateCore_FloodgateEngine_OnSurveyActivated_ActivationStatsSuppressedSurvey",\n            _u.ClosedChannelType = "FloodgateCore_FloodgateEngine_OnSurveyActivated_ClosedChannelType",\n            _u.SurveyNotDefined = "FloodgateCore_FloodgateEngine_OnSurveyActivated_SurveyNotDefined",\n            _u.SessionSuppressedSurvey = "FloodgateCore_FloodgateEngine_OnSurveyActivated_SessionSuppressedSurvey",\n            _u.ActivationExpiredSurvey = "FloodgateCore_FloodgateEngine_OnSurveyActivated_ActivationExpiredSurvey",\n            _u.ActivationIrrelevantSurvey = "FloodgateCore_FloodgateEngine_OnSurveyActivated_ActivationIrrelevantSurvey",\n            _u.Error = "FloodgateCore_FloodgateEngine_OnSurveyActivated_Error",\n            _u),\n        _p.CheckGovernanceServiceAndActivateSurvey = (_v = /** @class */ (function () {\n                function class_20() {\n                }\n                return class_20;\n            }()),\n            _v.GovernanceServiceForceToDisplay = "FloodgateCore_FloodgateEngine_GovernanceService_GovernanceServiceForceToDisplay",\n            _v.GovernanceServiceClientCompleted = "FloodgateCore_FloodgateEngine_GovernanceService_GovernanceServiceClientCompleted",\n            _v.GovernanceServiceSurveyInCooldown = "FloodgateCore_FloodgateEngine_GovernanceService_GovernanceServiceSurveyInCooldown",\n            _v),\n        _p.QueryTriggerMetApisAsync = (_w = /** @class */ (function () {\n                function class_21() {\n                }\n                return class_21;\n            }()),\n            _w.Exception = "FloodgateCore_FloodgateEngine_QueryTriggerMetApisAsync_Exception",\n            _w.QueryTriggerMetApisAsync = "FloodgateCore_FloodgateEngine_QueryTriggerMetApisAsync",\n            _w.SurveyCdnFailureConcurrently = "FloodgateCore_FloodgateEngine_QueryTriggerMetApisAsync_SurveyCdnFailureConcurrently",\n            _w.SurveyCdnFailureSequentially = "FloodgateCore_FloodgateEngine_QueryTriggerMetApisAsync_SurveyCdnFailureSequentially",\n            _w),\n        _p);\n    TelemetryEvent.GovernedChannelState = (_x = /** @class */ (function () {\n            function class_22() {\n            }\n            return class_22;\n        }()),\n        _x.Deserialize = (_y = /** @class */ (function () {\n                function class_23() {\n                }\n                return class_23;\n            }()),\n            _y.Failed = "FloodgateCore_GovernedChannelState_Deserialize_Failed",\n            _y),\n        _x);\n    TelemetryEvent.FileBasedGovernedChannelStateProvider = (_z = /** @class */ (function () {\n            function class_24() {\n            }\n            return class_24;\n        }()),\n        _z.Load = (_0 = /** @class */ (function () {\n                function class_25() {\n                }\n                return class_25;\n            }()),\n            _0.Failed = "FloodgateCore_FileBasedGovernedChannelStateProvider_Load_Failed",\n            _0),\n        _z);\n    TelemetryEvent.HostBasedGovernedChannelStateProvider = (_1 = /** @class */ (function () {\n            function class_26() {\n            }\n            return class_26;\n        }()),\n        _1.GetStatesFromHost = (_2 = /** @class */ (function () {\n                function class_27() {\n                }\n                return class_27;\n            }()),\n            _2.Failed = "FloodgateCore_HostBasedGovernedChannelStateProvider_GetStatesFromHost_Failed",\n            _2),\n        _1);\n    TelemetryEvent.SurveyStatCollectionActivation = (_3 = /** @class */ (function () {\n            function class_28() {\n            }\n            return class_28;\n        }()),\n        _3.FromJson = (_4 = /** @class */ (function () {\n                function class_29() {\n                }\n                return class_29;\n            }()),\n            _4.Failed = "FloodgateCore_SurveyStatCollectionActivation_FromJson_Failed",\n            _4),\n        _3.ToJson = (_5 = /** @class */ (function () {\n                function class_30() {\n                }\n                return class_30;\n            }()),\n            _5.Failed = "FloodgateCore_SurveyStatCollectionActivation_ToJson_Failed",\n            _5),\n        _3);\n    TelemetryEvent.HostBasedSurveyActivationStatsProvider = (_6 = /** @class */ (function () {\n            function class_31() {\n            }\n            return class_31;\n        }()),\n        _6.GetSurveyStatsFromHost = (_7 = /** @class */ (function () {\n                function class_32() {\n                }\n                return class_32;\n            }()),\n            _7.Failed = "FloodgateCore_HostBasedSurveyActivationStatsProvider_GetSurveyStatsFromHost_Failed",\n            _7),\n        _6);\n    TelemetryEvent.SurveyStatCollectionEventActivity = (_8 = /** @class */ (function () {\n            function class_33() {\n            }\n            return class_33;\n        }()),\n        _8.FromJson = (_9 = /** @class */ (function () {\n                function class_34() {\n                }\n                return class_34;\n            }()),\n            _9.Failed = "FloodgateCore_SurveyStatCollectionEventActivity_FromJson_Failed",\n            _9),\n        _8.ToJson = (_10 = /** @class */ (function () {\n                function class_35() {\n                }\n                return class_35;\n            }()),\n            _10.Failed = "FloodgateCore_SurveyStatCollectionEventActivity_ToJson_Failed",\n            _10),\n        _8);\n    TelemetryEvent.SurveyActivity = (_11 = /** @class */ (function () {\n            function class_36() {\n            }\n            return class_36;\n        }()),\n        _11.LogActivity = (_12 = /** @class */ (function () {\n                function class_37() {\n                }\n                return class_37;\n            }()),\n            _12.EventsReprocessed = "FloodgateCore_SurveyActivity_LogActivity_EventsReprocessed",\n            _12.SurveysReprocessed = "FloodgateCore_SurveyActivity_LogActivity_SurveysReprocessed",\n            _12),\n        _11.SetActivityTrackingContracts = (_13 = /** @class */ (function () {\n                function class_38() {\n                }\n                return class_38;\n            }()),\n            _13.DuplicateSurveyID = "FloodgateCore_SurveyActivity_SetActivityTrackingContracts_DuplicateSurveyID",\n            _13),\n        _11);\n    TelemetryEvent.DynamicCampaignDefinitionProvider = (_14 = /** @class */ (function () {\n            function class_39() {\n            }\n            return class_39;\n        }()),\n        _14.Load = (_15 = /** @class */ (function () {\n                function class_40() {\n                }\n                return class_40;\n            }()),\n            _15.EmptyEcsConfig = "FloodgateCore_DynamicCampaignDefinitionProvider_Load_EmptyEcsConfig",\n            _15.InvalidEcsConfig = "FloodgateCore_DynamicCampaignDefinitionProvider_Load_InvalidEcsConfig",\n            _15),\n        _14);\n    TelemetryEvent.CampaignDefinitionProvider = (_16 = /** @class */ (function () {\n            function class_41() {\n            }\n            return class_41;\n        }()),\n        _16.CampaignSurveyTemplate = (_17 = /** @class */ (function () {\n                function class_42() {\n                }\n                return class_42;\n            }()),\n            _17.SchemaValidationError = "FloodgateCore_CampaignDefinitionProvider_CampaignSurveyTemplate_validate",\n            _17),\n        _16);\n    TelemetryEvent.CampaignGovernance = (_18 = /** @class */ (function () {\n            function class_43() {\n            }\n            return class_43;\n        }()),\n        _18.LogExperimentTrigger = (_19 = /** @class */ (function () {\n                function class_44() {\n                }\n                return class_44;\n            }()),\n            _19.Undefined = "FloodgateCore_CampaignGovernance_LogExperimentTrigger_Undefined",\n            _19.Failed = "FloodgateCore_CampaignGovernance_LogExperimentTrigger_Failed",\n            _19),\n        _18.RetrieveTriggerEventDetail = (_20 = /** @class */ (function () {\n                function class_45() {\n                }\n                return class_45;\n            }()),\n            _20.Failed = "FloodgateCore_CampaignGovernance_RetrieveTriggerEventDetail_Failed",\n            _20),\n        _18.NominationCheckCampaigns = "FloodgateCore_CampaignGovernance_NominationCheckCampaigns",\n        _18);\n    TelemetryEvent.HttpTransport = (_21 = /** @class */ (function () {\n            function class_46() {\n            }\n            return class_46;\n        }()),\n        _21.GET = (_22 = /** @class */ (function () {\n                function class_47() {\n                }\n                return class_47;\n            }()),\n            _22.Success = "HttpTransport_Get_Success",\n            _22.Error = "HttpTransport_Get_Error",\n            _22),\n        _21);\n    TelemetryEvent.FloodgateSurveyCdnClient = (_23 = /** @class */ (function () {\n            function class_48() {\n            }\n            return class_48;\n        }()),\n        _23.loadCdnStringResource = (_24 = /** @class */ (function () {\n                function class_49() {\n                }\n                return class_49;\n            }()),\n            _24.Request_Failed = "Floodgate_Survey_CDN_Request_Failed",\n            _24.Request_Success = "Floodgate_Survey_CDN_Request_Success",\n            _24.Exception = "Floodgate_Survey_CDN_Exception",\n            _24.Completed = "Floodgate_Survey_CDN_Completed",\n            _24),\n        _23);\n    return TelemetryEvent;\n}());\nexports.TelemetryEvent = TelemetryEvent;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vc3JjL0NvbnN0YW50cy50cz8wNjEwIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7OztHQUlHOzs7QUFFSDs7R0FFRztBQUNIO0lBQUE7SUFrTUEsQ0FBQzs7SUFqTWMsNEJBQWE7WUFBRztZQUk5QixDQUFDO1lBQUQsY0FBQztRQUFELENBQUM7UUFIYyxjQUFXO2dCQUFHO2dCQUU1QixDQUFDO2dCQUFELGNBQUM7WUFBRCxDQUFDO1lBRGMsU0FBTSxHQUFHLGdEQUFpRDtlQUN2RTtZQUNEO0lBRVksNkNBQThCO1lBQUc7WUFJL0MsQ0FBQztZQUFELGNBQUM7UUFBRCxDQUFDO1FBSGMsT0FBSTtnQkFBRztnQkFFckIsQ0FBQztnQkFBRCxjQUFDO1lBQUQsQ0FBQztZQURjLFNBQU0sR0FBRywwREFBMkQ7ZUFDakY7WUFDRDtJQUVZLDZDQUE4QjtZQUFHO1lBSS9DLENBQUM7WUFBRCxjQUFDO1FBQUQsQ0FBQztRQUhjLG9CQUFpQjtnQkFBRztnQkFFbEMsQ0FBQztnQkFBRCxjQUFDO1lBQUQsQ0FBQztZQURjLFNBQU0sR0FBRyx1RUFBd0U7ZUFDOUY7WUFDRDtJQUVZLHdCQUFTO1lBQUc7WUErQjFCLENBQUM7WUFBRCxjQUFDO1FBQUQsQ0FBQztRQTlCYyxhQUFVO2dCQUFHO2dCQUUzQixDQUFDO2dCQUFELGNBQUM7WUFBRCxDQUFDO1lBRGMsU0FBTSxHQUFHLDJDQUE0QztlQUNsRTtRQUVZLFFBQUs7Z0JBQUc7Z0JBT3RCLENBQUM7Z0JBQUQsY0FBQztZQUFELENBQUM7WUFOYyxTQUFNLEdBQUcsc0NBQXVDO1lBQ2hELFVBQU8sR0FBRyx1Q0FBd0M7WUFDbEQsa0JBQWUsR0FBRywrQ0FBZ0Q7WUFDbEUsb0JBQWlCLEdBQUcsaURBQWtEO1lBQ3RFLHlCQUFzQixHQUFHLHNEQUF1RDtZQUNoRixpQ0FBOEIsR0FBRyw4REFBK0Q7ZUFDN0c7UUFFWSxnQkFBYTtnQkFBRztnQkFFOUIsQ0FBQztnQkFBRCxlQUFDO1lBQUQsQ0FBQztZQURjLFNBQU0sR0FBRyw4Q0FBK0M7ZUFDckU7UUFFWSwrQkFBNEI7Z0JBQUc7Z0JBRTdDLENBQUM7Z0JBQUQsZUFBQztZQUFELENBQUM7WUFEYyxTQUFNLEdBQUcsNkRBQThEO2VBQ3BGO1FBRVksd0JBQXFCO2dCQUFHO2dCQUl0QyxDQUFDO2dCQUFELGVBQUM7WUFBRCxDQUFDO1lBSGMsU0FBTSxHQUFHLHNEQUF1RDtZQUNoRSxXQUFRLEdBQUcsd0RBQXlEO1lBQ3BFLFVBQU8sR0FBRyx1REFBd0Q7ZUFDL0U7UUFFWSxlQUFZO2dCQUFHO2dCQUU3QixDQUFDO2dCQUFELGVBQUM7WUFBRCxDQUFDO1lBRGMsY0FBVyxHQUFHLGtEQUFtRDtlQUM5RTtZQUNEO0lBRVksOEJBQWU7WUFBRztZQThDaEMsQ0FBQztZQUFELGVBQUM7UUFBRCxDQUFDO1FBN0NjLE9BQUk7Z0JBQUc7Z0JBRXJCLENBQUM7Z0JBQUQsZUFBQztZQUFELENBQUM7WUFEYyxTQUFNLEdBQUcsMkNBQTRDO2VBQ2xFO1FBRVksU0FBTTtnQkFBRztnQkFHdkIsQ0FBQztnQkFBRCxlQUFDO1lBQUQsQ0FBQztZQUZjLFFBQUssR0FBRyw0Q0FBNkM7WUFDckQsZ0JBQWEsR0FBRyxvREFBcUQ7ZUFDbEY7UUFFWSxRQUFLO2dCQUFHO2dCQUV0QixDQUFDO2dCQUFELGVBQUM7WUFBRCxDQUFDO1lBRGMsU0FBTSxHQUFHLDRDQUE2QztlQUNuRTtRQUVZLGFBQVU7Z0JBQUc7Z0JBRzNCLENBQUM7Z0JBQUQsZUFBQztZQUFELENBQUM7WUFGYyxTQUFNLEdBQUcsaURBQWtEO1lBQzNELFVBQU8sR0FBRyxrREFBbUQ7ZUFDMUU7UUFFWSwyQkFBd0IsR0FBRyx3REFBeUQ7UUFDcEYsa0NBQStCLEdBQUcsK0RBQWdFO1FBQ2xHLDRCQUF5QixHQUFHLHlEQUEwRDtRQUN0RixtQkFBZ0IsR0FBRyxnREFBaUQ7UUFFcEUsb0JBQWlCO2dCQUFHO2dCQVFsQyxDQUFDO2dCQUFELGVBQUM7WUFBRCxDQUFDO1lBUGMsa0NBQStCLEdBQUcsaUZBQWtGO1lBQ3BILG9CQUFpQixHQUFHLG1FQUFvRTtZQUN4RixtQkFBZ0IsR0FBRyxrRUFBbUU7WUFDdEYsMEJBQXVCLEdBQUcseUVBQTBFO1lBQ3BHLDBCQUF1QixHQUFHLHlFQUEwRTtZQUNwRyw2QkFBMEIsR0FBRyw0RUFBNkU7WUFDMUcsUUFBSyxHQUFHLHVEQUF3RDtlQUM3RTtRQUVZLDBDQUF1QztnQkFBRztnQkFJeEQsQ0FBQztnQkFBRCxlQUFDO1lBQUQsQ0FBQztZQUhjLGtDQUErQixHQUFHLGlGQUFrRjtZQUNwSCxtQ0FBZ0MsR0FBRyxrRkFBbUY7WUFDdEgsb0NBQWlDLEdBQUcsbUZBQW9GO2VBQ3JJO1FBRVksMkJBQXdCO2dCQUFHO2dCQUt6QyxDQUFDO2dCQUFELGVBQUM7WUFBRCxDQUFDO1lBSmMsWUFBUyxHQUFHLGtFQUFtRTtZQUMvRSwyQkFBd0IsR0FBRyx3REFBeUQ7WUFDcEYsK0JBQTRCLEdBQUcscUZBQXNGO1lBQ3JILCtCQUE0QixHQUFHLHFGQUFzRjtlQUNsSTtZQUNEO0lBRVksbUNBQW9CO1lBQUc7WUFJckMsQ0FBQztZQUFELGVBQUM7UUFBRCxDQUFDO1FBSGMsY0FBVztnQkFBRztnQkFFNUIsQ0FBQztnQkFBRCxlQUFDO1lBQUQsQ0FBQztZQURjLFNBQU0sR0FBRyx1REFBd0Q7ZUFDOUU7WUFDRDtJQUVZLG9EQUFxQztZQUFHO1lBSXRELENBQUM7WUFBRCxlQUFDO1FBQUQsQ0FBQztRQUhjLE9BQUk7Z0JBQUc7Z0JBRXJCLENBQUM7Z0JBQUQsZUFBQztZQUFELENBQUM7WUFEYyxTQUFNLEdBQUcsaUVBQWtFO2VBQ3hGO1lBQ0Q7SUFFWSxvREFBcUM7WUFBRztZQUl0RCxDQUFDO1lBQUQsZUFBQztRQUFELENBQUM7UUFIYyxvQkFBaUI7Z0JBQUc7Z0JBRWxDLENBQUM7Z0JBQUQsZUFBQztZQUFELENBQUM7WUFEYyxTQUFNLEdBQUcsOEVBQStFO2VBQ3JHO1lBQ0Q7SUFFWSw2Q0FBOEI7WUFBRztZQVEvQyxDQUFDO1lBQUQsZUFBQztRQUFELENBQUM7UUFQYyxXQUFRO2dCQUFHO2dCQUV6QixDQUFDO2dCQUFELGVBQUM7WUFBRCxDQUFDO1lBRGMsU0FBTSxHQUFHLDhEQUErRDtlQUNyRjtRQUVZLFNBQU07Z0JBQUc7Z0JBRXZCLENBQUM7Z0JBQUQsZUFBQztZQUFELENBQUM7WUFEYyxTQUFNLEdBQUcsNERBQTZEO2VBQ25GO1lBQ0Q7SUFFWSxxREFBc0M7WUFBRztZQUl2RCxDQUFDO1lBQUQsZUFBQztRQUFELENBQUM7UUFIYyx5QkFBc0I7Z0JBQUc7Z0JBRXZDLENBQUM7Z0JBQUQsZUFBQztZQUFELENBQUM7WUFEYyxTQUFNLEdBQUcsb0ZBQXFGO2VBQzNHO1lBQ0Q7SUFFWSxnREFBaUM7WUFBRztZQVFsRCxDQUFDO1lBQUQsZUFBQztRQUFELENBQUM7UUFQYyxXQUFRO2dCQUFHO2dCQUV6QixDQUFDO2dCQUFELGVBQUM7WUFBRCxDQUFDO1lBRGMsU0FBTSxHQUFHLGlFQUFrRTtlQUN4RjtRQUVZLFNBQU07Z0JBQUc7Z0JBRXZCLENBQUM7Z0JBQUQsZUFBQztZQUFELENBQUM7WUFEYyxVQUFNLEdBQUcsK0RBQWdFO2dCQUN0RjtZQUNEO0lBRVksNkJBQWM7WUFBRztZQVMvQixDQUFDO1lBQUQsZUFBQztRQUFELENBQUM7UUFSYyxlQUFXO2dCQUFHO2dCQUc1QixDQUFDO2dCQUFELGVBQUM7WUFBRCxDQUFDO1lBRmMscUJBQWlCLEdBQUcsNERBQTZEO1lBQ2pGLHNCQUFrQixHQUFHLDZEQUE4RDtnQkFDaEc7UUFFWSxnQ0FBNEI7Z0JBQUc7Z0JBRTdDLENBQUM7Z0JBQUQsZUFBQztZQUFELENBQUM7WUFEYyxxQkFBaUIsR0FBRyw2RUFBOEU7Z0JBQy9HO2FBQ0Q7SUFFWSxnREFBaUM7WUFBRztZQUtsRCxDQUFDO1lBQUQsZUFBQztRQUFELENBQUM7UUFKYyxRQUFJO2dCQUFHO2dCQUdyQixDQUFDO2dCQUFELGVBQUM7WUFBRCxDQUFDO1lBRmMsa0JBQWMsR0FBRyxxRUFBc0U7WUFDdkYsb0JBQWdCLEdBQUcsdUVBQXdFO2dCQUN4RzthQUNEO0lBRVkseUNBQTBCO1lBQUc7WUFJM0MsQ0FBQztZQUFELGVBQUM7UUFBRCxDQUFDO1FBSGMsMEJBQXNCO2dCQUFHO2dCQUV2QyxDQUFDO2dCQUFELGVBQUM7WUFBRCxDQUFDO1lBRGMseUJBQXFCLEdBQUcsMEVBQTJFO2dCQUNoSDthQUNEO0lBRVksaUNBQWtCO1lBQUc7WUFTbkMsQ0FBQztZQUFELGVBQUM7UUFBRCxDQUFDO1FBUmMsd0JBQW9CO2dCQUFHO2dCQUdyQyxDQUFDO2dCQUFELGVBQUM7WUFBRCxDQUFDO1lBRmMsYUFBUyxHQUFHLGlFQUFrRTtZQUM5RSxVQUFNLEdBQUcsOERBQStEO2dCQUN0RjtRQUNhLDhCQUEwQjtnQkFBRztnQkFFM0MsQ0FBQztnQkFBRCxlQUFDO1lBQUQsQ0FBQztZQURjLFVBQU0sR0FBRyxvRUFBcUU7Z0JBQzNGO1FBQ1ksNEJBQXdCLEdBQUcsMkRBQTREO2FBQ3BHO0lBRVksNEJBQWE7WUFBRztZQUs5QixDQUFDO1lBQUQsZUFBQztRQUFELENBQUM7UUFKYyxPQUFHO2dCQUFHO2dCQUdwQixDQUFDO2dCQUFELGVBQUM7WUFBRCxDQUFDO1lBRmMsV0FBTyxHQUFHLDJCQUE0QjtZQUN0QyxTQUFLLEdBQUcseUJBQTBCO2dCQUNoRDthQUNEO0lBRWEsdUNBQXdCO1lBQUc7WUFPekMsQ0FBQztZQUFELGVBQUM7UUFBRCxDQUFDO1FBTmMseUJBQXFCO2dCQUFHO2dCQUt0QyxDQUFDO2dCQUFELGVBQUM7WUFBRCxDQUFDO1lBSmMsa0JBQWMsR0FBRyxxQ0FBc0M7WUFDdkQsbUJBQWUsR0FBRyxzQ0FBdUM7WUFDekQsYUFBUyxHQUFHLGdDQUFpQztZQUM3QyxhQUFTLEdBQUcsZ0NBQWlDO2dCQUMzRDthQUNEO0lBQ0YscUJBQUM7Q0FBQTtBQWxNWSx3Q0FBYyIsImZpbGUiOiIuLi9GbG9vZGdhdGVDb3JlL2Rpc3Qvc3JjL0NvbnN0YW50cy5qcy5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxyXG4gKiBDb25zdGFudHMudHNcclxuICpcclxuICogQSBtb2R1bGUgZm9yIGFsbCB0aGUgY29uc3RhbnRzLlxyXG4gKi9cclxuXHJcbi8qKlxyXG4gKiBUZWxlbWV0cnkgZXZlbnRzXHJcbiAqL1xyXG5leHBvcnQgY2xhc3MgVGVsZW1ldHJ5RXZlbnQge1xyXG5cdHB1YmxpYyBzdGF0aWMgQ2FtcGFpZ25TdGF0ZSA9IGNsYXNzIHtcclxuXHRcdHB1YmxpYyBzdGF0aWMgRGVzZXJpYWxpemUgPSBjbGFzcyB7XHJcblx0XHRcdHB1YmxpYyBzdGF0aWMgRmFpbGVkID0gXCJGbG9vZGdhdGVDb3JlX0NhbXBhaWduU3RhdGVfRGVzZXJpYWxpemVfRmFpbGVkXCI7XHJcblx0XHR9O1xyXG5cdH07XHJcblxyXG5cdHB1YmxpYyBzdGF0aWMgRmlsZUJhc2VkQ2FtcGFpZ25TdGF0ZVByb3ZpZGVyID0gY2xhc3Mge1xyXG5cdFx0cHVibGljIHN0YXRpYyBMb2FkID0gY2xhc3Mge1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIEZhaWxlZCA9IFwiRmxvb2RnYXRlQ29yZV9GaWxlQmFzZWRDYW1wYWlnblN0YXRlUHJvdmlkZXJfTG9hZF9GYWlsZWRcIjtcclxuXHRcdH07XHJcblx0fTtcclxuXHJcblx0cHVibGljIHN0YXRpYyBIb3N0QmFzZWRDYW1wYWlnblN0YXRlUHJvdmlkZXIgPSBjbGFzcyB7XHJcblx0XHRwdWJsaWMgc3RhdGljIEdldFN0YXRlc0Zyb21Ib3N0ID0gY2xhc3Mge1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIEZhaWxlZCA9IFwiRmxvb2RnYXRlQ29yZV9Ib3N0QmFzZWRDYW1wYWlnblN0YXRlUHJvdmlkZXJfR2V0U3RhdGVzRnJvbUhvc3RfRmFpbGVkXCI7XHJcblx0XHR9O1xyXG5cdH07XHJcblxyXG5cdHB1YmxpYyBzdGF0aWMgRmxvb2RnYXRlID0gY2xhc3Mge1xyXG5cdFx0cHVibGljIHN0YXRpYyBJbml0aWFsaXplID0gY2xhc3Mge1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIEZhaWxlZCA9IFwiRmxvb2RnYXRlQ29yZV9GbG9vZGdhdGVfSW5pdGlhbGl6ZV9GYWlsZWRcIjtcclxuXHRcdH07XHJcblxyXG5cdFx0cHVibGljIHN0YXRpYyBTdGFydCA9IGNsYXNzIHtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBGYWlsZWQgPSBcIkZsb29kZ2F0ZUNvcmVfRmxvb2RnYXRlX1N0YXJ0X0ZhaWxlZFwiO1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIFdhcm5pbmcgPSBcIkZsb29kZ2F0ZUNvcmVfRmxvb2RnYXRlX1N0YXJ0X1dhcm5pbmdcIjtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBTdXJ2ZXlzRGlzYWJsZWQgPSBcIkZsb29kZ2F0ZUNvcmVfRmxvb2RnYXRlX1N0YXJ0X1N1cnZleXNEaXNhYmxlZFwiO1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIE1lc3NhZ2luZ0Rpc2FibGVkID0gXCJGbG9vZGdhdGVDb3JlX0Zsb29kZ2F0ZV9TdGFydF9NZXNzYWdpbmdEaXNhYmxlZFwiO1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIER5bmFtaWNDYW1wYWlnbkVuYWJsZWQgPSBcIkZsb29kZ2F0ZUNvcmVfRmxvb2RnYXRlX1N0YXJ0X0R5bmFtaWNDYW1wYWlnbkVuYWJsZWRcIjtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBEeW5hbWljQ2FtcGFpZ25DbGllbnRVbmRlZmluZWQgPSBcIkZsb29kZ2F0ZUNvcmVfRmxvb2RnYXRlX1N0YXJ0X0R5bmFtaWNDYW1wYWlnbkNsaWVudFVuZGVmaW5lZFwiO1xyXG5cdFx0fTtcclxuXHJcblx0XHRwdWJsaWMgc3RhdGljIFVzZXJGYWN0c0xvYWQgPSBjbGFzcyB7XHJcblx0XHRcdHB1YmxpYyBzdGF0aWMgRmFpbGVkID0gXCJGbG9vZGdhdGVDb3JlX0Zsb29kZ2F0ZV9Vc2VyRmFjdHNMb2FkX0ZhaWxlZFwiO1xyXG5cdFx0fTtcclxuXHJcblx0XHRwdWJsaWMgc3RhdGljIFVzZXJGYWN0c1NwZWNEZXNlcmlhbGl6YXRpb24gPSBjbGFzcyB7XHJcblx0XHRcdHB1YmxpYyBzdGF0aWMgRmFpbGVkID0gXCJGbG9vZGdhdGVDb3JlX0Zsb29kZ2F0ZV9Vc2VyRmFjdHNTcGVjRGVzZXJpYWxpemF0aW9uX0ZhaWxlZFwiO1xyXG5cdFx0fTtcclxuXHJcblx0XHRwdWJsaWMgc3RhdGljIFVzZXJGYWN0c1NwZWNJc0FNYXRjaCA9IGNsYXNzIHtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBGYWlsZWQgPSBcIkZsb29kZ2F0ZUNvcmVfRmxvb2RnYXRlX1VzZXJGYWN0c1NwZWNJc0FNYXRjaF9GYWlsZWRcIjtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBNaXNtYXRjaCA9IFwiRmxvb2RnYXRlQ29yZV9GbG9vZGdhdGVfVXNlckZhY3RzU3BlY0lzQU1hdGNoX01pc21hdGNoXCI7XHJcblx0XHRcdHB1YmxpYyBzdGF0aWMgU3VtbWFyeSA9IFwiRmxvb2RnYXRlQ29yZV9GbG9vZGdhdGVfVXNlckZhY3RzU3BlY0lzQU1hdGNoX1N1bW1hcnlcIjtcclxuXHRcdH07XHJcblxyXG5cdFx0cHVibGljIHN0YXRpYyBSZW5kZXJTdXJ2ZXkgPSBjbGFzcyB7XHJcblx0XHRcdHB1YmxpYyBzdGF0aWMgVW5zdXBwb3J0ZWQgPSBcIkZsb29kZ2F0ZUNvcmVfRmxvb2RnYXRlX1JlbmRlclN1cnZleV9VbnN1cHBvcnRlZFwiO1xyXG5cdFx0fTtcclxuXHR9O1xyXG5cclxuXHRwdWJsaWMgc3RhdGljIEZsb29kZ2F0ZUVuZ2luZSA9IGNsYXNzIHtcclxuXHRcdHB1YmxpYyBzdGF0aWMgTWFrZSA9IGNsYXNzIHtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBGYWlsZWQgPSBcIkZsb29kZ2F0ZUNvcmVfRmxvb2RnYXRlRW5naW5lX01ha2VfRmFpbGVkXCI7XHJcblx0XHR9O1xyXG5cclxuXHRcdHB1YmxpYyBzdGF0aWMgQ29tbW9uID0gY2xhc3Mge1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIEVycm9yID0gXCJGbG9vZGdhdGVDb3JlX0Zsb29kZ2F0ZUVuZ2luZV9Db21tb25fRXJyb3JcIjtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBBY3RpdmVTdXJ2ZXlzID0gXCJGbG9vZGdhdGVDb3JlX0Zsb29kZ2F0ZUVuZ2luZV9Db21tb25fQWN0aXZlU3VydmV5c1wiO1xyXG5cdFx0fTtcclxuXHJcblx0XHRwdWJsaWMgc3RhdGljIFN0YXJ0ID0gY2xhc3Mge1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIEZhaWxlZCA9IFwiRmxvb2RnYXRlQ29yZV9GbG9vZGdhdGVFbmdpbmVfU3RhcnRfRmFpbGVkXCI7XHJcblx0XHR9O1xyXG5cclxuXHRcdHB1YmxpYyBzdGF0aWMgU3RhcnRBc3luYyA9IGNsYXNzIHtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBGYWlsZWQgPSBcIkZsb29kZ2F0ZUNvcmVfRmxvb2RnYXRlRW5naW5lX1N0YXJ0QXN5bmNfRmFpbGVkXCI7XHJcblx0XHRcdHB1YmxpYyBzdGF0aWMgU3RvcHBlZCA9IFwiRmxvb2RnYXRlQ29yZV9GbG9vZGdhdGVFbmdpbmVfU3RhcnRBc3luY19TdG9wcGVkXCI7XHJcblx0XHR9O1xyXG5cclxuXHRcdHB1YmxpYyBzdGF0aWMgSW5pdGlhbExvYWRlZERlZmluaXRpb25zID0gXCJGbG9vZGdhdGVDb3JlX0Zsb29kZ2F0ZUVuZ2luZV9Jbml0aWFsTG9hZGVkRGVmaW5pdGlvbnNcIjtcclxuXHRcdHB1YmxpYyBzdGF0aWMgQ2FtcGFpZ25UeXBlRGlzYWJsZWREZWZpbml0aW9ucyA9IFwiRmxvb2RnYXRlQ29yZV9GbG9vZGdhdGVFbmdpbmVfQ2FtcGFpZ25UeXBlRGlzYWJsZWREZWZpbml0aW9uc1wiO1xyXG5cdFx0cHVibGljIHN0YXRpYyBDYW1wYWlnbkluaXRpYWxUcmlnZ2VyTWV0ID0gXCJGbG9vZGdhdGVDb3JlX0Zsb29kZ2F0ZUVuZ2luZV9DYW1wYWlnbkluaXRpYWxUcmlnZ2VyTWV0XCI7XHJcblx0XHRwdWJsaWMgc3RhdGljIEdldEFjdGl2ZVN1cnZleXMgPSBcIkZsb29kZ2F0ZUNvcmVfRmxvb2RnYXRlRW5naW5lX0dldEFjdGl2ZVN1cnZleXNcIjtcclxuXHJcblx0XHRwdWJsaWMgc3RhdGljIE9uU3VydmV5QWN0aXZhdGVkID0gY2xhc3Mge1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIEFjdGl2YXRpb25TdGF0c1N1cHByZXNzZWRTdXJ2ZXkgPSBcIkZsb29kZ2F0ZUNvcmVfRmxvb2RnYXRlRW5naW5lX09uU3VydmV5QWN0aXZhdGVkX0FjdGl2YXRpb25TdGF0c1N1cHByZXNzZWRTdXJ2ZXlcIjtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBDbG9zZWRDaGFubmVsVHlwZSA9IFwiRmxvb2RnYXRlQ29yZV9GbG9vZGdhdGVFbmdpbmVfT25TdXJ2ZXlBY3RpdmF0ZWRfQ2xvc2VkQ2hhbm5lbFR5cGVcIjtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBTdXJ2ZXlOb3REZWZpbmVkID0gXCJGbG9vZGdhdGVDb3JlX0Zsb29kZ2F0ZUVuZ2luZV9PblN1cnZleUFjdGl2YXRlZF9TdXJ2ZXlOb3REZWZpbmVkXCI7XHJcblx0XHRcdHB1YmxpYyBzdGF0aWMgU2Vzc2lvblN1cHByZXNzZWRTdXJ2ZXkgPSBcIkZsb29kZ2F0ZUNvcmVfRmxvb2RnYXRlRW5naW5lX09uU3VydmV5QWN0aXZhdGVkX1Nlc3Npb25TdXBwcmVzc2VkU3VydmV5XCI7XHJcblx0XHRcdHB1YmxpYyBzdGF0aWMgQWN0aXZhdGlvbkV4cGlyZWRTdXJ2ZXkgPSBcIkZsb29kZ2F0ZUNvcmVfRmxvb2RnYXRlRW5naW5lX09uU3VydmV5QWN0aXZhdGVkX0FjdGl2YXRpb25FeHBpcmVkU3VydmV5XCI7XHJcblx0XHRcdHB1YmxpYyBzdGF0aWMgQWN0aXZhdGlvbklycmVsZXZhbnRTdXJ2ZXkgPSBcIkZsb29kZ2F0ZUNvcmVfRmxvb2RnYXRlRW5naW5lX09uU3VydmV5QWN0aXZhdGVkX0FjdGl2YXRpb25JcnJlbGV2YW50U3VydmV5XCI7XHJcblx0XHRcdHB1YmxpYyBzdGF0aWMgRXJyb3IgPSBcIkZsb29kZ2F0ZUNvcmVfRmxvb2RnYXRlRW5naW5lX09uU3VydmV5QWN0aXZhdGVkX0Vycm9yXCI7XHJcblx0XHR9O1xyXG5cclxuXHRcdHB1YmxpYyBzdGF0aWMgQ2hlY2tHb3Zlcm5hbmNlU2VydmljZUFuZEFjdGl2YXRlU3VydmV5ID0gY2xhc3Mge1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIEdvdmVybmFuY2VTZXJ2aWNlRm9yY2VUb0Rpc3BsYXkgPSBcIkZsb29kZ2F0ZUNvcmVfRmxvb2RnYXRlRW5naW5lX0dvdmVybmFuY2VTZXJ2aWNlX0dvdmVybmFuY2VTZXJ2aWNlRm9yY2VUb0Rpc3BsYXlcIjtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBHb3Zlcm5hbmNlU2VydmljZUNsaWVudENvbXBsZXRlZCA9IFwiRmxvb2RnYXRlQ29yZV9GbG9vZGdhdGVFbmdpbmVfR292ZXJuYW5jZVNlcnZpY2VfR292ZXJuYW5jZVNlcnZpY2VDbGllbnRDb21wbGV0ZWRcIjtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBHb3Zlcm5hbmNlU2VydmljZVN1cnZleUluQ29vbGRvd24gPSBcIkZsb29kZ2F0ZUNvcmVfRmxvb2RnYXRlRW5naW5lX0dvdmVybmFuY2VTZXJ2aWNlX0dvdmVybmFuY2VTZXJ2aWNlU3VydmV5SW5Db29sZG93blwiO1xyXG5cdFx0fTtcclxuXHRcdFxyXG5cdFx0cHVibGljIHN0YXRpYyBRdWVyeVRyaWdnZXJNZXRBcGlzQXN5bmMgPSBjbGFzcyB7XHJcblx0XHRcdHB1YmxpYyBzdGF0aWMgRXhjZXB0aW9uID0gXCJGbG9vZGdhdGVDb3JlX0Zsb29kZ2F0ZUVuZ2luZV9RdWVyeVRyaWdnZXJNZXRBcGlzQXN5bmNfRXhjZXB0aW9uXCI7XHJcblx0XHRcdHB1YmxpYyBzdGF0aWMgUXVlcnlUcmlnZ2VyTWV0QXBpc0FzeW5jID0gXCJGbG9vZGdhdGVDb3JlX0Zsb29kZ2F0ZUVuZ2luZV9RdWVyeVRyaWdnZXJNZXRBcGlzQXN5bmNcIjtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBTdXJ2ZXlDZG5GYWlsdXJlQ29uY3VycmVudGx5ID0gXCJGbG9vZGdhdGVDb3JlX0Zsb29kZ2F0ZUVuZ2luZV9RdWVyeVRyaWdnZXJNZXRBcGlzQXN5bmNfU3VydmV5Q2RuRmFpbHVyZUNvbmN1cnJlbnRseVwiO1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIFN1cnZleUNkbkZhaWx1cmVTZXF1ZW50aWFsbHkgPSBcIkZsb29kZ2F0ZUNvcmVfRmxvb2RnYXRlRW5naW5lX1F1ZXJ5VHJpZ2dlck1ldEFwaXNBc3luY19TdXJ2ZXlDZG5GYWlsdXJlU2VxdWVudGlhbGx5XCI7XHJcblx0XHR9O1xyXG5cdH07XHJcblxyXG5cdHB1YmxpYyBzdGF0aWMgR292ZXJuZWRDaGFubmVsU3RhdGUgPSBjbGFzcyB7XHJcblx0XHRwdWJsaWMgc3RhdGljIERlc2VyaWFsaXplID0gY2xhc3Mge1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIEZhaWxlZCA9IFwiRmxvb2RnYXRlQ29yZV9Hb3Zlcm5lZENoYW5uZWxTdGF0ZV9EZXNlcmlhbGl6ZV9GYWlsZWRcIjtcclxuXHRcdH07XHJcblx0fTtcclxuXHJcblx0cHVibGljIHN0YXRpYyBGaWxlQmFzZWRHb3Zlcm5lZENoYW5uZWxTdGF0ZVByb3ZpZGVyID0gY2xhc3Mge1xyXG5cdFx0cHVibGljIHN0YXRpYyBMb2FkID0gY2xhc3Mge1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIEZhaWxlZCA9IFwiRmxvb2RnYXRlQ29yZV9GaWxlQmFzZWRHb3Zlcm5lZENoYW5uZWxTdGF0ZVByb3ZpZGVyX0xvYWRfRmFpbGVkXCI7XHJcblx0XHR9O1xyXG5cdH07XHJcblxyXG5cdHB1YmxpYyBzdGF0aWMgSG9zdEJhc2VkR292ZXJuZWRDaGFubmVsU3RhdGVQcm92aWRlciA9IGNsYXNzIHtcclxuXHRcdHB1YmxpYyBzdGF0aWMgR2V0U3RhdGVzRnJvbUhvc3QgPSBjbGFzcyB7XHJcblx0XHRcdHB1YmxpYyBzdGF0aWMgRmFpbGVkID0gXCJGbG9vZGdhdGVDb3JlX0hvc3RCYXNlZEdvdmVybmVkQ2hhbm5lbFN0YXRlUHJvdmlkZXJfR2V0U3RhdGVzRnJvbUhvc3RfRmFpbGVkXCI7XHJcblx0XHR9O1xyXG5cdH07XHJcblxyXG5cdHB1YmxpYyBzdGF0aWMgU3VydmV5U3RhdENvbGxlY3Rpb25BY3RpdmF0aW9uID0gY2xhc3Mge1xyXG5cdFx0cHVibGljIHN0YXRpYyBGcm9tSnNvbiA9IGNsYXNzIHtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBGYWlsZWQgPSBcIkZsb29kZ2F0ZUNvcmVfU3VydmV5U3RhdENvbGxlY3Rpb25BY3RpdmF0aW9uX0Zyb21Kc29uX0ZhaWxlZFwiO1xyXG5cdFx0fTtcclxuXHJcblx0XHRwdWJsaWMgc3RhdGljIFRvSnNvbiA9IGNsYXNzIHtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBGYWlsZWQgPSBcIkZsb29kZ2F0ZUNvcmVfU3VydmV5U3RhdENvbGxlY3Rpb25BY3RpdmF0aW9uX1RvSnNvbl9GYWlsZWRcIjtcclxuXHRcdH07XHJcblx0fTtcclxuXHJcblx0cHVibGljIHN0YXRpYyBIb3N0QmFzZWRTdXJ2ZXlBY3RpdmF0aW9uU3RhdHNQcm92aWRlciA9IGNsYXNzIHtcclxuXHRcdHB1YmxpYyBzdGF0aWMgR2V0U3VydmV5U3RhdHNGcm9tSG9zdCA9IGNsYXNzIHtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBGYWlsZWQgPSBcIkZsb29kZ2F0ZUNvcmVfSG9zdEJhc2VkU3VydmV5QWN0aXZhdGlvblN0YXRzUHJvdmlkZXJfR2V0U3VydmV5U3RhdHNGcm9tSG9zdF9GYWlsZWRcIjtcclxuXHRcdH07XHJcblx0fTtcclxuXHJcblx0cHVibGljIHN0YXRpYyBTdXJ2ZXlTdGF0Q29sbGVjdGlvbkV2ZW50QWN0aXZpdHkgPSBjbGFzcyB7XHJcblx0XHRwdWJsaWMgc3RhdGljIEZyb21Kc29uID0gY2xhc3Mge1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIEZhaWxlZCA9IFwiRmxvb2RnYXRlQ29yZV9TdXJ2ZXlTdGF0Q29sbGVjdGlvbkV2ZW50QWN0aXZpdHlfRnJvbUpzb25fRmFpbGVkXCI7XHJcblx0XHR9O1xyXG5cclxuXHRcdHB1YmxpYyBzdGF0aWMgVG9Kc29uID0gY2xhc3Mge1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIEZhaWxlZCA9IFwiRmxvb2RnYXRlQ29yZV9TdXJ2ZXlTdGF0Q29sbGVjdGlvbkV2ZW50QWN0aXZpdHlfVG9Kc29uX0ZhaWxlZFwiO1xyXG5cdFx0fTtcclxuXHR9O1xyXG5cclxuXHRwdWJsaWMgc3RhdGljIFN1cnZleUFjdGl2aXR5ID0gY2xhc3Mge1xyXG5cdFx0cHVibGljIHN0YXRpYyBMb2dBY3Rpdml0eSA9IGNsYXNzIHtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBFdmVudHNSZXByb2Nlc3NlZCA9IFwiRmxvb2RnYXRlQ29yZV9TdXJ2ZXlBY3Rpdml0eV9Mb2dBY3Rpdml0eV9FdmVudHNSZXByb2Nlc3NlZFwiO1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIFN1cnZleXNSZXByb2Nlc3NlZCA9IFwiRmxvb2RnYXRlQ29yZV9TdXJ2ZXlBY3Rpdml0eV9Mb2dBY3Rpdml0eV9TdXJ2ZXlzUmVwcm9jZXNzZWRcIjtcclxuXHRcdH07XHJcblxyXG5cdFx0cHVibGljIHN0YXRpYyBTZXRBY3Rpdml0eVRyYWNraW5nQ29udHJhY3RzID0gY2xhc3Mge1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIER1cGxpY2F0ZVN1cnZleUlEID0gXCJGbG9vZGdhdGVDb3JlX1N1cnZleUFjdGl2aXR5X1NldEFjdGl2aXR5VHJhY2tpbmdDb250cmFjdHNfRHVwbGljYXRlU3VydmV5SURcIjtcclxuXHRcdH07XHJcblx0fTtcclxuXHJcblx0cHVibGljIHN0YXRpYyBEeW5hbWljQ2FtcGFpZ25EZWZpbml0aW9uUHJvdmlkZXIgPSBjbGFzcyB7XHJcblx0XHRwdWJsaWMgc3RhdGljIExvYWQgPSBjbGFzcyB7XHJcblx0XHRcdHB1YmxpYyBzdGF0aWMgRW1wdHlFY3NDb25maWcgPSBcIkZsb29kZ2F0ZUNvcmVfRHluYW1pY0NhbXBhaWduRGVmaW5pdGlvblByb3ZpZGVyX0xvYWRfRW1wdHlFY3NDb25maWdcIjtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBJbnZhbGlkRWNzQ29uZmlnID0gXCJGbG9vZGdhdGVDb3JlX0R5bmFtaWNDYW1wYWlnbkRlZmluaXRpb25Qcm92aWRlcl9Mb2FkX0ludmFsaWRFY3NDb25maWdcIjtcclxuXHRcdH07XHJcblx0fTtcclxuXHJcblx0cHVibGljIHN0YXRpYyBDYW1wYWlnbkRlZmluaXRpb25Qcm92aWRlciA9IGNsYXNzIHtcclxuXHRcdHB1YmxpYyBzdGF0aWMgQ2FtcGFpZ25TdXJ2ZXlUZW1wbGF0ZSA9IGNsYXNzIHtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBTY2hlbWFWYWxpZGF0aW9uRXJyb3IgPSBcIkZsb29kZ2F0ZUNvcmVfQ2FtcGFpZ25EZWZpbml0aW9uUHJvdmlkZXJfQ2FtcGFpZ25TdXJ2ZXlUZW1wbGF0ZV92YWxpZGF0ZVwiO1xyXG5cdFx0fTtcclxuXHR9O1xyXG5cclxuXHRwdWJsaWMgc3RhdGljIENhbXBhaWduR292ZXJuYW5jZSA9IGNsYXNzIHtcclxuXHRcdHB1YmxpYyBzdGF0aWMgTG9nRXhwZXJpbWVudFRyaWdnZXIgPSBjbGFzcyB7XHJcblx0XHRcdHB1YmxpYyBzdGF0aWMgVW5kZWZpbmVkID0gXCJGbG9vZGdhdGVDb3JlX0NhbXBhaWduR292ZXJuYW5jZV9Mb2dFeHBlcmltZW50VHJpZ2dlcl9VbmRlZmluZWRcIjtcdFxyXG5cdFx0XHRwdWJsaWMgc3RhdGljIEZhaWxlZCA9IFwiRmxvb2RnYXRlQ29yZV9DYW1wYWlnbkdvdmVybmFuY2VfTG9nRXhwZXJpbWVudFRyaWdnZXJfRmFpbGVkXCI7XHRcclxuXHRcdH1cclxuXHRcdHB1YmxpYyBzdGF0aWMgUmV0cmlldmVUcmlnZ2VyRXZlbnREZXRhaWwgPSBjbGFzcyB7XHJcblx0XHRcdHB1YmxpYyBzdGF0aWMgRmFpbGVkID0gXCJGbG9vZGdhdGVDb3JlX0NhbXBhaWduR292ZXJuYW5jZV9SZXRyaWV2ZVRyaWdnZXJFdmVudERldGFpbF9GYWlsZWRcIjtcdFxyXG5cdFx0fTtcclxuXHRcdHB1YmxpYyBzdGF0aWMgTm9taW5hdGlvbkNoZWNrQ2FtcGFpZ25zID0gXCJGbG9vZGdhdGVDb3JlX0NhbXBhaWduR292ZXJuYW5jZV9Ob21pbmF0aW9uQ2hlY2tDYW1wYWlnbnNcIjtcclxuXHR9O1xyXG5cclxuXHRwdWJsaWMgc3RhdGljIEh0dHBUcmFuc3BvcnQgPSBjbGFzcyB7XHJcblx0XHRwdWJsaWMgc3RhdGljIEdFVCA9IGNsYXNzIHtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBTdWNjZXNzID0gXCJIdHRwVHJhbnNwb3J0X0dldF9TdWNjZXNzXCI7XHJcblx0XHRcdHB1YmxpYyBzdGF0aWMgRXJyb3IgPSBcIkh0dHBUcmFuc3BvcnRfR2V0X0Vycm9yXCI7XHJcblx0XHR9XHJcblx0fVxyXG5cclxuXHRwdWJsaWMgc3RhdGljIEZsb29kZ2F0ZVN1cnZleUNkbkNsaWVudCA9IGNsYXNzIHtcclxuXHRcdHB1YmxpYyBzdGF0aWMgbG9hZENkblN0cmluZ1Jlc291cmNlID0gY2xhc3Mge1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIFJlcXVlc3RfRmFpbGVkID0gXCJGbG9vZGdhdGVfU3VydmV5X0NETl9SZXF1ZXN0X0ZhaWxlZFwiO1xyXG5cdFx0XHRwdWJsaWMgc3RhdGljIFJlcXVlc3RfU3VjY2VzcyA9IFwiRmxvb2RnYXRlX1N1cnZleV9DRE5fUmVxdWVzdF9TdWNjZXNzXCI7XHJcblx0XHRcdHB1YmxpYyBzdGF0aWMgRXhjZXB0aW9uID0gXCJGbG9vZGdhdGVfU3VydmV5X0NETl9FeGNlcHRpb25cIjtcclxuXHRcdFx0cHVibGljIHN0YXRpYyBDb21wbGV0ZWQgPSBcIkZsb29kZ2F0ZV9TdXJ2ZXlfQ0ROX0NvbXBsZXRlZFwiO1xyXG5cdFx0fVxyXG5cdH1cclxufVxyXG4iXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/Constants.js\n')},"../FloodgateCore/dist/src/FeatureGateProvider.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.getFeatureGateProvider = exports.setFeatureGateProvider = void 0;\nvar featureGateProvider;\nfunction setFeatureGateProvider(provider) {\n    featureGateProvider = provider;\n}\nexports.setFeatureGateProvider = setFeatureGateProvider;\nfunction getFeatureGateProvider() {\n    return featureGateProvider;\n}\nexports.getFeatureGateProvider = getFeatureGateProvider;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vc3JjL0ZlYXR1cmVHYXRlUHJvdmlkZXIudHM/NzVjYyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFFQSxJQUFJLG1CQUFvRCxDQUFDO0FBRXpELFNBQWdCLHNCQUFzQixDQUFDLFFBQXlDO0lBQy9FLG1CQUFtQixHQUFHLFFBQVEsQ0FBQztBQUNoQyxDQUFDO0FBRkQsd0RBRUM7QUFFRCxTQUFnQixzQkFBc0I7SUFDckMsT0FBTyxtQkFBbUIsQ0FBQztBQUM1QixDQUFDO0FBRkQsd0RBRUMiLCJmaWxlIjoiLi4vRmxvb2RnYXRlQ29yZS9kaXN0L3NyYy9GZWF0dXJlR2F0ZVByb3ZpZGVyLmpzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSUZsb29kZ2F0ZUZlYXR1cmVTdGF0dXNDYWxsYmFjayB9IGZyb20gXCJAbXMtb2ZiL2Zsb29kZ2F0ZS1zaGFyZWQtdHlwaW5nc1wiO1xyXG5cclxubGV0IGZlYXR1cmVHYXRlUHJvdmlkZXI6IElGbG9vZGdhdGVGZWF0dXJlU3RhdHVzQ2FsbGJhY2s7XHJcblxyXG5leHBvcnQgZnVuY3Rpb24gc2V0RmVhdHVyZUdhdGVQcm92aWRlcihwcm92aWRlcjogSUZsb29kZ2F0ZUZlYXR1cmVTdGF0dXNDYWxsYmFjaykge1xyXG5cdGZlYXR1cmVHYXRlUHJvdmlkZXIgPSBwcm92aWRlcjtcclxufVxyXG5cclxuZXhwb3J0IGZ1bmN0aW9uIGdldEZlYXR1cmVHYXRlUHJvdmlkZXIoKSB7XHJcblx0cmV0dXJuIGZlYXR1cmVHYXRlUHJvdmlkZXI7XHJcbn0iXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/FeatureGateProvider.js\n')},"../FloodgateCore/dist/src/FloodgateEngine.js":function(module,exports,__webpack_require__){"use strict";eval('\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nvar __generator = (this && this.__generator) || function (thisArg, body) {\n    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;\n    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;\n    function verb(n) { return function (v) { return step([n, v]); }; }\n    function step(op) {\n        if (f) throw new TypeError("Generator is already executing.");\n        while (_) try {\n            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;\n            if (y = 0, t) op = [op[0] & 2, t.value];\n            switch (op[0]) {\n                case 0: case 1: t = op; break;\n                case 4: _.label++; return { value: op[1], done: false };\n                case 5: _.label++; y = op[1]; op = [0]; continue;\n                case 7: op = _.ops.pop(); _.trys.pop(); continue;\n                default:\n                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }\n                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }\n                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }\n                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }\n                    if (t[2]) _.ops.pop();\n                    _.trys.pop(); continue;\n            }\n            op = body.call(thisArg, _);\n        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }\n        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };\n    }\n};\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.FloodgateEngine = void 0;\nvar CampaignDefinitionProvider_1 = __webpack_require__(/*! ./Campaign/CampaignDefinitionProvider */ "../FloodgateCore/dist/src/Campaign/CampaignDefinitionProvider.js");\nvar floodgate_shared_typings_1 = __webpack_require__(/*! @ms-ofb/floodgate-shared-typings */ "../FloodgateCore/node_modules/@ms-ofb/floodgate-shared-typings/dist/index.js");\nvar GovernedChannelStateProvider_1 = __webpack_require__(/*! ./GovernedChannelStateProvider */ "../FloodgateCore/dist/src/GovernedChannelStateProvider.js");\nvar SurveyStatCollectionActivation_1 = __webpack_require__(/*! ./SurveyStatCollectionActivation */ "../FloodgateCore/dist/src/SurveyStatCollectionActivation.js");\nvar SurveyStatCollectionEventActivity_1 = __webpack_require__(/*! ./SurveyStatCollectionEventActivity */ "../FloodgateCore/dist/src/SurveyStatCollectionEventActivity.js");\nvar GovernanceUtils_1 = __webpack_require__(/*! ./GovernanceUtils */ "../FloodgateCore/dist/src/GovernanceUtils.js");\nvar ActivityTrackingContract_1 = __webpack_require__(/*! ./ActivityTrackingContract */ "../FloodgateCore/dist/src/ActivityTrackingContract.js");\nvar CampaignManager_1 = __webpack_require__(/*! ./Campaign/CampaignManager */ "../FloodgateCore/dist/src/Campaign/CampaignManager.js");\nvar CampaignStateProvider_1 = __webpack_require__(/*! ./Campaign/CampaignStateProvider */ "../FloodgateCore/dist/src/Campaign/CampaignStateProvider.js");\nvar FloodgateSettings_1 = __webpack_require__(/*! ./FloodgateSettings */ "../FloodgateCore/dist/src/FloodgateSettings.js");\nvar SurveyActivityListener_1 = __webpack_require__(/*! ./SurveyActivityListener */ "../FloodgateCore/dist/src/SurveyActivityListener.js");\nvar Constants_1 = __webpack_require__(/*! ./Constants */ "../FloodgateCore/dist/src/Constants.js");\nvar Utils_1 = __webpack_require__(/*! ./Utils */ "../FloodgateCore/dist/src/Utils.js");\nvar FloodgateSurveyCdnClient_1 = __webpack_require__(/*! ./FloodgateSurveyCdn/FloodgateSurveyCdnClient */ "../FloodgateCore/dist/src/FloodgateSurveyCdn/FloodgateSurveyCdnClient.js");\nvar FeatureGateProvider_1 = __webpack_require__(/*! ./FeatureGateProvider */ "../FloodgateCore/dist/src/FeatureGateProvider.js");\nvar Api_1 = __webpack_require__(/*! ./OrchestrationEngine/Api */ "../FloodgateCore/dist/src/OrchestrationEngine/Api.js");\nvar OrchestrationEngine_1 = __webpack_require__(/*! ./OrchestrationEngine/OrchestrationEngine */ "../FloodgateCore/dist/src/OrchestrationEngine/OrchestrationEngine.js");\nvar TelemetryLogger_1 = __webpack_require__(/*! ./TelemetryLogger */ "../FloodgateCore/dist/src/TelemetryLogger.js");\nvar defaultSurveyActivityListener = {\n    run: function (survey) {\n    },\n    shouldAcceptActivity: function (activityName) {\n        return true;\n    },\n};\nvar globalSessionSurveyActivationCounts = {};\n/**\n * Floodgate Engine class.  The main wiring hub and the brains responsible for\n * linking together the survey definitions, governance, activity tracking, and\n * survey launchers.  Only one-instance-at-a-time of these should be created\n * per app session.\n */\nvar FloodgateEngine = /** @class */ (function () {\n    function FloodgateEngine(surveyClient, activityListener, launcherFactory, onSurveyActivatedCallback, storage, orchestrationEngine, surveyActivationStatsProvider, transporterFactory, campaignTelemetrySamplingConfig, floodgateEngineConfig, personalizerClient) {\n        this.initializationStatus = 0 /* None */;\n        this.candidateSurveys = {};\n        this.launchedSurveys = {};\n        this.launchedLaunchers = [];\n        this.surveyEventSent = [];\n        this.staleTriggeredSurveysQueue = [];\n        if (!surveyClient) {\n            throw new Error("surveyClient must not be null");\n        }\n        if (!activityListener) {\n            throw new Error("activityListener must not be null");\n        }\n        if (!launcherFactory) {\n            throw new Error("launcherFactory must not be null");\n        }\n        if (!onSurveyActivatedCallback) {\n            throw new Error("onSurveyActivatedCallback must not be null");\n        }\n        if (!storage) {\n            throw new Error("storage must not be null");\n        }\n        if (!orchestrationEngine) {\n            throw new Error("governor must not be null");\n        }\n        if (!transporterFactory) {\n            throw new Error("transporterFactory must not be null");\n        }\n        this.surveyClient = surveyClient;\n        this.activityListener = activityListener;\n        this.launcherFactory = launcherFactory;\n        this.onSurveyActivatedCallback = onSurveyActivatedCallback;\n        this.storage = storage;\n        this.orchestrationEngine = orchestrationEngine;\n        this.surveyActivationStatsProvider = surveyActivationStatsProvider;\n        this.campaignTelemetrySamplingConfig = campaignTelemetrySamplingConfig;\n        this.floodgateEngineConfig = floodgateEngineConfig;\n        this.personalizerClient = personalizerClient;\n        FloodgateEngine.transporterFactory = transporterFactory;\n        this.loggedFirstStart = false;\n        // Initialize our list to a valid, empty collection\n        this.setPendingSurveys(null);\n        // If the listener was pre-configured with survey for some reason, clear it now\n        this.activityListener.clearSurveys();\n        // Link ourselves with the listener\n        /* eslint-disable-next-line @typescript-eslint/no-this-alias*/\n        var thisObj = this; // Save current object in a variable to allow access from callback.\n        this.activityListener.setCallback({\n            run: function (surveyId, contextInfo) {\n                thisObj.onSurveyActivated(surveyId, contextInfo);\n            },\n            shouldAcceptActivity: function (activityName) {\n                return thisObj.shouldAcceptActivity(activityName);\n            },\n        });\n    }\n    FloodgateEngine.getTransportFactory = function () {\n        return FloodgateEngine.transporterFactory;\n    };\n    FloodgateEngine.make = function (buildVersion, launcherFactory, onSurveyActivatedCallback, fileBasedStorageProvider, hostBasedStorageProvider, stringProvider, environmentProvider, transporterFactory, campaignDefinitionProviders, userFactsProvider, governanceServiceClient, isPriorityEnabled, floodgateEngineConfig, appGovernanceProvider, logExperimentTrigger, campaignTelemetrySamplingConfig, personalizerClient, messagingEnabled, surveyEnabled, surveyClient) {\n        try {\n            var governedChannelStateProvider = GovernedChannelStateProvider_1.GovernedChannelStateProviderFactory.make(fileBasedStorageProvider, hostBasedStorageProvider);\n            var surveyActivationStatsProvider = SurveyStatCollectionActivation_1.SurveyActivationStatsProviderFactory.make(fileBasedStorageProvider, hostBasedStorageProvider);\n            var campaignStateProvider = CampaignStateProvider_1.CampaignStateProviderFactory.make(fileBasedStorageProvider, hostBasedStorageProvider);\n            // Push to front of array so that it is the first provider to be checked.\n            // FilterCampaignData method overwrites the latest campaign definition with the same id.\n            // So, the static campaign definition provider should have the least priority during override.\n            campaignDefinitionProviders.unshift(new CampaignDefinitionProvider_1.FileSystemCampaignDefinitionProvider(fileBasedStorageProvider));\n            var orchestrationEngine_1 = new OrchestrationEngine_1.OrchestrationEngine(governanceServiceClient, governedChannelStateProvider, appGovernanceProvider);\n            var getSurveyCandidacyChecker = function (surveyForm) {\n                return orchestrationEngine_1.isSurveyTrackable(surveyForm);\n            };\n            var surveyCandidacyChecker = { isSurveyTrackable: getSurveyCandidacyChecker };\n            var client = surveyClient || new CampaignManager_1.CampaignManager(campaignStateProvider, campaignDefinitionProviders, stringProvider, environmentProvider, buildVersion, new Date(), isPriorityEnabled, userFactsProvider, surveyCandidacyChecker, logExperimentTrigger, campaignTelemetrySamplingConfig, messagingEnabled, surveyEnabled);\n            return new FloodgateEngine(client, new SurveyActivityListener_1.default(defaultSurveyActivityListener, TelemetryLogger_1.TelemetryLogger.getTelemetryLogger), launcherFactory, onSurveyActivatedCallback, fileBasedStorageProvider, orchestrationEngine_1, surveyActivationStatsProvider, transporterFactory, campaignTelemetrySamplingConfig, floodgateEngineConfig, personalizerClient);\n        }\n        catch (e) {\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.Make.Failed, { ErrorMessage: e && e.toString(), ErrorDetails: e && e.stack });\n        }\n    };\n    FloodgateEngine.prototype.getSurveyClient = function () {\n        return this.surveyClient;\n    };\n    /**\n     * Save all internal stats and floodgateSettings (merging with existing file contents), without stopping the engine.\n     */\n    FloodgateEngine.prototype.mergeAndSave = function () {\n        this.saveSettings();\n        this.saveSurveyActivationHistory();\n        this.saveSurveyEventActivityHistory();\n        // Inform surveyClient to save its state\n        this.surveyClient.saveCurrentState();\n        // Save governed channel states\n        this.orchestrationEngine.mergeAndSave();\n    };\n    /**\n     * Start the engine.  Checks feature enable state, causes survey definitions to be read, and tracked activities to be set on the listener.\n     */\n    FloodgateEngine.prototype.start = function () {\n        if (this.initializationStatus === 2 /* Initializing */ ||\n            this.initializationStatus === 3 /* Started */) {\n            return;\n        }\n        try {\n            this.setInitializationStatus(2 /* Initializing */);\n            this.loadSettingsAndPriorEventCounts();\n            var channelTypes = this.orchestrationEngine.getAvailableChannels();\n            this.surveyClient.refreshSurveyDefinitions(channelTypes);\n            this.setPendingSurveysAndStartFloodgate();\n            this.setInitializationStatus(3 /* Started */);\n        }\n        catch (e) {\n            this.setInitializationStatus(1 /* Error */);\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.Start.Failed, { ErrorMessage: e && e.toString(), ErrorDetails: e && e.stack });\n        }\n    };\n    /**\n     * Start the engine.  Checks feature enable state, causes survey definitions to be read, and tracked activities to be set on the listener.\n     */\n    FloodgateEngine.prototype.startAsync = function () {\n        var _this = this;\n        if (this.initializationStatus === 2 /* Initializing */ ||\n            this.initializationStatus === 3 /* Started */) {\n            return Promise.resolve();\n        }\n        try {\n            this.setInitializationStatus(2 /* Initializing */);\n            this.loadSettingsAndPriorEventCounts();\n            var channelTypes_1 = this.orchestrationEngine.getAvailableChannels();\n            return new Promise(function (resolve, reject) {\n                _this.surveyClient.refreshSurveyDefinitionsAsync(channelTypes_1).then(function () {\n                    // Handle any stop() calls that happened while initializing\n                    if (_this.initializationStatus === 4 /* Stopped */) {\n                        _this.setInitializationStatus(3 /* Started */);\n                        _this.stop();\n                        TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.StartAsync.Stopped, { ErrorMessage: "Stopped because of a pending stop() call" });\n                    }\n                    else {\n                        _this.setPendingSurveysAndStartFloodgate();\n                    }\n                    resolve();\n                }).catch(function (error) {\n                    _this.setInitializationStatus(1 /* Error */);\n                    TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.StartAsync.Failed, { ErrorMessage: "Survey refresh error " + (error && error.message) });\n                    reject(error);\n                });\n            });\n        }\n        catch (e) {\n            this.setInitializationStatus(1 /* Error */);\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.StartAsync.Failed, { ErrorMessage: e && e.toString(), ErrorDetails: e && e.stack });\n            return Promise.resolve();\n        }\n    };\n    /**\n     * Stop the engine.  Causes tracked activities to be cleared and any in-progress counters not otherwise saved to be thrown out.\n     */\n    FloodgateEngine.prototype.stop = function () {\n        if (this.initializationStatus === 3 /* Started */) {\n            this.mergeAndSave();\n            // Clear our Survey list, and push that through to the listener\n            this.setPendingSurveys(null);\n            this.updateActivityListenerWithCurrentSurveyDefinitions();\n        }\n        this.setInitializationStatus(4 /* Stopped */);\n    };\n    /**\n     * Gets the IActivityListener logging interface for callers that want to log directly rather than through telemetry\n     */\n    FloodgateEngine.prototype.getActivityListener = function () {\n        return this.activityListener;\n    };\n    FloodgateEngine.prototype.setInitializationStatus = function (status) {\n        this.initializationStatus = status;\n    };\n    FloodgateEngine.prototype.saveSettings = function () {\n        this.storage.fileLock(floodgate_shared_typings_1.FloodgateStorageProviderFileType.FloodgateSettings);\n        try {\n            this.writeString(floodgate_shared_typings_1.FloodgateStorageProviderFileType.FloodgateSettings, FloodgateSettings_1.FloodgateSettings.toJson(this.floodgateSettings));\n        }\n        finally {\n            this.storage.fileUnlock(floodgate_shared_typings_1.FloodgateStorageProviderFileType.FloodgateSettings);\n        }\n    };\n    FloodgateEngine.prototype.loadSettingsAndPriorEventCounts = function () {\n        try {\n            // Load up the prior survey history and prior event counts\n            this.previousSurveyActivationStats = this.surveyActivationStatsProvider.load();\n            this.previousSurveyEventActivityStats =\n                SurveyStatCollectionEventActivity_1.SurveyStatCollectionEventActivity.fromJson(this.readString(floodgate_shared_typings_1.FloodgateStorageProviderFileType.SurveyEventActivityStats));\n            // get the list of survey Id - all the survey should have event sent already\n            var stats = this.previousSurveyEventActivityStats.getStats();\n            for (var key in stats) {\n                if (Object.prototype.hasOwnProperty.call(stats, key)) {\n                    this.surveyEventSent.push(key);\n                }\n            }\n            // Load up the general floodgateSettings\n            this.floodgateSettings = FloodgateSettings_1.FloodgateSettings.fromJson(this.readString(floodgate_shared_typings_1.FloodgateStorageProviderFileType.FloodgateSettings));\n        }\n        catch (e) {\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.Common.Error, { ErrorMessage: "Error loading prior settings/events " + (e && e.toString()) });\n        }\n    };\n    FloodgateEngine.prototype.setPendingSurveysAndStartFloodgate = function () {\n        // Update our survey list, and push that through to the listener\n        this.setPendingSurveys(this.surveyClient.getAppSurveys());\n        this.updateActivityListenerWithCurrentSurveyDefinitions();\n        // Mark us as started\n        this.setInitializationStatus(3 /* Started */);\n        // Log our first start (aka floodgate boot) event\n        if (!this.loggedFirstStart) {\n            this.loggedFirstStart = true;\n            this.getActivityListener().logActivity(SurveyActivityListener_1.default.FloodgateStartActivityName);\n        }\n    };\n    FloodgateEngine.prototype.updateSurveyActivationStats = function (survey) {\n        var surveyInfo = survey.getSurveyInfo();\n        var surveyId = surveyInfo.getId();\n        var stats = this.previousSurveyActivationStats.getStats()[surveyId] || new SurveyStatCollectionActivation_1.SurveyActivationStats();\n        stats.Type = survey.getType();\n        stats.ExpirationTimeUtc = surveyInfo.getExpirationTimeUtc();\n        stats.ActivationTimeUtc = new Date();\n        stats.SurveyLaunchCount++;\n        this.previousSurveyActivationStats.addStats(surveyId, stats);\n        // Save the SurveyLaunchCountPerSession into global memory but not local storage\n        // so it won\'t be overwritten in local storage by another app instance\n        if (!Object.prototype.hasOwnProperty.call(globalSessionSurveyActivationCounts, surveyId)) {\n            globalSessionSurveyActivationCounts[surveyId] = 0;\n        }\n        globalSessionSurveyActivationCounts[surveyId]++;\n    };\n    FloodgateEngine.prototype.saveSurveyActivationHistory = function () {\n        this.storage.fileLock(floodgate_shared_typings_1.FloodgateStorageProviderFileType.SurveyActivationStats);\n        try {\n            var statCollection = this.surveyActivationStatsProvider.load();\n            var previousStats = this.previousSurveyActivationStats.getStats();\n            // Build the update collection\n            var updateCollection = new SurveyStatCollectionActivation_1.SurveyStatCollectionActivation();\n            for (var key in this.launchedSurveys) {\n                if (Object.prototype.hasOwnProperty.call(this.launchedSurveys, key)) {\n                    var survey = this.launchedSurveys[key];\n                    var surveyId = survey.getSurveyInfo().getId();\n                    // Make this part of the update list\n                    var stats = previousStats[surveyId];\n                    updateCollection.addStats(surveyId, stats);\n                }\n            }\n            // Actually merge our updates into the full collection\n            statCollection.accumulate(updateCollection);\n            this.surveyActivationStatsProvider.save(statCollection);\n            // Make sure to keep our internal collection consistent with what we just wrote\n            this.previousSurveyActivationStats = statCollection;\n        }\n        finally {\n            this.storage.fileUnlock(floodgate_shared_typings_1.FloodgateStorageProviderFileType.SurveyActivationStats);\n        }\n    };\n    FloodgateEngine.prototype.saveSurveyEventActivityHistory = function () {\n        this.storage.fileLock(floodgate_shared_typings_1.FloodgateStorageProviderFileType.SurveyEventActivityStats);\n        try {\n            var statCollection = SurveyStatCollectionEventActivity_1.SurveyStatCollectionEventActivity.fromJson(this.readString(floodgate_shared_typings_1.FloodgateStorageProviderFileType.SurveyEventActivityStats));\n            var now = new Date();\n            // Fill out our list of updates\n            var updateCollection = new SurveyStatCollectionEventActivity_1.SurveyStatCollectionEventActivity();\n            var _loop_1 = function (key) {\n                if (Object.prototype.hasOwnProperty.call(this_1.candidateSurveys, key)) {\n                    var stats = new SurveyStatCollectionEventActivity_1.SurveyEventActivityStats();\n                    var survey = this_1.candidateSurveys[key];\n                    if (!survey.getSurveyInfo().isActiveForDate(now)) {\n                        return "continue";\n                    }\n                    stats.ExpirationTimeUtc = survey.getSurveyInfo().getExpirationTimeUtc();\n                    // Get the activities which are aggregated, if there aren\'t any continue\n                    var allActivities = survey.getSurveyInfo().getActivationEvent().getTrackingSet();\n                    var aggregateActivities_1 = [];\n                    var nonAggregateActivities_2 = [];\n                    allActivities.getList().forEach(function (data) {\n                        if (data) {\n                            if (data.getIsAggregate()) {\n                                aggregateActivities_1.push(data.getActivity());\n                            }\n                            else {\n                                nonAggregateActivities_2.push(data.getActivity());\n                            }\n                        }\n                    });\n                    stats.Counts = new Array(aggregateActivities_1.length);\n                    // Save off the counts we\'ve added for this session\n                    for (var i = 0; i < aggregateActivities_1.length; i++) {\n                        stats.Counts[i] = this_1.activityListener.moveSessionCountIntoBaseCount(aggregateActivities_1[i], survey.getSurveyInfo().getId());\n                    }\n                    for (var _i = 0, nonAggregateActivities_1 = nonAggregateActivities_2; _i < nonAggregateActivities_1.length; _i++) {\n                        var activity = nonAggregateActivities_1[_i];\n                        this_1.activityListener.saveSessionTrackingActivity(activity);\n                    }\n                    // Make this part of the update list\n                    updateCollection.addStats(survey.getSurveyInfo().getId(), stats);\n                }\n            };\n            var this_1 = this;\n            for (var key in this.candidateSurveys) {\n                _loop_1(key);\n            }\n            // Actually merge our updates into the full collection\n            statCollection.accumulate(updateCollection);\n            this.writeString(floodgate_shared_typings_1.FloodgateStorageProviderFileType.SurveyEventActivityStats, SurveyStatCollectionEventActivity_1.SurveyStatCollectionEventActivity.toJson(statCollection));\n            // Make sure to keep our internal collection consistent with what we just wrote\n            this.previousSurveyEventActivityStats = statCollection;\n        }\n        finally {\n            this.storage.fileUnlock(floodgate_shared_typings_1.FloodgateStorageProviderFileType.SurveyEventActivityStats);\n        }\n    };\n    FloodgateEngine.prototype.setPendingSurveys = function (pendingSurveys) {\n        this.candidateSurveys = {};\n        if (pendingSurveys) {\n            var rejectCampaigns = [];\n            var acceptCampaigns = [];\n            for (var key in pendingSurveys) {\n                if (Object.prototype.hasOwnProperty.call(pendingSurveys, key)) {\n                    var survey = pendingSurveys[key];\n                    var payload = {\n                        CampaignId: survey.getCampaignId(),\n                        SurveyId: key\n                    };\n                    if (this.launcherFactory.AcceptsSurvey(survey)) {\n                        this.candidateSurveys[key] = survey;\n                        acceptCampaigns.push(payload);\n                    }\n                    else {\n                        rejectCampaigns.push(payload);\n                    }\n                }\n            }\n            // Default sampling rate: 0% - it\'s turned off by default. We will enable it from the Host app side if needed.\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.Common.ActiveSurveys, { Message: JSON.stringify({\n                    RejectCampaigns: rejectCampaigns,\n                    CandidateCampaigns: acceptCampaigns,\n                    PreviousCandidateSurveyIds: this.surveyEventSent\n                })\n            }, 0);\n        }\n    };\n    FloodgateEngine.prototype.getCurrentSurveyDefinitions = function () {\n        var _this = this;\n        // Get a vector of Surveys from our id-based map\n        var surveyList = new Array();\n        var allCampaignDefinitionIDs = this.getAllCampaignDefinitionIDs();\n        var allCandidateCampaignDefinitionIDs = this.getAllCandidateCampaignDefinitionIDs();\n        // Get all the campaign definitions. We need info from these for telemetry.\n        var allCampaignDefinitions = this.surveyClient.getCampaignDefinitions();\n        var isSurveyAllowed = function (surveyInfo) {\n            // always allow business critical and approved campaigns\n            if (GovernanceUtils_1.isBusinessCriticalSurvey(surveyInfo)) {\n                return true;\n            }\n            var surveyActivationStats = _this.previousSurveyActivationStats.getBySurveyId(surveyInfo.getId());\n            if (GovernanceUtils_1.isMultiLaunchSurvey(surveyInfo) &&\n                !GovernanceUtils_1.hasSurveyReachedMaxLaunches(surveyInfo, surveyActivationStats) &&\n                !GovernanceUtils_1.hasSurveyReachedMaxLaunchesPerSession(surveyInfo, globalSessionSurveyActivationCounts)) {\n                return true;\n            }\n            // Skip over any candidate surveys that have been previously completed or not active anymore\n            if (surveyActivationStats || !surveyInfo.isActiveForDate(new Date())) {\n                return false;\n            }\n            return true;\n        };\n        for (var key in this.candidateSurveys) {\n            if (Object.prototype.hasOwnProperty.call(this.candidateSurveys, key)) {\n                var survey = this.candidateSurveys[key];\n                var surveyInfo = survey.getSurveyInfo();\n                var campaignDefinition = allCampaignDefinitions[surveyInfo === null || surveyInfo === void 0 ? void 0 : surveyInfo.getBackEndId()];\n                if (!campaignDefinition || !isSurveyAllowed(surveyInfo)) {\n                    continue;\n                }\n                // send the UserSelected event if it is not sent before\n                if (this.surveyEventSent.indexOf(key) < 0) {\n                    this.surveyEventSent.push(key);\n                    var additionalSurveyInfo = this.getAdditionalSurveyInfoForTelemetry(survey, null /* contextInfo */, allCampaignDefinitionIDs, allCandidateCampaignDefinitionIDs);\n                    TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_UserSelected(surveyInfo.getBackEndId(), surveyInfo.getId(), survey.getType(), JSON.stringify(additionalSurveyInfo), surveyInfo.getTreatmentType());\n                }\n                surveyList.push(survey);\n            }\n        }\n        return surveyList;\n    };\n    FloodgateEngine.prototype.getAdditionalSurveyInfoForTelemetry = function (survey, contextInfo, allCampaignDefinitionIDs, allCandidateCampaignDefinitionIDs) {\n        // Get all the campaign definitions. We need info from these for telemetry.\n        var allCampaignDefinitions = this.surveyClient.getCampaignDefinitions();\n        // Get the corresponding campaign definition to the survey in question.\n        var correspondingCampaignDefinition = allCampaignDefinitions[survey.getCampaignId()];\n        // Survey properties to get from its corresponding CampaignDefinition:\n        var nominationPeriodNumber;\n        var cooldownPeriodNumber;\n        var percentageNumerator = correspondingCampaignDefinition.nominationScheme.percentageNumerator;\n        var percentageDenominator = correspondingCampaignDefinition.nominationScheme.percentageDenominator;\n        nominationPeriodNumber = correspondingCampaignDefinition.nominationScheme.nominationPeriod.asTimeIntervalSeconds();\n        nominationPeriodNumber = Utils_1.isNOU(nominationPeriodNumber) ? -1 : nominationPeriodNumber; // Setting to -1 if null or undefined\n        cooldownPeriodNumber = correspondingCampaignDefinition.nominationScheme.cooldownPeriod.asTimeIntervalSeconds();\n        cooldownPeriodNumber = Utils_1.isNOU(cooldownPeriodNumber) ? -1 : cooldownPeriodNumber; // Setting to -1 if null or undefined\n        var surveyInfo = survey.getSurveyInfo();\n        return {\n            allCampaignDefinitionIDs: allCampaignDefinitionIDs,\n            allCandidateCampaignDefinitionIDs: allCandidateCampaignDefinitionIDs,\n            channelType: surveyInfo.getGovernedChannelType(),\n            contextCount: contextInfo ? contextInfo.length : undefined,\n            cooldownPeriodNumber: cooldownPeriodNumber,\n            nominationPeriodNumber: nominationPeriodNumber,\n            percentageDenominator: percentageDenominator,\n            percentageNumerator: percentageNumerator,\n            surveyLauncherType: survey.getLauncherType(),\n            businessLevel: surveyInfo.getBusinessLevel(),\n            maxLaunches: surveyInfo.getMaxLaunches(),\n            maxLaunchesPerSession: surveyInfo.getMaxLaunchesPerSession(),\n            isContentValid: survey.isContentValid(),\n            isUxSchemaPresent: !Utils_1.isNOU(survey.getUxSchema())\n        };\n    };\n    FloodgateEngine.prototype.getAllCandidateCampaignDefinitionIDs = function () {\n        var allCandidateCampaignDefinitionIDs = [];\n        // Get all the candidate surveys\' campaign definition IDs\n        for (var key in this.candidateSurveys) {\n            if (Object.prototype.hasOwnProperty.call(this.candidateSurveys, key)) {\n                var candidateSurvey = this.candidateSurveys[key];\n                allCandidateCampaignDefinitionIDs.push(candidateSurvey.getSurveyInfo().getBackEndId());\n            }\n        }\n        return allCandidateCampaignDefinitionIDs;\n    };\n    FloodgateEngine.prototype.getAllCampaignDefinitionIDs = function () {\n        var allCampaignDefinitions = this.surveyClient.getCampaignDefinitions();\n        var allCampaignDefinitionIDs = [];\n        for (var definitionsKey in allCampaignDefinitions) {\n            if (Object.prototype.hasOwnProperty.call(allCampaignDefinitions, definitionsKey)) {\n                var definition = allCampaignDefinitions[definitionsKey];\n                allCampaignDefinitionIDs.push(definition.campaignId);\n            }\n        }\n        return allCampaignDefinitionIDs;\n    };\n    FloodgateEngine.prototype.updateActivityListenerWithCurrentSurveyDefinitions = function () {\n        var surveyList = this.getCurrentSurveyDefinitions();\n        var trackingContractList = [];\n        for (var _i = 0, surveyList_1 = surveyList; _i < surveyList_1.length; _i++) {\n            var survey = surveyList_1[_i];\n            var surveyInfo = survey.getSurveyInfo();\n            var trackingContract = new ActivityTrackingContract_1.ActivityTrackingContract(surveyInfo.getId(), surveyInfo.getActivationEvent().getTrackingSet());\n            trackingContractList.push(trackingContract);\n        }\n        this.activityListener.SetActivityTrackingContracts(trackingContractList, this.previousSurveyEventActivityStats);\n    };\n    FloodgateEngine.prototype.setCriticalPendingSurveysAndUpdateActivityListener = function () {\n        var activeSurveys = {};\n        // Get all the candidate surveys\' campaign definition IDs\n        for (var key in this.candidateSurveys) {\n            if (Object.prototype.hasOwnProperty.call(this.candidateSurveys, key)) {\n                var candidateSurvey = this.candidateSurveys[key];\n                if (GovernanceUtils_1.isCriticalSurvey(candidateSurvey.getSurveyInfo())) {\n                    activeSurveys[key] = candidateSurvey;\n                }\n            }\n        }\n        if (Object.keys(activeSurveys).length > 0) {\n            this.setPendingSurveys(activeSurveys);\n            this.updateActivityListenerWithCurrentSurveyDefinitions();\n        }\n    };\n    FloodgateEngine.prototype.shouldAcceptActivity = function (activityName) {\n        return this.initializationStatus === 3 /* Started */ ||\n            activityName === SurveyActivityListener_1.default.FloodgateStartActivityName;\n    };\n    FloodgateEngine.prototype.onSurveyActivated = function (surveyId, contextInfo) {\n        var _a, _b;\n        // Find the survey object that corresponds to the surveyId passed\n        var surveys = this.getCurrentSurveyDefinitions();\n        var survey;\n        for (var _i = 0, surveys_1 = surveys; _i < surveys_1.length; _i++) {\n            var tempSurvey = surveys_1[_i];\n            if (tempSurvey.getSurveyInfo().getId() === surveyId) {\n                survey = tempSurvey;\n                break;\n            }\n        }\n        if (Utils_1.isNOU(survey)) {\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Error(Constants_1.TelemetryEvent.FloodgateEngine.OnSurveyActivated.SurveyNotDefined, "Survey is not defined in the current survey definitions.");\n            return;\n        }\n        try {\n            // this log will trigger when the user has first met the trigger action required to initially trigger the campaign.\n            // this log occurs prior to the post governance checks which determines if the trigger is actually met and we can launch \n            // the surface\n            // Default sampling rate: 10%\n            var initialTriggerSamplingRate = (_b = (_a = this.campaignTelemetrySamplingConfig) === null || _a === void 0 ? void 0 : _a.initialTriggerMetSamplingRate) !== null && _b !== void 0 ? _b : 0.1;\n            if (initialTriggerSamplingRate > 0) {\n                TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.CampaignInitialTriggerMet, { CampaignId: survey.getCampaignId(), Message: "Sampling Rate: " + initialTriggerSamplingRate }, initialTriggerSamplingRate);\n            }\n            var governedChannelType = survey.getSurveyInfo().getGovernedChannelType();\n            // If the governance service is in use, launch survey asynchronously\n            if (this.orchestrationEngine.isChannelGovernanceEnabled(governedChannelType) ||\n                (this.floodgateEngineConfig.uiStringsCdnEnabled && FloodgateSurveyCdnClient_1.isTranslationRequired(survey, this.floodgateEngineConfig.locale))) {\n                // record the stale surveys, so we can clear its tracker if Engine is stopped\n                this.staleTriggeredSurveysQueue.push({\n                    survey: survey,\n                    contextInfo: contextInfo\n                });\n                // If there is no survey in stale before, launch the survey right away\n                if (this.staleTriggeredSurveysQueue.length === 1) {\n                    // Launch the survey asynchronously\n                    this.checkTriggerMetApisAndActivateSurvey(survey, contextInfo);\n                }\n            }\n            else {\n                this.activateSurvey(survey, contextInfo);\n            }\n        }\n        catch (e) {\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.OnSurveyActivated.Error, { ErrorMessage: "Error activating survey " + (e && e.toString()), ErrorDetails: e && e.stack });\n        }\n    };\n    FloodgateEngine.prototype.activateSurvey = function (survey, contextInfo) {\n        var launchSurvey = false;\n        var governedChannelType = survey.getSurveyInfo().getGovernedChannelType();\n        // Figure out if the activated survey is still relevant\n        if (!this.candidateSurveys[survey.getSurveyInfo().getId()]) {\n            // Survey is no longer relevant but was activated. Suppress it.\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.OnSurveyActivated.ActivationIrrelevantSurvey, {\n                CampaignId: survey.getSurveyInfo().getBackEndId(),\n                SurveyId: survey.getSurveyInfo().getId(),\n            });\n        }\n        else if (!survey.getSurveyInfo().isActiveForDate(new Date())) {\n            // Survey is no longer active (e.g. it was when we registered it but it has now expired)\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.OnSurveyActivated.ActivationExpiredSurvey, {\n                CampaignId: survey.getSurveyInfo().getBackEndId(),\n                SurveyId: survey.getSurveyInfo().getId(),\n            });\n        }\n        else {\n            if (GovernanceUtils_1.isCriticalSurvey(survey.getSurveyInfo())) {\n                launchSurvey = true;\n            }\n            else if (!this.orchestrationEngine.isChannelOpen(governedChannelType)) {\n                // Channel has closed and maxLaunches is not set, suppress the survey\n                TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.OnSurveyActivated.ClosedChannelType, { ClosedChannelType: floodgate_shared_typings_1.GovernedChannelType[governedChannelType] });\n            }\n            else {\n                // Get latest survey states from provider\n                var refreshedSurveyActivationStats = this.surveyActivationStatsProvider.load();\n                if (refreshedSurveyActivationStats.getBySurveyId(survey.getSurveyInfo().getId())) {\n                    // Survey stats exists already, don\'t launch\n                    TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.OnSurveyActivated.ActivationStatsSuppressedSurvey, {\n                        CampaignId: survey.getSurveyInfo().getBackEndId(),\n                        SurveyId: survey.getSurveyInfo().getId(),\n                    });\n                }\n                else if (Object.keys(this.launchedSurveys).length === 0) {\n                    // for now we only support launching one survey per session unless it is multi-launch campaign\n                    // Track this survey activation for the launch history tracker\n                    launchSurvey = true;\n                }\n                else {\n                    var triggeredSurvey = Object.values(this.launchedSurveys)[0];\n                    if (!Utils_1.isNOU(triggeredSurvey)) {\n                        TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.OnSurveyActivated.SessionSuppressedSurvey, {\n                            CampaignId: triggeredSurvey.getSurveyInfo().getBackEndId(),\n                            SurveyId: triggeredSurvey.getSurveyInfo().getId(),\n                        });\n                    }\n                }\n            }\n            if (launchSurvey) {\n                this.launchedSurveys[survey.getSurveyInfo().getId()] = survey;\n            }\n        }\n        // At this point, regardless of whether or not the survey is still relevant, we should flush out the stats\n        this.updateSurveyActivationStats(survey);\n        this.mergeAndSave();\n        // shut off further survey launches\n        this.activityListener.clearSurveys();\n        // Clear the survey from stale list\n        this.staleTriggeredSurveysQueue = [];\n        // Actually launch the survey if possible\n        if (launchSurvey) {\n            // Get the stringified json with activity names, counts and isAggregate info for TriggetMet telemetry.\n            var activityTrackingString = survey.getSurveyInfo().getActivationEvent().getTrackingSet()\n                .getActivityTrackingInfo(this.activityListener, survey.getSurveyInfo().getId());\n            var additionalSurveyInfo = this.getAdditionalSurveyInfoForTelemetry(survey, contextInfo, this.getAllCampaignDefinitionIDs(), this.getAllCandidateCampaignDefinitionIDs());\n            // Only adding the governance service client state at TriggerMet event\n            additionalSurveyInfo.governanceServiceClientState = this.orchestrationEngine.getStateForTelemetry();\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_TriggerMet(survey.getSurveyInfo().getBackEndId(), survey.getSurveyInfo().getId(), survey.getType(), activityTrackingString, JSON.stringify(additionalSurveyInfo), survey.getSurveyInfo().getTreatmentType());\n            // Set govern channel\n            this.orchestrationEngine.startChannelCooldown(governedChannelType);\n            var surveyInfo = survey.getSurveyInfo();\n            var isSurveyComplete = true;\n            if (GovernanceUtils_1.isBusinessCriticalSurvey(surveyInfo)) {\n                // critical campaigns are not tracked\n                isSurveyComplete = false;\n            }\n            else if (GovernanceUtils_1.isMultiLaunchSurvey(surveyInfo)) {\n                var surveyActivationStats = this.previousSurveyActivationStats.getBySurveyId(surveyInfo.getId());\n                isSurveyComplete = GovernanceUtils_1.hasSurveyReachedMaxLaunches(surveyInfo, surveyActivationStats);\n            }\n            // Set campaign states\n            this.surveyClient.onSurveyActivated(surveyInfo, isSurveyComplete);\n            // Show the survey\n            this.launchLauncher(survey, contextInfo);\n            // check if there are any critical campaigns and start tracking again\n            this.setCriticalPendingSurveysAndUpdateActivityListener();\n        }\n    };\n    FloodgateEngine.prototype.checkTriggerMetApisAndActivateSurvey = function (survey, contextInfo) {\n        var _a, _b;\n        return __awaiter(this, void 0, void 0, function () {\n            var campaignDefinition, surveyLevelCooldown, governedChannelType, serviceResult, governanceDecision, e_1, launchSurvey, governanceResponseTelemetry, nextSurvey, nextContextInfo;\n            return __generator(this, function (_c) {\n                switch (_c.label) {\n                    case 0:\n                        campaignDefinition = this.surveyClient.getCampaignDefinitions()[survey.getCampaignId()];\n                        surveyLevelCooldown = campaignDefinition.nominationScheme.cooldownPeriod.asTimeIntervalSeconds();\n                        governedChannelType = survey.getSurveyInfo().getGovernedChannelType();\n                        _c.label = 1;\n                    case 1:\n                        _c.trys.push([1, 3, , 4]);\n                        return [4 /*yield*/, this.queryTriggerMetApisAsync(survey, surveyLevelCooldown, governedChannelType)];\n                    case 2:\n                        governanceDecision = _c.sent();\n                        serviceResult = governanceDecision.serviceResult;\n                        return [3 /*break*/, 4];\n                    case 3:\n                        e_1 = _c.sent();\n                        TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.QueryTriggerMetApisAsync.Exception, { ErrorMessage: e_1 && e_1.toString(), ErrorDetails: e_1 && e_1.stack });\n                        // failure in case of exception\n                        serviceResult = {\n                            permission: false\n                        };\n                        return [3 /*break*/, 4];\n                    case 4:\n                        launchSurvey = false;\n                        governanceResponseTelemetry = JSON.stringify(this.createGorvernanceResponseTelemetry(serviceResult, survey.getCampaignId()));\n                        TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.CheckGovernanceServiceAndActivateSurvey.GovernanceServiceClientCompleted, {\n                            Message: governanceResponseTelemetry,\n                        });\n                        // Check if engine is still running\n                        if (this.initializationStatus !== 3 /* Started */) {\n                            return [2 /*return*/];\n                        }\n                        if (!serviceResult.error) {\n                            // Check result is permitted\n                            if (serviceResult.permission) { // the Governance Service is permitting, continue to trigger\n                                launchSurvey = true;\n                            }\n                            else {\n                                if (((_a = serviceResult.lastTriggerSurvey) === null || _a === void 0 ? void 0 : _a.timeUntilNextCampaignAllowed) > 0) {\n                                    // Set governed channel to new cooldown\n                                    this.orchestrationEngine.startChannelCooldown(governedChannelType, serviceResult.lastTriggerSurvey.lastTriggerCampaignTime);\n                                    // Clear the survey relating to channel\n                                    this.clearSurveyWithChannel(governedChannelType);\n                                }\n                                if (serviceResult.isSurveyGoverned &&\n                                    ((_b = serviceResult.lastTriggerSurvey) === null || _b === void 0 ? void 0 : _b.timeUntilSameCampaignAllowed) > 0) {\n                                    // Log the event\n                                    TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.CheckGovernanceServiceAndActivateSurvey.GovernanceServiceSurveyInCooldown, {\n                                        Message: governanceResponseTelemetry,\n                                    });\n                                    this.putSurveyOnCooldown(survey, serviceResult);\n                                }\n                            }\n                        }\n                        else {\n                            // If force to display with error, continue to trigger the survey\n                            if (this.orchestrationEngine.shouldForcePermission()) {\n                                launchSurvey = true;\n                                // Log the force to display event\n                                TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.CheckGovernanceServiceAndActivateSurvey.GovernanceServiceForceToDisplay, {\n                                    ErrorMessage: serviceResult.errorMessage,\n                                });\n                            }\n                        }\n                        if (launchSurvey) {\n                            // Launch the survey\n                            this.activateSurvey(survey, contextInfo);\n                            return [2 /*return*/];\n                        }\n                        // If there is only one survey, which is the current one in process, clear queue and return\n                        if (this.staleTriggeredSurveysQueue.length <= 1) {\n                            this.staleTriggeredSurveysQueue = [];\n                            return [2 /*return*/];\n                        }\n                        // Remove the first activated survey from the list which is the current one in process\n                        this.staleTriggeredSurveysQueue.shift();\n                        nextSurvey = this.staleTriggeredSurveysQueue[0].survey;\n                        nextContextInfo = this.staleTriggeredSurveysQueue[0].contextInfo;\n                        // Playback the next activated survey in waiting\n                        this.checkTriggerMetApisAndActivateSurvey(nextSurvey, nextContextInfo);\n                        return [2 /*return*/];\n                }\n            });\n        });\n    };\n    FloodgateEngine.prototype.readString = function (fileType) {\n        return this.storage.read(fileType);\n    };\n    FloodgateEngine.prototype.writeString = function (fileType, str) {\n        this.storage.write(fileType, str);\n    };\n    FloodgateEngine.prototype.launchLauncher = function (survey, contextInfo) {\n        var launcher = this.launcherFactory.makeSurveyLauncher(survey);\n        if (launcher) {\n            this.launchedLaunchers.push(launcher);\n            this.onSurveyActivatedCallback.onSurveyActivated(launcher, survey, { contextInfo: contextInfo });\n        }\n    };\n    FloodgateEngine.prototype.clearSurveyWithChannel = function (governedChannelType) {\n        var activeSurveys = {};\n        // Get all the candidate surveys\' campaign definition IDs\n        for (var key in this.candidateSurveys) {\n            if (Object.prototype.hasOwnProperty.call(this.candidateSurveys, key)) {\n                var candidateSurvey = this.candidateSurveys[key];\n                if (candidateSurvey.getSurveyInfo().getGovernedChannelType() !== governedChannelType) {\n                    activeSurveys[key] = candidateSurvey;\n                }\n            }\n        }\n        this.candidateSurveys = activeSurveys;\n        this.activityListener.UpdateActivityTrackingContracts(this.candidateSurveys);\n    };\n    FloodgateEngine.prototype.createGorvernanceResponseTelemetry = function (serviceResult, campaignId) {\n        return {\n            CampaignId: campaignId,\n            FloodgateEngineStatus: this.initializationStatus.toString(),\n            GovernanceServiceResult: serviceResult,\n            StaleTriggeredSurveysQueueCount: this.staleTriggeredSurveysQueue.length - 1,\n        };\n    };\n    FloodgateEngine.prototype.putSurveyOnCooldown = function (survey, serviceResult) {\n        // Set the Survey on cooldown from the value returned from the service\n        this.surveyClient.modifyCampaignSurveyTakenDate(survey.getCampaignId(), serviceResult.lastTriggerSurvey.lastTriggerSameCampaignTime, true);\n    };\n    FloodgateEngine.prototype.queryTriggerMetApisAsync = function (survey, surveyLevelCooldown, channel) {\n        var _a;\n        return __awaiter(this, void 0, void 0, function () {\n            var isLoadingSurveyCdnRequired, governanceParams, businessLevel, cdnSimpleRequestEnabled, floodgateSurveyCdnClient, loadCdnPromise, checkPermission, _b, cdnLoadResult, mopResult, cdnLoadResult;\n            return __generator(this, function (_c) {\n                switch (_c.label) {\n                    case 0:\n                        isLoadingSurveyCdnRequired = FloodgateSurveyCdnClient_1.isTranslationRequired(survey, this.floodgateEngineConfig.locale);\n                        TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.QueryTriggerMetApisAsync.QueryTriggerMetApisAsync, {\n                            Message: JSON.stringify({\n                                channel: channel,\n                                IsLoadingSurveyCdnRequired: isLoadingSurveyCdnRequired,\n                                GovServiceEnabled: this.orchestrationEngine.isChannelGovernanceEnabled(channel),\n                                FloodgateSurveyCdnClientEnabled: this.floodgateEngineConfig.uiStringsCdnEnabled\n                            }),\n                        });\n                        governanceParams = {\n                            campaignId: survey.getCampaignId(),\n                            surveyId: survey.getSurveyInfo().getId(),\n                            surveyType: survey.getType(),\n                            channelType: channel,\n                            launcherType: survey.getLauncherType(),\n                            maxLaunches: survey.getSurveyInfo().getMaxLaunches(),\n                            campaignCooldown: surveyLevelCooldown,\n                            userCooldown: -1,\n                            personalizerEnabled: false\n                        };\n                        businessLevel = survey.getSurveyInfo().getBusinessLevel();\n                        if (!(isLoadingSurveyCdnRequired && this.floodgateEngineConfig.uiStringsCdnEnabled)) return [3 /*break*/, 6];\n                        cdnSimpleRequestEnabled = (_a = FeatureGateProvider_1.getFeatureGateProvider()) === null || _a === void 0 ? void 0 : _a.getBoolFeatureStatus("CdnSimpleRequestEnabled", false);\n                        floodgateSurveyCdnClient = new FloodgateSurveyCdnClient_1.default(this.floodgateEngineConfig.uiStringsLoadingTimeout, this.floodgateEngineConfig.uiStringCdnRetryLimit, cdnSimpleRequestEnabled);\n                        if (!this.floodgateEngineConfig.shouldFetchSurveyCdnConcurrently) return [3 /*break*/, 2];\n                        loadCdnPromise = floodgateSurveyCdnClient.loadCdnStringResource(survey, this.floodgateEngineConfig.locale);\n                        checkPermission = this.getGovernanceDecision(businessLevel, governanceParams);\n                        return [4 /*yield*/, Promise.all([loadCdnPromise, checkPermission])];\n                    case 1:\n                        _b = _c.sent(), cdnLoadResult = _b[0], mopResult = _b[1];\n                        // if SurveyCDN is failed, return false no need to check for MOP result\n                        if (!cdnLoadResult) {\n                            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.QueryTriggerMetApisAsync.SurveyCdnFailureConcurrently, {\n                                Message: JSON.stringify({\n                                    cdnLoadResult: cdnLoadResult,\n                                    mopResult: mopResult\n                                }),\n                            });\n                            return [2 /*return*/, {\n                                    governanceDecision: Api_1.GovernanceDecision.Rejected\n                                }];\n                        }\n                        return [2 /*return*/, mopResult];\n                    case 2: return [4 /*yield*/, floodgateSurveyCdnClient.loadCdnStringResource(survey, this.floodgateEngineConfig.locale)];\n                    case 3:\n                        cdnLoadResult = _c.sent();\n                        // if SurveyCDN is failed, return right away, no need to call MOP anymore\n                        if (!cdnLoadResult) {\n                            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateEngine.QueryTriggerMetApisAsync.SurveyCdnFailureSequentially, {\n                                Message: JSON.stringify({\n                                    cdnLoadResult: cdnLoadResult\n                                }),\n                            });\n                            return [2 /*return*/, {\n                                    governanceDecision: Api_1.GovernanceDecision.Rejected\n                                }];\n                        }\n                        return [4 /*yield*/, this.getGovernanceDecision(businessLevel, governanceParams)];\n                    case 4: return [2 /*return*/, _c.sent()];\n                    case 5: return [3 /*break*/, 7];\n                    case 6: \n                    // Current behavior\n                    return [2 /*return*/, this.getGovernanceDecision(businessLevel, governanceParams)];\n                    case 7: return [2 /*return*/];\n                }\n            });\n        });\n    };\n    FloodgateEngine.prototype.getGovernanceDecision = function (businessLevel, governanceParams) {\n        return __awaiter(this, void 0, void 0, function () {\n            var isEnabled, governanceDecision;\n            return __generator(this, function (_a) {\n                switch (_a.label) {\n                    case 0:\n                        if (this.personalizerClient) {\n                            isEnabled = this.personalizerClient.isEnabled(governanceParams.surveyType, governanceParams.launcherType, governanceParams.channelType);\n                            governanceParams.personalizerEnabled = isEnabled;\n                        }\n                        return [4 /*yield*/, this.orchestrationEngine.getDecision(businessLevel, governanceParams)];\n                    case 1:\n                        governanceDecision = _a.sent();\n                        if (governanceDecision && this.personalizerClient) {\n                            this.personalizerClient.onGovernanceServiceResult(governanceParams, governanceDecision.serviceResult);\n                        }\n                        return [2 /*return*/, governanceDecision];\n                }\n            });\n        });\n    };\n    return FloodgateEngine;\n}());\nexports.FloodgateEngine = FloodgateEngine;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/FloodgateEngine.js\n')},"../FloodgateCore/dist/src/FloodgateSettings.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.FloodgateSettings = void 0;\n/**\n * General floodgate settings\n */\nvar FloodgateSettings = /** @class */ (function () {\n    function FloodgateSettings() {\n    }\n    /**\n     * Convert to Json\n     */\n    FloodgateSettings.toJson = function (object) {\n        return JSON.stringify(object);\n    };\n    /**\n     * Load from Json\n     */\n    FloodgateSettings.fromJson = function (json) {\n        return JSON.parse(json);\n    };\n    return FloodgateSettings;\n}());\nexports.FloodgateSettings = FloodgateSettings;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vc3JjL0Zsb29kZ2F0ZVNldHRpbmdzLnRzPzRmMjUiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUE7O0dBRUc7QUFDSDtJQUFBO0lBY0EsQ0FBQztJQWJBOztPQUVHO0lBQ1csd0JBQU0sR0FBcEIsVUFBcUIsTUFBeUI7UUFDN0MsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQy9CLENBQUM7SUFFRDs7T0FFRztJQUNXLDBCQUFRLEdBQXRCLFVBQXVCLElBQVk7UUFDbEMsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ3pCLENBQUM7SUFDRix3QkFBQztBQUFELENBQUM7QUFkWSw4Q0FBaUIiLCJmaWxlIjoiLi4vRmxvb2RnYXRlQ29yZS9kaXN0L3NyYy9GbG9vZGdhdGVTZXR0aW5ncy5qcy5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxyXG4gKiBHZW5lcmFsIGZsb29kZ2F0ZSBzZXR0aW5nc1xyXG4gKi9cclxuZXhwb3J0IGNsYXNzIEZsb29kZ2F0ZVNldHRpbmdzIHtcclxuXHQvKipcclxuXHQgKiBDb252ZXJ0IHRvIEpzb25cclxuXHQgKi9cclxuXHRwdWJsaWMgc3RhdGljIHRvSnNvbihvYmplY3Q6IEZsb29kZ2F0ZVNldHRpbmdzKTogc3RyaW5nIHtcclxuXHRcdHJldHVybiBKU09OLnN0cmluZ2lmeShvYmplY3QpO1xyXG5cdH1cclxuXHJcblx0LyoqXHJcblx0ICogTG9hZCBmcm9tIEpzb25cclxuXHQgKi9cclxuXHRwdWJsaWMgc3RhdGljIGZyb21Kc29uKGpzb246IHN0cmluZyk6IEZsb29kZ2F0ZVNldHRpbmdzIHtcclxuXHRcdHJldHVybiBKU09OLnBhcnNlKGpzb24pO1xyXG5cdH1cclxufVxyXG4iXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/FloodgateSettings.js\n')},"../FloodgateCore/dist/src/FloodgateSurveyCdn/FloodgateSurveyCdnClient.js":function(module,exports,__webpack_require__){"use strict";eval('\n/**\n * Implementation of IFloodgateStringProvider for Web SDK\n */\nvar __assign = (this && this.__assign) || function () {\n    __assign = Object.assign || function(t) {\n        for (var s, i = 1, n = arguments.length; i < n; i++) {\n            s = arguments[i];\n            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))\n                t[p] = s[p];\n        }\n        return t;\n    };\n    return __assign.apply(this, arguments);\n};\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nvar __generator = (this && this.__generator) || function (thisArg, body) {\n    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;\n    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;\n    function verb(n) { return function (v) { return step([n, v]); }; }\n    function step(op) {\n        if (f) throw new TypeError("Generator is already executing.");\n        while (_) try {\n            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;\n            if (y = 0, t) op = [op[0] & 2, t.value];\n            switch (op[0]) {\n                case 0: case 1: t = op; break;\n                case 4: _.label++; return { value: op[1], done: false };\n                case 5: _.label++; y = op[1]; op = [0]; continue;\n                case 7: op = _.ops.pop(); _.trys.pop(); continue;\n                default:\n                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }\n                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }\n                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }\n                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }\n                    if (t[2]) _.ops.pop();\n                    _.trys.pop(); continue;\n            }\n            op = body.call(thisArg, _);\n        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }\n        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };\n    }\n};\nvar __spreadArrays = (this && this.__spreadArrays) || function () {\n    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;\n    for (var r = Array(s), k = 0, i = 0; i < il; i++)\n        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)\n            r[k] = a[j];\n    return r;\n};\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.isTranslationRequired = void 0;\nvar floodgate_shared_typings_1 = __webpack_require__(/*! @ms-ofb/floodgate-shared-typings */ "../FloodgateCore/node_modules/@ms-ofb/floodgate-shared-typings/dist/index.js");\nvar Utils_1 = __webpack_require__(/*! ../Utils */ "../FloodgateCore/dist/src/Utils.js");\nvar HttpTransport_1 = __webpack_require__(/*! ../Transport/HttpTransport */ "../FloodgateCore/dist/src/Transport/HttpTransport.js");\nvar Constants_1 = __webpack_require__(/*! ../Constants */ "../FloodgateCore/dist/src/Constants.js");\nvar TelemetryLogger_1 = __webpack_require__(/*! ../TelemetryLogger */ "../FloodgateCore/dist/src/TelemetryLogger.js");\nfunction isTranslationRequired(survey, locale) {\n    var _a;\n    var currentLocale = (locale === null || locale === void 0 ? void 0 : locale.toLowerCase()) || \'en-us\';\n    return ((_a = survey.getUxSchema()) === null || _a === void 0 ? void 0 : _a.uiStringsUrl) &&\n        (currentLocale != \'en-us\' && currentLocale != \'en\');\n}\nexports.isTranslationRequired = isTranslationRequired;\n/**\n * This class is the client to query the CDN from the given survey UxSchema if required\n * The survey UxSchema will be translated into the given locale\n */\nvar FloodgateSurveyCdnClient = /** @class */ (function () {\n    function FloodgateSurveyCdnClient(uiStringsLoadingTimeout, retryLimit, simpleRequestEnabled) {\n        if (simpleRequestEnabled === void 0) { simpleRequestEnabled = false; }\n        this.timeout = uiStringsLoadingTimeout;\n        this.retryLimit = retryLimit;\n        this.simpleRequestEnabled = simpleRequestEnabled;\n    }\n    /**\n     * The function to translate the given survey UxSchema into the given locale\n     * If the CDN is failed or UxSchema is failed in translation, the UxSchema will be reset to null\n     * In case of failure, it can possible returns success if the legacy Content is valid.\n     * @returns true if success. Otherwise, false.\n     */\n    FloodgateSurveyCdnClient.prototype.loadCdnStringResource = function (survey, locale) {\n        return __awaiter(this, void 0, void 0, function () {\n            var requestUrl, httpTransport, success, response, serviceCallTime, timeBefore, responseText, jsonResponse, e_1;\n            return __generator(this, function (_a) {\n                switch (_a.label) {\n                    case 0:\n                        requestUrl = survey.getUxSchema().uiStringsUrl + locale + "/strings.json";\n                        httpTransport = new HttpTransport_1.HttpTransport();\n                        success = false;\n                        // Survey CDN is not enabled, assume it\'s good\n                        if (!isTranslationRequired(survey, locale)) {\n                            return [2 /*return*/, true];\n                        }\n                        _a.label = 1;\n                    case 1:\n                        _a.trys.push([1, 7, , 8]);\n                        timeBefore = performance.now();\n                        return [4 /*yield*/, httpTransport.getRequestWithRetry(requestUrl, this.retryLimit, this.timeout, this.simpleRequestEnabled)];\n                    case 2:\n                        response = _a.sent();\n                        serviceCallTime = performance.now() - timeBefore;\n                        if (!response.ok) return [3 /*break*/, 5];\n                        return [4 /*yield*/, response.text()];\n                    case 3:\n                        responseText = _a.sent();\n                        // Log the successful post criteria with time\n                        TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateSurveyCdnClient.loadCdnStringResource.Request_Success, {\n                            TimeMilliseconds: serviceCallTime,\n                            CampaignId: survey.getCampaignId(),\n                            SurveyId: survey.getSurveyInfo().getId(),\n                            Message: JSON.stringify({\n                                RequestUrl: requestUrl,\n                                HttpStatusCode: response.status,\n                                HttpStatusText: response.statusText,\n                                SimpleRequestEnabled: this.simpleRequestEnabled,\n                            }),\n                        });\n                        jsonResponse = JSON.parse(responseText);\n                        // Translating the UxSchema\n                        // This function should throw error if there is any issue\n                        return [4 /*yield*/, this.translateSurveyUxSchema(survey, jsonResponse)];\n                    case 4:\n                        // Translating the UxSchema\n                        // This function should throw error if there is any issue\n                        _a.sent();\n                        success = true;\n                        return [3 /*break*/, 6];\n                    case 5:\n                        // Log the error with response\n                        TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateSurveyCdnClient.loadCdnStringResource.Request_Failed, {\n                            TimeMilliseconds: serviceCallTime,\n                            CampaignId: survey.getCampaignId(),\n                            SurveyId: survey.getSurveyInfo().getId(),\n                            Message: JSON.stringify({\n                                RequestUrl: requestUrl,\n                                HttpStatusCode: response.status,\n                                HttpStatusText: response.statusText,\n                                SimpleRequestEnabled: this.simpleRequestEnabled,\n                            }),\n                        });\n                        _a.label = 6;\n                    case 6: return [3 /*break*/, 8];\n                    case 7:\n                        e_1 = _a.sent();\n                        TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateSurveyCdnClient.loadCdnStringResource.Exception, {\n                            ErrorMessage: e_1 && e_1.toString(),\n                            CampaignId: survey.getCampaignId(),\n                            SurveyId: survey.getSurveyInfo().getId(),\n                            Message: JSON.stringify({\n                                RequestUrl: requestUrl,\n                                HttpStatusCode: response === null || response === void 0 ? void 0 : response.status,\n                                HttpStatusText: response === null || response === void 0 ? void 0 : response.statusText,\n                                SimpleRequestEnabled: this.simpleRequestEnabled,\n                            }),\n                        });\n                        return [3 /*break*/, 8];\n                    case 8:\n                        // In case of failure, we allow fallback if there is valid Content\n                        if (!success) {\n                            // Set the UxSchema to null so we fallback to Content\n                            survey.setUxSchema(null);\n                            if (survey.isContentValid()) {\n                                success = true;\n                            }\n                        }\n                        TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FloodgateSurveyCdnClient.loadCdnStringResource.Completed, {\n                            CampaignId: survey.getCampaignId(),\n                            SurveyId: survey.getSurveyInfo().getId(),\n                            Message: JSON.stringify({\n                                Success: success,\n                                IsContentValid: survey.isContentValid(),\n                                IsUxSchemaPresent: !Utils_1.isNOU(survey.getUxSchema())\n                            }),\n                        });\n                        return [2 /*return*/, success];\n                }\n            });\n        });\n    };\n    /**\n     * This function translates the given uxSchema in the parameter\n     * This is destructive function since it will create a new translated UxSchema and set the new one to given survey.\n     * However, the original UxSchema won\'t be changed and stay the same with orginal strings.\n     * Important note: the original UxSchema is shallow copied from Campaign Definition, so any change to it will affect the original\n     * Campaign Definition as well. Therefore, we should not changing the UxSchema if not needed.\n     * If there is issue in translation, it will throw Error\n     * @param survey survey with UxSchema to be translated\n     * @param uiStringMap dictionary contains locale strings\n    */\n    FloodgateSurveyCdnClient.prototype.translateSurveyUxSchema = function (survey, uiStringMap) {\n        return __awaiter(this, void 0, void 0, function () {\n            var uxSchema, promiseList, errorList, translatedResult, _loop_1, this_1, index, translatedRules, indexRule, rule, translatedRule, _loop_2, this_2, index;\n            return __generator(this, function (_a) {\n                switch (_a.label) {\n                    case 0:\n                        uxSchema = survey.getUxSchema();\n                        promiseList = [];\n                        errorList = [];\n                        translatedResult = __assign({}, uxSchema);\n                        translatedResult.pages = __spreadArrays(uxSchema.pages);\n                        _loop_1 = function (index) {\n                            promiseList.push(this_1.translatePage(uiStringMap, uxSchema.pages[index], "page." + index, errorList)\n                                .then(function (result) {\n                                translatedResult.pages[index] = result;\n                            }));\n                        };\n                        this_1 = this;\n                        // translate the pages\n                        for (index = 0; index < uxSchema.pages.length; index++) {\n                            _loop_1(index);\n                        }\n                        // translate the branching rule if possible\n                        if (uxSchema.branchingRules && uxSchema.branchingRules.length > 0) {\n                            translatedRules = translatedResult.branchingRules = [];\n                            for (indexRule = 0; indexRule < uxSchema.branchingRules.length; indexRule++) {\n                                rule = uxSchema.branchingRules[indexRule];\n                                translatedRule = {\n                                    conditions: rule.conditions,\n                                    targets: __spreadArrays(rule.targets)\n                                };\n                                translatedRules.push(translatedRule);\n                                // Translate the targets if possible\n                                if (rule.targets && rule.targets.length > 0) {\n                                    _loop_2 = function (index) {\n                                        var target = rule.targets[index];\n                                        // translate the TargetOverride if possible\n                                        if (target.type === floodgate_shared_typings_1.BranchingTargetType.Override) {\n                                            // Using spread copy to create a new `target` reference\n                                            // then we can deep copy the inner fields as neccesary without changing the original object\n                                            // Any other fields that we don\'t modify, they can be reused by spread copy\n                                            var translatedTarget_1 = __assign({}, target);\n                                            translatedRule.targets[index] = translatedTarget_1;\n                                            var overrideTargetQuestion = uxSchema.pages[target.targetPageIndex].questions.find(function (question) {\n                                                return question.id === target.targetOverrideId;\n                                            });\n                                            promiseList.push(this_2.translateQuestion(uiStringMap, target.overrideProperties, overrideTargetQuestion.type, "branchingRules." + indexRule + ".targets." + index, errorList)\n                                                .then(function (result) {\n                                                translatedTarget_1.overrideProperties = result;\n                                            }));\n                                        }\n                                    };\n                                    this_2 = this;\n                                    for (index = 0; index < rule.targets.length; index++) {\n                                        _loop_2(index);\n                                    }\n                                }\n                            }\n                        }\n                        return [4 /*yield*/, Promise.all(promiseList)];\n                    case 1:\n                        _a.sent();\n                        if (errorList.length > 0) {\n                            throw new Error(JSON.stringify(errorList));\n                        }\n                        // Finally, set the new translated schema\n                        survey.setUxSchema(translatedResult);\n                        return [2 /*return*/];\n                }\n            });\n        });\n    };\n    /**\n     * Translate the given page, and putting error into errorList if there is any\n    */\n    FloodgateSurveyCdnClient.prototype.translatePage = function (uiStringMap, schemaPage, pageKey, errorList) {\n        var promiseList = [];\n        var translatedResult = __assign({}, schemaPage);\n        // Using spread copy to create a new `questions` reference\n        // then we can deep copy the inner fields as neccesary without changing the original object\n        // Any other fields that we don\'t modify, they can be reused by spread copy\n        translatedResult.questions = __spreadArrays(schemaPage.questions);\n        // title is optional\n        if (schemaPage.title) {\n            promiseList.push(this.translateString(uiStringMap, schemaPage.title, pageKey + ".title", errorList)\n                .then(function (result) {\n                translatedResult[\'title\'] = result;\n            }));\n        }\n        var _loop_3 = function (index) {\n            promiseList.push(this_3.translateQuestion(uiStringMap, schemaPage.questions[index], schemaPage.questions[index].type, pageKey + ".questions." + index, errorList)\n                .then(function (result) {\n                translatedResult.questions[index] = result;\n            }));\n        };\n        var this_3 = this;\n        for (var index = 0; index < schemaPage.questions.length; index++) {\n            _loop_3(index);\n        }\n        return Promise.all(promiseList).then(function () { return translatedResult; });\n    };\n    /**\n     * Translate the given string, and putting error into errorList if there is any\n    */\n    FloodgateSurveyCdnClient.prototype.translateQuestion = function (uiStringMap, translateObject, questionType, questionKey, errorList) {\n        var promiseList = [];\n        // Using spread copy to create a new object reference\n        // then we can deep copy the inner object fields as neccesary without changing the original object\n        // Any other fields that we don\'t modify, they can be reused by spread copy\n        var translatedResult = __assign({}, translateObject);\n        if (Object.prototype.hasOwnProperty.call(translateObject, "questionLabel")) {\n            promiseList.push(this.translateString(uiStringMap, translateObject.questionLabel, questionKey + ".questionLabel", errorList)\n                .then(function (result) {\n                translatedResult[\'questionLabel\'] = result;\n            }));\n        }\n        switch (questionType) {\n            case floodgate_shared_typings_1.QuestionType.MultipleChoice:\n            case floodgate_shared_typings_1.QuestionType.SingleSelect: {\n                if (Object.prototype.hasOwnProperty.call(translateObject, "availableOptions")) {\n                    promiseList.push(this.translateStringArray(uiStringMap, translateObject["availableOptions"], questionKey + ".availableOptions", errorList)\n                        .then(function (result) {\n                        translatedResult[\'availableOptions\'] = result;\n                    }));\n                }\n                break;\n            }\n            case floodgate_shared_typings_1.QuestionType.Rating: {\n                if (Object.prototype.hasOwnProperty.call(translateObject, "ratingValues")) {\n                    promiseList.push(this.translateStringArray(uiStringMap, translateObject["ratingValues"], questionKey + ".ratingValues", errorList)\n                        .then(function (result) {\n                        translatedResult[\'ratingValues\'] = result;\n                    }));\n                }\n                if (Object.prototype.hasOwnProperty.call(translateObject, "leftLegendValue")) {\n                    promiseList.push(this.translateString(uiStringMap, translateObject["leftLegendValue"], questionKey + ".leftLegendValue", errorList)\n                        .then(function (result) {\n                        translatedResult["leftLegendValue"] = result;\n                    }));\n                }\n                if (Object.prototype.hasOwnProperty.call(translateObject, "rightLegendValue")) {\n                    promiseList.push(this.translateString(uiStringMap, translateObject["rightLegendValue"], questionKey + ".rightLegendValue", errorList)\n                        .then(function (result) {\n                        translatedResult["rightLegendValue"] = result;\n                    }));\n                }\n                break;\n            }\n            case floodgate_shared_typings_1.QuestionType.Likert: {\n                if (Object.prototype.hasOwnProperty.call(translateObject, "verticalOptions")) {\n                    promiseList.push(this.translateStringArray(uiStringMap, translateObject["verticalOptions"], questionKey + ".verticalOptions", errorList)\n                        .then(function (result) {\n                        translatedResult[\'verticalOptions\'] = result;\n                    }));\n                }\n                if (Object.prototype.hasOwnProperty.call(translateObject, "horizontalStatements")) {\n                    promiseList.push(this.translateStringArray(uiStringMap, translateObject["horizontalStatements"], questionKey + ".horizontalStatements", errorList)\n                        .then(function (result) {\n                        translatedResult[\'horizontalStatements\'] = result;\n                    }));\n                }\n                break;\n            }\n            case floodgate_shared_typings_1.QuestionType.Comment:\n            case floodgate_shared_typings_1.QuestionType.Label:\n                // Nothing special for Comment, Label question\n                break;\n            default:\n                // unknown type\n                errorList.push(questionKey + ".questionType is unknown.");\n                break;\n        }\n        return Promise.all(promiseList).then(function () { return translatedResult; });\n    };\n    /**\n     * Translate the given string array, and putting error into errorList if there is any\n    */\n    FloodgateSurveyCdnClient.prototype.translateStringArray = function (uiStringMap, stringArray, keyArray, errorList) {\n        var promiseList = [];\n        for (var index = 0; index < stringArray.length; index++) {\n            promiseList.push(this.translateString(uiStringMap, stringArray[index], keyArray + "." + index, errorList));\n        }\n        return Promise.all(promiseList).then(function (result) { return result; });\n    };\n    /**\n     * Translate the given string, and putting error into errorList if there is any\n     * @returns empty string if failure. Otherwise, return locale string on success.\n    */\n    FloodgateSurveyCdnClient.prototype.translateString = function (uiStringMap, translatedString, keyString, errorList) {\n        // reject is not used here to prevent the Promise.all to fail fast \n        return new Promise(function (resolve, _reject) {\n            if (Object.prototype.hasOwnProperty.call(uiStringMap, translatedString)) {\n                resolve(uiStringMap[translatedString]);\n            }\n            else {\n                errorList.push("\'" + keyString + ": " + translatedString + "\' does not exist in the strings map.");\n                resolve(\'\');\n            }\n        });\n    };\n    return FloodgateSurveyCdnClient;\n}());\nexports.default = FloodgateSurveyCdnClient;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/FloodgateSurveyCdn/FloodgateSurveyCdnClient.js\n')},"../FloodgateCore/dist/src/GovernanceUtils.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.hasSurveyReachedMaxLaunches = exports.hasSurveyReachedMaxLaunchesPerSession = exports.isCriticalSurvey = exports.isBusinessCriticalSurvey = exports.isMultiLaunchSurvey = void 0;\nvar floodgate_shared_typings_1 = __webpack_require__(/*! @ms-ofb/floodgate-shared-typings */ "../FloodgateCore/node_modules/@ms-ofb/floodgate-shared-typings/dist/index.js");\nvar Utils_1 = __webpack_require__(/*! ./Utils */ "../FloodgateCore/dist/src/Utils.js");\nfunction isMultiLaunchSurvey(surveyInfo) {\n    var maxLaunches = surveyInfo === null || surveyInfo === void 0 ? void 0 : surveyInfo.getMaxLaunches();\n    return Utils_1.isNumber(maxLaunches) && maxLaunches > 1;\n}\nexports.isMultiLaunchSurvey = isMultiLaunchSurvey;\nfunction isBusinessCriticalSurvey(surveyInfo) {\n    var businessLevel = surveyInfo === null || surveyInfo === void 0 ? void 0 : surveyInfo.getBusinessLevel();\n    return !Utils_1.isNOU(businessLevel) && businessLevel === floodgate_shared_typings_1.SurveyInfoBusinessLevel.Critical;\n}\nexports.isBusinessCriticalSurvey = isBusinessCriticalSurvey;\nfunction isCriticalSurvey(surveyInfo) {\n    return isMultiLaunchSurvey(surveyInfo) || isBusinessCriticalSurvey(surveyInfo);\n}\nexports.isCriticalSurvey = isCriticalSurvey;\nfunction hasSurveyReachedMaxLaunchesPerSession(surveyInfo, surveyActivationStats) {\n    var _a;\n    if (isMultiLaunchSurvey(surveyInfo) && Utils_1.isNumber(surveyInfo.getMaxLaunchesPerSession())) {\n        var surveyLaunchCountInSession = (_a = surveyActivationStats[surveyInfo.getId()]) !== null && _a !== void 0 ? _a : 0;\n        var maxLaunchesPerSession = surveyInfo.getMaxLaunchesPerSession();\n        return surveyLaunchCountInSession >= maxLaunchesPerSession;\n    }\n    return true;\n}\nexports.hasSurveyReachedMaxLaunchesPerSession = hasSurveyReachedMaxLaunchesPerSession;\nfunction hasSurveyReachedMaxLaunches(surveyInfo, surveyActivationStats) {\n    if (isMultiLaunchSurvey(surveyInfo)) {\n        var surveyLaunchCount = (surveyActivationStats === null || surveyActivationStats === void 0 ? void 0 : surveyActivationStats.SurveyLaunchCount) || 0;\n        return surveyLaunchCount >= surveyInfo.getMaxLaunches();\n    }\n    return true;\n}\nexports.hasSurveyReachedMaxLaunches = hasSurveyReachedMaxLaunches;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/GovernanceUtils.js\n')},"../FloodgateCore/dist/src/GovernedChannel.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.GovernedChannel = void 0;\nvar floodgate_shared_typings_1 = __webpack_require__(/*! @ms-ofb/floodgate-shared-typings */ "../FloodgateCore/node_modules/@ms-ofb/floodgate-shared-typings/dist/index.js");\nvar Utils = __webpack_require__(/*! ./Utils */ "../FloodgateCore/dist/src/Utils.js");\nvar GovernedChannel = /** @class */ (function () {\n    function GovernedChannel(type, name, cooldownSeconds, cooldownStartTime) {\n        if (!Utils.isEnumValue(type, floodgate_shared_typings_1.GovernedChannelType)) {\n            throw new Error("type is not a valid GovernedChannelType");\n        }\n        if (!name) {\n            throw new Error("name must not be null or empty");\n        }\n        if (cooldownSeconds < 0) {\n            throw new Error("cooldownSeconds must not be negative");\n        }\n        this.type = type;\n        this.name = name;\n        this.cooldownSeconds = cooldownSeconds;\n        this.setCooldownStartTime(cooldownStartTime);\n    }\n    GovernedChannel.prototype.setCooldownStartTime = function (cooldownStartTime) {\n        // Set the start time\n        this.cooldownStartTime = cooldownStartTime;\n        if (Utils.isNOU(this.cooldownStartTime)) {\n            // Null cooldownStartTime means cool down has never been initiated, so set the cooldownEndTime to distant past\n            this.cooldownEndTime = Utils.getDistantPast();\n            return;\n        }\n        // Calculate the end time, but don\'t overflow past max.\n        this.cooldownEndTime = Utils.addSecondsWithoutOverflow(this.cooldownStartTime, this.cooldownSeconds);\n    };\n    // @Override\n    GovernedChannel.prototype.isOpen = function () {\n        return this.isOpenAtDate(new Date());\n    };\n    // @Override\n    GovernedChannel.prototype.isOpenAtDate = function (date) {\n        if (!date) {\n            return false;\n        }\n        return (date > this.cooldownEndTime);\n    };\n    // @Override\n    GovernedChannel.prototype.getType = function () {\n        return this.type;\n    };\n    // @Override\n    GovernedChannel.prototype.getName = function () {\n        return this.name;\n    };\n    // @Override\n    GovernedChannel.prototype.getCooldownSeconds = function () {\n        return this.cooldownSeconds;\n    };\n    // @Override\n    GovernedChannel.prototype.getCooldownStartTime = function () {\n        return this.cooldownStartTime;\n    };\n    // @Override\n    GovernedChannel.prototype.getCooldownEndTime = function () {\n        return this.cooldownEndTime;\n    };\n    return GovernedChannel;\n}());\nexports.GovernedChannel = GovernedChannel;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/GovernedChannel.js\n')},"../FloodgateCore/dist/src/GovernedChannelStateProvider.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.FileBasedGovernedChannelStateProvider = exports.HostBasedGovernedChannelStateProvider = exports.GovernedChannelStateProviderFactory = exports.GovernedChannelState = void 0;\nvar floodgate_shared_typings_1 = __webpack_require__(/*! @ms-ofb/floodgate-shared-typings */ "../FloodgateCore/node_modules/@ms-ofb/floodgate-shared-typings/dist/index.js");\nvar Constants_1 = __webpack_require__(/*! ./Constants */ "../FloodgateCore/dist/src/Constants.js");\nvar StateProviderHelpers = __webpack_require__(/*! ./StateProviderHelpers */ "../FloodgateCore/dist/src/StateProviderHelpers.js");\nvar Utils = __webpack_require__(/*! ./Utils */ "../FloodgateCore/dist/src/Utils.js");\nvar TelemetryLogger_1 = __webpack_require__(/*! ./TelemetryLogger */ "../FloodgateCore/dist/src/TelemetryLogger.js");\nvar GovernedChannelState = /** @class */ (function () {\n    function GovernedChannelState(type, cooldownStartTime) {\n        this.ChannelType = type;\n        this.CooldownStartTimeUtc = cooldownStartTime;\n        if (!this.validate()) {\n            throw new Error("Constructor arguments are not valid");\n        }\n    }\n    /**\n     * Method to deserialize a JSON object to class object\n     * @param input: JSON object\n     * Returns class object\n     */\n    GovernedChannelState.deserialize = function (input) {\n        var result;\n        if (!input) {\n            return null;\n        }\n        // Validation is handled by GovernedChannelState\'s constructor\n        try {\n            result = new GovernedChannelState(input.ChannelType, input.CooldownStartTimeUtc);\n        }\n        catch (e) {\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.GovernedChannelState.Deserialize.Failed, { ErrorMessage: e.toString() });\n            return null;\n        }\n        return result;\n    };\n    GovernedChannelState.prototype.validate = function () {\n        if (!Utils.isEnumValue(this.ChannelType, floodgate_shared_typings_1.GovernedChannelType)) {\n            return false;\n        }\n        // make it a date object if it\'s a valid UTC date time value\n        if (Utils.isUtcDatetimeString(this.CooldownStartTimeUtc)) {\n            this.CooldownStartTimeUtc = Utils.stringToDate(this.CooldownStartTimeUtc);\n            // Allow null and bad cooldownStartTime\n        }\n        else if (Utils.isNOU(this.CooldownStartTimeUtc) || !Utils.isDate(this.CooldownStartTimeUtc)) {\n            this.CooldownStartTimeUtc = Utils.getDistantPast();\n        }\n        return true;\n    };\n    GovernedChannelState.prototype.getType = function () {\n        return this.ChannelType;\n    };\n    GovernedChannelState.prototype.getCooldownStartTime = function () {\n        return this.CooldownStartTimeUtc;\n    };\n    return GovernedChannelState;\n}());\nexports.GovernedChannelState = GovernedChannelState;\nvar GovernedChannelStateProviderFactory = /** @class */ (function () {\n    function GovernedChannelStateProviderFactory() {\n    }\n    GovernedChannelStateProviderFactory.make = function (fileBasedStorage, hostBasedStorage) {\n        if (hostBasedStorage) {\n            return new HostBasedGovernedChannelStateProvider(fileBasedStorage, hostBasedStorage);\n        }\n        return new FileBasedGovernedChannelStateProvider(fileBasedStorage);\n    };\n    return GovernedChannelStateProviderFactory;\n}());\nexports.GovernedChannelStateProviderFactory = GovernedChannelStateProviderFactory;\n/**\n * Class representing what is stored in the file.\n */\nvar FileData = /** @class */ (function () {\n    function FileData() {\n    }\n    return FileData;\n}());\nvar HostBasedGovernedChannelStateProvider = /** @class */ (function () {\n    function HostBasedGovernedChannelStateProvider(fileBasedStorage, hostBasedStorage) {\n        if (!hostBasedStorage) {\n            throw new Error("host-based storage must not be null");\n        }\n        this.hostBasedStorage = hostBasedStorage;\n        // file-based provider is optional\n        if (fileBasedStorage) {\n            this.fileBasedStateProvider = new FileBasedGovernedChannelStateProvider(fileBasedStorage);\n        }\n    }\n    // @Override\n    HostBasedGovernedChannelStateProvider.prototype.load = function () {\n        var statesFromHost = this.getStatesFromHost();\n        var statesFromFile;\n        if (this.fileBasedStateProvider) {\n            statesFromFile = this.fileBasedStateProvider.load();\n        }\n        var StateCollections = StateProviderHelpers.MergeAndUpdateGovernedChannelStates(statesFromFile, statesFromHost);\n        return StateCollections.find(0 /* Merged */);\n    };\n    // @Override\n    HostBasedGovernedChannelStateProvider.prototype.save = function (states) {\n        var _this = this;\n        if (!states) {\n            return;\n        }\n        var statesFromHost = this.getStatesFromHost();\n        var StateCollections = StateProviderHelpers.MergeAndUpdateGovernedChannelStates(states, statesFromHost);\n        var toBeUpdatedStates = StateCollections.find(1 /* ToBeUpdated */);\n        var mergedStates = StateCollections.find(0 /* Merged */);\n        // write delta_data to Host\n        if (toBeUpdatedStates) {\n            toBeUpdatedStates.forEach(function (state) {\n                var stateValue = StateProviderHelpers.makeSettingItemValue(JSON.stringify(state));\n                _this.hostBasedStorage.upsertSettingItem(floodgate_shared_typings_1.FloodgateStorageProviderFileType[floodgate_shared_typings_1.FloodgateStorageProviderFileType.GovernedChannelStates], String(state.getType()), stateValue);\n            });\n        }\n        // Write merged data to File\n        if (this.fileBasedStateProvider) {\n            this.fileBasedStateProvider.save(mergedStates);\n        }\n    };\n    HostBasedGovernedChannelStateProvider.prototype.getStatesFromHost = function () {\n        var states = [];\n        var settings = this.hostBasedStorage.readSettingList(floodgate_shared_typings_1.FloodgateStorageProviderFileType[floodgate_shared_typings_1.FloodgateStorageProviderFileType.GovernedChannelStates]);\n        for (var key in settings) {\n            if (!Object.prototype.hasOwnProperty.call(settings, key)) {\n                continue;\n            }\n            var value = settings[key];\n            var dataString = StateProviderHelpers.extractSettingItemValueSubString(value);\n            var itemObject = {};\n            try {\n                itemObject = JSON.parse(dataString);\n                var newState = GovernedChannelState.deserialize(itemObject);\n                if (newState) {\n                    states.push(newState);\n                }\n            }\n            catch (e) {\n                TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.HostBasedGovernedChannelStateProvider.GetStatesFromHost.Failed, { ErrorMessage: "Json parsing/deserializing failed. " + e.toString() + ".  Input:" + dataString });\n            }\n        }\n        return states;\n    };\n    return HostBasedGovernedChannelStateProvider;\n}());\nexports.HostBasedGovernedChannelStateProvider = HostBasedGovernedChannelStateProvider;\nvar FileBasedGovernedChannelStateProvider = /** @class */ (function () {\n    function FileBasedGovernedChannelStateProvider(storage) {\n        if (!storage) {\n            throw new Error("storage must not be null");\n        }\n        this.storage = storage;\n    }\n    // @Override\n    FileBasedGovernedChannelStateProvider.prototype.load = function () {\n        // Load channel state from file using _storageProvider (get back string)\n        var readString = this.storage.read(floodgate_shared_typings_1.FloodgateStorageProviderFileType.GovernedChannelStates);\n        if (!readString) {\n            return [];\n        }\n        var fileData;\n        try {\n            fileData = JSON.parse(readString);\n            var result_1 = [];\n            if (fileData && fileData.ChannelStates) {\n                fileData.ChannelStates.forEach(function (state) {\n                    var newState = GovernedChannelState.deserialize(state);\n                    if (newState) {\n                        result_1.push(newState);\n                    }\n                });\n            }\n            return result_1;\n        }\n        catch (e) {\n            TelemetryLogger_1.TelemetryLogger.getTelemetryLogger().log_Event(Constants_1.TelemetryEvent.FileBasedGovernedChannelStateProvider.Load.Failed, { ErrorMessage: "Json parsing/deserializing failed. " + e.toString() + ".  Input:" + readString });\n            return [];\n        }\n    };\n    // @Override\n    FileBasedGovernedChannelStateProvider.prototype.save = function (states) {\n        if (!states) {\n            return;\n        }\n        var fileData = new FileData();\n        fileData.ChannelStates = states;\n        var writeString = JSON.stringify(fileData);\n        this.storage.write(floodgate_shared_typings_1.FloodgateStorageProviderFileType.GovernedChannelStates, writeString);\n    };\n    return FileBasedGovernedChannelStateProvider;\n}());\nexports.FileBasedGovernedChannelStateProvider = FileBasedGovernedChannelStateProvider;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/GovernedChannelStateProvider.js\n')},"../FloodgateCore/dist/src/Governor.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.Governor = void 0;\nvar floodgate_shared_typings_1 = __webpack_require__(/*! @ms-ofb/floodgate-shared-typings */ "../FloodgateCore/node_modules/@ms-ofb/floodgate-shared-typings/dist/index.js");\nvar GovernedChannel_1 = __webpack_require__(/*! ./GovernedChannel */ "../FloodgateCore/dist/src/GovernedChannel.js");\nvar GovernedChannelStateProvider_1 = __webpack_require__(/*! ./GovernedChannelStateProvider */ "../FloodgateCore/dist/src/GovernedChannelStateProvider.js");\nvar Utils = __webpack_require__(/*! ./Utils */ "../FloodgateCore/dist/src/Utils.js");\nvar isNOU = Utils.isNOU;\nvar DefaultChannelData = /** @class */ (function () {\n    function DefaultChannelData(name, cooldownSeconds) {\n        this.name = name;\n        this.cooldownSeconds = cooldownSeconds;\n    }\n    return DefaultChannelData;\n}());\nvar Governor = /** @class */ (function () {\n    function Governor(channelStateProvider) {\n        this.channels = [];\n        if (!channelStateProvider) {\n            throw new Error("channelStateProvider must not be null");\n        }\n        this.channelStateProvider = channelStateProvider;\n        this.loadChannels();\n    }\n    Governor.GetChannelCoolDown = function (channelType) {\n        var channelData = Governor.defaultChannelData[channelType];\n        return channelData ? channelData.cooldownSeconds : 0;\n    };\n    Governor.SetDefaultChannelCoolDown = function (channelType, cooldownSeconds) {\n        var channelData = Governor.defaultChannelData[channelType];\n        if (channelData) {\n            channelData.cooldownSeconds = cooldownSeconds;\n        }\n    };\n    // @Override\n    Governor.prototype.refreshChannelData = function () {\n        this.loadChannels();\n    };\n    // @Override\n    Governor.prototype.getAvailableChannelData = function () {\n        var channelData = [];\n        for (var key in this.channels) {\n            if (Object.prototype.hasOwnProperty.call(this.channels, key)) {\n                var channel = this.channels[key];\n                if (channel.isOpen()) {\n                    channelData.push(channel);\n                }\n            }\n        }\n        return channelData;\n    };\n    // @Override\n    Governor.prototype.isChannelOpen = function (type) {\n        if (isNOU(type)) {\n            throw new Error("type must not be null");\n        }\n        return this.channels[type].isOpen();\n    };\n    // @Override\n    Governor.prototype.startChannelCooldown = function (type, date) {\n        if (isNOU(type)) {\n            throw new Error("type must not be null");\n        }\n        date = date ? date : new Date();\n        // Start the cool down\n        this.channels[type].setCooldownStartTime(date);\n        // Save the new channel state for future sessions\n        this.saveChannelStates();\n    };\n    Governor.prototype.saveChannelStates = function () {\n        // Build up the list of channel states\n        var channelStates = [];\n        for (var key in this.channels) {\n            if (Object.prototype.hasOwnProperty.call(this.channels, key)) {\n                var channel = this.channels[key];\n                var channelState = new GovernedChannelStateProvider_1.GovernedChannelState(channel.getType(), channel.getCooldownStartTime());\n                channelStates.push(channelState);\n            }\n        }\n        this.channelStateProvider.save(channelStates);\n    };\n    Governor.prototype.loadChannels = function () {\n        // Load up state from previous sessions\n        this.loadChannelStatesFromProvider();\n        // For any missing channels, init them from scratch\n        // There\'s no straightforward way to iterate enums, we need to iterate through the enum array\n        //    filtering out just the numeric enum values (excluding enum names).\n        for (var item in floodgate_shared_typings_1.GovernedChannelType) {\n            if (Object.prototype.hasOwnProperty.call(floodgate_shared_typings_1.GovernedChannelType, item)) {\n                var key = Number(item);\n                // skip if key is not numeric enum value, or if already exists\n                if (isNaN(key) || this.channels[key]) {\n                    continue;\n                }\n                var defaultData = Governor.defaultChannelData[key];\n                var newChannel = new GovernedChannel_1.GovernedChannel(key, defaultData.name, defaultData.cooldownSeconds, null);\n                this.channels[key] = newChannel;\n            }\n        }\n    };\n    Governor.prototype.loadChannelStatesFromProvider = function () {\n        this.channels = [];\n        var channelStates = this.channelStateProvider.load();\n        for (var key in channelStates) {\n            if (Object.prototype.hasOwnProperty.call(channelStates, key)) {\n                var channelState = channelStates[key];\n                var type = channelState.getType();\n                var defaultData = Governor.defaultChannelData[type];\n                var newChannel = new GovernedChannel_1.GovernedChannel(type, defaultData.name, defaultData.cooldownSeconds, channelState.getCooldownStartTime());\n                this.channels[newChannel.getType()] = newChannel;\n            }\n        }\n    };\n    Governor.minute = 60;\n    Governor.hour = 60 * Governor.minute;\n    Governor.day = 24 * Governor.hour;\n    // Array of default values for each channel type. Indexed by the GovernedChannelType enum name.\n    Governor.defaultChannelData = [\n        new DefaultChannelData(floodgate_shared_typings_1.GovernedChannelType[floodgate_shared_typings_1.GovernedChannelType.Standard], 14 * Governor.day),\n        new DefaultChannelData(floodgate_shared_typings_1.GovernedChannelType[floodgate_shared_typings_1.GovernedChannelType.Urgent], 0),\n        new DefaultChannelData(floodgate_shared_typings_1.GovernedChannelType[floodgate_shared_typings_1.GovernedChannelType.Banner], 15 * Governor.day),\n        new DefaultChannelData(floodgate_shared_typings_1.GovernedChannelType[floodgate_shared_typings_1.GovernedChannelType.TeachingMessage], 1 * Governor.hour),\n        new DefaultChannelData(floodgate_shared_typings_1.GovernedChannelType[floodgate_shared_typings_1.GovernedChannelType.BusinessBar], 3 * Governor.hour),\n    ];\n    return Governor;\n}());\nexports.Governor = Governor;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/Governor.js\n')},"../FloodgateCore/dist/src/IndexedTracker.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.IndexedTracker = void 0;\nvar IndexedTracker = /** @class */ (function () {\n    function IndexedTracker() {\n    }\n    return IndexedTracker;\n}());\nexports.IndexedTracker = IndexedTracker;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vc3JjL0luZGV4ZWRUcmFja2VyLnRzPzE5ZmQiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBRUE7SUFBQTtJQUlBLENBQUM7SUFBRCxxQkFBQztBQUFELENBQUM7QUFKWSx3Q0FBYyIsImZpbGUiOiIuLi9GbG9vZGdhdGVDb3JlL2Rpc3Qvc3JjL0luZGV4ZWRUcmFja2VyLmpzLmpzIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IEFjdGl2aXR5VHJhY2tlciBmcm9tIFwiLi9BY3Rpdml0eVRyYWNrZXJcIjtcclxuXHJcbmV4cG9ydCBjbGFzcyBJbmRleGVkVHJhY2tlciB7XHJcblx0cHVibGljIGluZGV4OiBudW1iZXI7XHJcblx0cHVibGljIHN1cnZleUlkOiBzdHJpbmc7XHJcblx0cHVibGljIHRyYWNrZXI6IEFjdGl2aXR5VHJhY2tlcjtcclxufVxyXG4iXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/IndexedTracker.js\n')},"../FloodgateCore/dist/src/OrchestrationEngine/Api.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.CampaignBusinessLevel = exports.GovernanceDecision = void 0;\nvar GovernanceDecision;\n(function (GovernanceDecision) {\n    GovernanceDecision[GovernanceDecision["Approved"] = 0] = "Approved";\n    GovernanceDecision[GovernanceDecision["Rejected"] = 1] = "Rejected";\n    GovernanceDecision[GovernanceDecision["Error"] = 2] = "Error";\n})(GovernanceDecision = exports.GovernanceDecision || (exports.GovernanceDecision = {}));\nvar CampaignBusinessLevel;\n(function (CampaignBusinessLevel) {\n    CampaignBusinessLevel[CampaignBusinessLevel["None"] = 0] = "None";\n    CampaignBusinessLevel[CampaignBusinessLevel["Critical"] = 1] = "Critical";\n})(CampaignBusinessLevel = exports.CampaignBusinessLevel || (exports.CampaignBusinessLevel = {}));\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vc3JjL09yY2hlc3RyYXRpb25FbmdpbmUvQXBpLnRzPzQ0NGQiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBT0EsSUFBWSxrQkFJWDtBQUpELFdBQVksa0JBQWtCO0lBQzdCLG1FQUFRO0lBQ1IsbUVBQVE7SUFDUiw2REFBSztBQUNOLENBQUMsRUFKVyxrQkFBa0IsR0FBbEIsMEJBQWtCLEtBQWxCLDBCQUFrQixRQUk3QjtBQU9ELElBQVkscUJBR1g7QUFIRCxXQUFZLHFCQUFxQjtJQUNoQyxpRUFBUTtJQUNSLHlFQUFZO0FBQ2IsQ0FBQyxFQUhXLHFCQUFxQixHQUFyQiw2QkFBcUIsS0FBckIsNkJBQXFCLFFBR2hDIiwiZmlsZSI6Ii4uL0Zsb29kZ2F0ZUNvcmUvZGlzdC9zcmMvT3JjaGVzdHJhdGlvbkVuZ2luZS9BcGkuanMuanMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1xyXG5cdEdvdmVybmVkQ2hhbm5lbFR5cGUsXHJcblx0SUdvdmVybmFuY2VQYXJhbWV0ZXJzLFxyXG5cdElHb3Zlcm5hbmNlU2VydmljZVJlc3VsdCxcclxufSBmcm9tIFwiQG1zLW9mYi9mbG9vZGdhdGUtc2hhcmVkLXR5cGluZ3NcIjtcclxuaW1wb3J0IHsgSUFwcEdvdmVybmFuY2VDYW1wYWlnbkZvcm0gfSBmcm9tIFwiQG1zLW9mYi9mbG9vZGdhdGUtc2hhcmVkLXR5cGluZ3MvZGlzdC9zcmMvQ29yZS9BcGkvSUFwcEdvdmVybmFuY2VQcm92aWRlclwiO1xyXG5cclxuZXhwb3J0IGVudW0gR292ZXJuYW5jZURlY2lzaW9uIHtcclxuXHRBcHByb3ZlZCxcclxuXHRSZWplY3RlZCxcclxuXHRFcnJvclxyXG59XHJcblxyXG5leHBvcnQgaW50ZXJmYWNlIElHb3Zlcm5hbmNlRGVjaXNpb24ge1xyXG5cdGdvdmVybmFuY2VEZWNpc2lvbjogR292ZXJuYW5jZURlY2lzaW9uO1xyXG5cdHNlcnZpY2VSZXN1bHQ/OiBJR292ZXJuYW5jZVNlcnZpY2VSZXN1bHQ7XHJcbn1cclxuXHJcbmV4cG9ydCBlbnVtIENhbXBhaWduQnVzaW5lc3NMZXZlbCB7XHJcblx0Tm9uZSA9IDAsXHJcblx0Q3JpdGljYWwgPSAxXHJcbn1cclxuXHJcbmV4cG9ydCBpbnRlcmZhY2UgSU9yY2hlc3RyYXRpb25FbmdpbmUge1xyXG5cdGdldERlY2lzaW9uKGJ1c2luZXNzTGV2ZWw6IENhbXBhaWduQnVzaW5lc3NMZXZlbCwgZ292ZXJuYW5jZVBhcmFtczogSUdvdmVybmFuY2VQYXJhbWV0ZXJzKTogUHJvbWlzZTxJR292ZXJuYW5jZURlY2lzaW9uPjtcclxuXHRpc1N1cnZleVRyYWNrYWJsZShjYW1wYWlnbkZvcm06IElBcHBHb3Zlcm5hbmNlQ2FtcGFpZ25Gb3JtKTogYm9vbGVhbjtcclxuXHRnZXRBdmFpbGFibGVDaGFubmVscygpOiBHb3Zlcm5lZENoYW5uZWxUeXBlW107XHJcblx0bWVyZ2VBbmRTYXZlKCk6IHZvaWQ7XHJcblxyXG5cdHN0YXJ0Q2hhbm5lbENvb2xkb3duKGNoYW5uZWxUeXBlOiBHb3Zlcm5lZENoYW5uZWxUeXBlLCBkYXRlVGltZT86IERhdGUpOiB2b2lkXHJcblxyXG5cdGlzQ2hhbm5lbE9wZW4odHlwZTogR292ZXJuZWRDaGFubmVsVHlwZSwgcmVmcmVzaERhdGE/OiBib29sZWFuKTogYm9vbGVhbjtcclxuXHRpc0NoYW5uZWxHb3Zlcm5hbmNlRW5hYmxlZChnb3Zlcm5lZENoYW5uZWxUeXBlOiBHb3Zlcm5lZENoYW5uZWxUeXBlKTogYm9vbGVhbjtcclxuXHJcblx0c2hvdWxkRm9yY2VQZXJtaXNzaW9uKCk6IGJvb2xlYW47XHJcblx0Z2V0U3RhdGVGb3JUZWxlbWV0cnkoKTogYW55O1xyXG59XHJcbiJdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/OrchestrationEngine/Api.js\n')},"../FloodgateCore/dist/src/OrchestrationEngine/OrchestrationEngine.js":function(module,exports,__webpack_require__){"use strict";eval('\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nvar __generator = (this && this.__generator) || function (thisArg, body) {\n    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;\n    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;\n    function verb(n) { return function (v) { return step([n, v]); }; }\n    function step(op) {\n        if (f) throw new TypeError("Generator is already executing.");\n        while (_) try {\n            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;\n            if (y = 0, t) op = [op[0] & 2, t.value];\n            switch (op[0]) {\n                case 0: case 1: t = op; break;\n                case 4: _.label++; return { value: op[1], done: false };\n                case 5: _.label++; y = op[1]; op = [0]; continue;\n                case 7: op = _.ops.pop(); _.trys.pop(); continue;\n                default:\n                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }\n                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }\n                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }\n                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }\n                    if (t[2]) _.ops.pop();\n                    _.trys.pop(); continue;\n            }\n            op = body.call(thisArg, _);\n        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }\n        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };\n    }\n};\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.OrchestrationEngine = void 0;\nvar Governor_1 = __webpack_require__(/*! ../Governor */ "../FloodgateCore/dist/src/Governor.js");\nvar Api_1 = __webpack_require__(/*! ./Api */ "../FloodgateCore/dist/src/OrchestrationEngine/Api.js");\nvar OrchestrationEngine = /** @class */ (function () {\n    function OrchestrationEngine(governanceServiceClient, governedChannelStateProvider, appGovernanceProvider) {\n        if (!governanceServiceClient) {\n            throw new Error("Invalid governanceServiceClient");\n        }\n        if (!governedChannelStateProvider) {\n            throw new Error("Invalid governanceServiceClient");\n        }\n        this.governanceServiceClient = governanceServiceClient;\n        this.channelGovernanceProvider = new Governor_1.Governor(governedChannelStateProvider);\n        this.appGovernanceProvider = appGovernanceProvider;\n    }\n    OrchestrationEngine.prototype.getDecision = function (businessLevel, governanceParams) {\n        return __awaiter(this, void 0, void 0, function () {\n            var defaultDecision, serviceResult, governanceDecision;\n            return __generator(this, function (_a) {\n                switch (_a.label) {\n                    case 0:\n                        if (!governanceParams) {\n                            throw new Error("Invalid governanceParams");\n                        }\n                        defaultDecision = {\n                            governanceDecision: Api_1.GovernanceDecision.Approved,\n                            serviceResult: {\n                                permission: true\n                            }\n                        };\n                        // Always allow business critical campaigns\n                        if (businessLevel === Api_1.CampaignBusinessLevel.Critical) {\n                            return [2 /*return*/, defaultDecision];\n                        }\n                        // Allow calls only on the channels that are governed\n                        if (!this.governanceServiceClient.isEnabled(governanceParams.channelType)) {\n                            return [2 /*return*/, defaultDecision];\n                        }\n                        // Update governance cooldown if the value is not set\n                        if (governanceParams.userCooldown < 0) {\n                            governanceParams.userCooldown = Governor_1.Governor.GetChannelCoolDown(governanceParams.channelType);\n                        }\n                        return [4 /*yield*/, this.governanceServiceClient.checkGovernancePermitAsync(governanceParams)];\n                    case 1:\n                        serviceResult = _a.sent();\n                        governanceDecision = Api_1.GovernanceDecision.Error;\n                        if (serviceResult && !serviceResult.error) {\n                            governanceDecision = serviceResult.permission ? Api_1.GovernanceDecision.Approved : Api_1.GovernanceDecision.Rejected;\n                        }\n                        return [2 /*return*/, {\n                                governanceDecision: governanceDecision,\n                                serviceResult: serviceResult\n                            }];\n                }\n            });\n        });\n    };\n    OrchestrationEngine.prototype.isSurveyTrackable = function (campaignForm) {\n        return !this.appGovernanceProvider || this.appGovernanceProvider.getDecision(campaignForm);\n    };\n    OrchestrationEngine.prototype.getAvailableChannels = function () {\n        var channels = this.channelGovernanceProvider.getAvailableChannelData();\n        var channelTypes = [];\n        channels.forEach(function (channel) {\n            if (channel) {\n                channelTypes.push(channel.getType());\n            }\n        });\n        return channelTypes;\n    };\n    OrchestrationEngine.prototype.mergeAndSave = function () {\n        this.channelGovernanceProvider.saveChannelStates();\n    };\n    OrchestrationEngine.prototype.isChannelOpen = function (governedChannelType, refreshData) {\n        if (refreshData === void 0) { refreshData = true; }\n        // Refresh channels\n        if (refreshData) {\n            this.channelGovernanceProvider.refreshChannelData();\n        }\n        return this.channelGovernanceProvider.isChannelOpen(governedChannelType);\n    };\n    OrchestrationEngine.prototype.isChannelGovernanceEnabled = function (governedChannelType) {\n        return this.governanceServiceClient.isEnabled(governedChannelType);\n    };\n    OrchestrationEngine.prototype.startChannelCooldown = function (channelType, dateTime) {\n        this.channelGovernanceProvider.startChannelCooldown(channelType, dateTime);\n    };\n    OrchestrationEngine.prototype.shouldForcePermission = function () {\n        return this.governanceServiceClient.shouldForceDisplay();\n    };\n    OrchestrationEngine.prototype.getStateForTelemetry = function () {\n        return this.governanceServiceClient.getClientState();\n    };\n    return OrchestrationEngine;\n}());\nexports.OrchestrationEngine = OrchestrationEngine;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/OrchestrationEngine/OrchestrationEngine.js\n')},"../FloodgateCore/dist/src/StateProviderHelpers.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nexports.MergeAndUpdateSurveyActivationStats = exports.MergeAndUpdateCampaignStates = exports.MergeAndUpdateGovernedChannelStates = exports.makeSettingItemValue = exports.extractSettingItemValueSubString = exports.ItemCollection = void 0;\nvar SurveyStatCollectionActivation_1 = __webpack_require__(/*! ../src/SurveyStatCollectionActivation */ "../FloodgateCore/dist/src/SurveyStatCollectionActivation.js");\nvar ItemCollection = /** @class */ (function () {\n    function ItemCollection() {\n        this.items = {};\n        this.itemCount = 0;\n    }\n    ItemCollection.prototype.add = function (key, value) {\n        if (!this.items[key]) {\n            this.itemCount++;\n        }\n        this.items[key] = value;\n    };\n    ItemCollection.prototype.find = function (key) {\n        return this.items[key];\n    };\n    ItemCollection.prototype.remove = function (key) {\n        var item = this.items[key];\n        if (item) {\n            delete this.items[key];\n            this.itemCount--;\n        }\n        return item;\n    };\n    ItemCollection.prototype.count = function () {\n        return this.itemCount;\n    };\n    return ItemCollection;\n}());\nexports.ItemCollection = ItemCollection;\nfunction extractSettingItemValueSubString(itemValue) {\n    if (!itemValue) {\n        return itemValue;\n    }\n    var beginPos = itemValue.indexOf(SETTING_DATA_OPEN_TAG) + SETTING_DATA_OPEN_TAG.length;\n    var endPos = itemValue.indexOf(SETTING_DATA_CLOSE_TAG);\n    if (beginPos < 0 || endPos < 0) {\n        return itemValue;\n    }\n    return itemValue.substring(beginPos, endPos);\n}\nexports.extractSettingItemValueSubString = extractSettingItemValueSubString;\nfunction makeSettingItemValue(value) {\n    if (!value) {\n        return SETTING_DATA_OPEN_TAG + SETTING_DATA_CLOSE_TAG;\n    }\n    return SETTING_DATA_OPEN_TAG + value + SETTING_DATA_CLOSE_TAG;\n}\nexports.makeSettingItemValue = makeSettingItemValue;\nfunction MergeAndUpdateGovernedChannelStates(previousStates, currentStates) {\n    var stateCollections = new ItemCollection();\n    // Todo: move the following into a generic method to be shared\n    if (!previousStates && !currentStates) {\n        return stateCollections;\n    }\n    if (!previousStates) {\n        stateCollections.add(0 /* Merged */, currentStates);\n        return stateCollections;\n    }\n    if (!currentStates) {\n        stateCollections.add(0 /* Merged */, previousStates);\n        stateCollections.add(1 /* ToBeUpdated */, previousStates);\n        return stateCollections;\n    }\n    var mergedStates = [];\n    var toBeUpdatedStates = [];\n    if (previousStates) {\n        previousStates.forEach(function (previousState) {\n            // find matching in current states\n            var pos = -1;\n            var currentState;\n            for (var i = 0; i < currentStates.length; i++) {\n                currentState = currentStates[i];\n                if (currentState.getType() === previousState.getType()) {\n                    pos = i;\n                    break;\n                }\n            }\n            // if previous state is not in current states\n            if (pos === -1) {\n                // add previous state to merged\n                mergedStates.push(previousState);\n                // add previous state to toUpdated\n                toBeUpdatedStates.push(previousState);\n                return;\n            }\n            // if ActivationTimeUtc of previous is greater than current\n            if (previousState.getCooldownStartTime() > currentState.getCooldownStartTime()) {\n                // add previous state to merged\n                mergedStates.push(previousState);\n                // add previous state to toUpdated\n                toBeUpdatedStates.push(previousState);\n            }\n            else {\n                // add current state to merged\n                mergedStates.push(currentState);\n            }\n            // remove state from current states\n            currentStates.splice(pos, 1);\n        });\n    }\n    // for the remaining current states\n    if (currentStates) {\n        currentStates.forEach(function (currentState) {\n            // add current state to merged\n            mergedStates.push(currentState);\n        });\n    }\n    stateCollections.add(0 /* Merged */, mergedStates);\n    if (toBeUpdatedStates.length > 0) {\n        stateCollections.add(1 /* ToBeUpdated */, toBeUpdatedStates);\n    }\n    return stateCollections;\n}\nexports.MergeAndUpdateGovernedChannelStates = MergeAndUpdateGovernedChannelStates;\nfunction MergeAndUpdateCampaignStates(previousStates, currentStates) {\n    var stateCollections = new ItemCollection();\n    if (!previousStates && !currentStates) {\n        return stateCollections;\n    }\n    if (!previousStates) {\n        stateCollections.add(0 /* Merged */, currentStates);\n        return stateCollections;\n    }\n    if (!currentStates) {\n        stateCollections.add(0 /* Merged */, previousStates);\n        stateCollections.add(1 /* ToBeUpdated */, previousStates);\n        return stateCollections;\n    }\n    var mergedStates = [];\n    var toBeUpdatedStates = [];\n    if (previousStates) {\n        previousStates.forEach(function (previousState) {\n            var current = new Date();\n            // find matching in current states\n            var pos = -1;\n            var currentState;\n            for (var i = 0; i < currentStates.length; i++) {\n                currentState = currentStates[i];\n                if (currentState.CampaignId === previousState.CampaignId) {\n                    pos = i;\n                    break;\n                }\n            }\n            // if previous state is not in current states\n            if (pos === -1) {\n                // add previous state to merged\n                mergedStates.push(previousState);\n                // add previous state to toUpdated\n                toBeUpdatedStates.push(previousState);\n                return;\n            }\n            // if current state is in cooldown, add to merged list\n            if (currentState.LastCooldownEndTimeUtc > current) {\n                // add previous state to merged list\n                mergedStates.push(currentState);\n                // emove state from current states\n                currentStates.splice(pos, 1);\n                return;\n            }\n            // if previous state is in cooldown, add to merged and toUpdated lists\n            if (previousState.LastCooldownEndTimeUtc > current) {\n                // add previous state to merged list\n                mergedStates.push(previousState);\n                // add previous state to to-be-updated list\n                toBeUpdatedStates.push(previousState);\n                // emove state from current states\n                currentStates.splice(pos, 1);\n                return;\n            }\n            // add previous state to toUpdated and merged for the following two conditions:\n            //  1. previous cooldown time wins, or\n            //  2. cooldown times are the same and previous nomination wins\n            if (previousState.getCooldownStartDate() > currentState.getCooldownStartDate()\n                || (previousState.getCooldownStartDate() === currentState.getCooldownStartDate()\n                    && previousState.LastNominationTimeUtc > currentState.LastNominationTimeUtc)) {\n                mergedStates.push(previousState);\n                toBeUpdatedStates.push(previousState);\n            }\n            else {\n                // add current state to merged\n                mergedStates.push(currentState);\n            }\n            // remove state from current states\n            currentStates.splice(pos, 1);\n        });\n    }\n    // for the remaining current states\n    if (currentStates) {\n        currentStates.forEach(function (current) {\n            // add current state to merged\n            mergedStates.push(current);\n        });\n    }\n    stateCollections.add(0 /* Merged */, mergedStates);\n    if (toBeUpdatedStates.length > 0) {\n        stateCollections.add(1 /* ToBeUpdated */, toBeUpdatedStates);\n    }\n    return stateCollections;\n}\nexports.MergeAndUpdateCampaignStates = MergeAndUpdateCampaignStates;\nfunction MergeAndUpdateSurveyActivationStats(previousStats, currentStats) {\n    var statsCollections = new ItemCollection();\n    // Handle previousStats and/or currentStats equal to null\n    if (!previousStats && !currentStats) {\n        return statsCollections;\n    }\n    if (!previousStats) {\n        statsCollections.add(0 /* Merged */, currentStats);\n        return statsCollections;\n    }\n    if (!currentStats) {\n        statsCollections.add(0 /* Merged */, previousStats);\n        statsCollections.add(1 /* ToBeUpdated */, previousStats);\n        return statsCollections;\n    }\n    // Enumerate preivous stats\n    var mergedStats = new SurveyStatCollectionActivation_1.SurveyStatCollectionActivation();\n    var toBeUpdatedStats = new SurveyStatCollectionActivation_1.SurveyStatCollectionActivation();\n    var previousStatsDictionary = previousStats.getStats();\n    var currentStatsDictionary = currentStats.getStats();\n    for (var surveyId in previousStatsDictionary) {\n        if (Object.prototype.hasOwnProperty.call(previousStatsDictionary, surveyId)) {\n            // if an updated stat is not found\n            var currentActivationStats = currentStatsDictionary[surveyId];\n            if (!currentActivationStats) {\n                // add to merged collection\n                mergedStats.addStats(surveyId, previousStatsDictionary[surveyId]);\n                // add to-be-updated collection\n                toBeUpdatedStats.addStats(surveyId, previousStatsDictionary[surveyId]);\n                continue;\n            }\n            // if previous stat has higher activation time\n            var previousActivationStats = previousStatsDictionary[surveyId];\n            if (previousActivationStats.ActivationTimeUtc > currentActivationStats.ActivationTimeUtc) {\n                // add to merged collection\n                mergedStats.addStats(surveyId, previousStatsDictionary[surveyId]);\n                // add to-be-updated collection\n                toBeUpdatedStats.addStats(surveyId, previousStatsDictionary[surveyId]);\n            }\n            else {\n                // add to current stat merged collection\n                mergedStats.addStats(surveyId, currentStatsDictionary[surveyId]);\n            }\n            // delete from stats\n            delete currentStatsDictionary[surveyId];\n        }\n    }\n    // merge any remaining stats\n    for (var surveyId in currentStatsDictionary) {\n        if (Object.prototype.hasOwnProperty.call(currentStatsDictionary, surveyId)) {\n            mergedStats.addStats(surveyId, currentStatsDictionary[surveyId]);\n        }\n    }\n    // always return merged list\n    statsCollections.add(0 /* Merged */, mergedStats);\n    // since dictionaries don\'t have an empty check, enumerate the  first entry to check for non-empty\n    var toBeUpdatedStatsDictionary = toBeUpdatedStats.getStats();\n    for (var toBeUpdated in toBeUpdatedStatsDictionary) {\n        if (Object.prototype.hasOwnProperty.call(toBeUpdatedStatsDictionary, toBeUpdated)) {\n            // not empty, return to-be-updated\n            statsCollections.add(1 /* ToBeUpdated */, toBeUpdatedStats);\n            break;\n        }\n    }\n    return statsCollections;\n}\nexports.MergeAndUpdateSurveyActivationStats = MergeAndUpdateSurveyActivationStats;\nvar SETTING_DATA_OPEN_TAG = "<data>";\nvar SETTING_DATA_CLOSE_TAG = "</data>";\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/StateProviderHelpers.js\n')},"../FloodgateCore/dist/src/SurveyActivityListener.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nvar ActivityTracker_1 = __webpack_require__(/*! ./ActivityTracker */ "../FloodgateCore/dist/src/ActivityTracker.js");\nvar Constants_1 = __webpack_require__(/*! ./Constants */ "../FloodgateCore/dist/src/Constants.js");\nvar IndexedTracker_1 = __webpack_require__(/*! ./IndexedTracker */ "../FloodgateCore/dist/src/IndexedTracker.js");\nvar SurveyStatCollectionEventActivity_1 = __webpack_require__(/*! ./SurveyStatCollectionEventActivity */ "../FloodgateCore/dist/src/SurveyStatCollectionEventActivity.js");\nvar Utils_1 = __webpack_require__(/*! ./Utils */ "../FloodgateCore/dist/src/Utils.js");\nvar queuedActivities = [];\nvar pendingActivityCount = 0;\nvar previousTrackedActivityMap = {};\n/**\n * This class tracks log calls against named activity strings (matched on strict case-sensitive equality)\n * and calls the provided callback when all activity thresholds for a given survey have been crossed\n */\nvar SurveyActivityListener = /** @class */ (function () {\n    function SurveyActivityListener(callback, loggerCallback) {\n        // Save incoming activity context data in a dictionary with SurveyID as key, activity data array as value\n        this.activityContext = {};\n        if (!callback) {\n            throw new Error("callback must not be null");\n        }\n        this.trackedActivityMap = {};\n        this.callback = callback;\n        this.loggerCallback = loggerCallback;\n    }\n    SurveyActivityListener.resetSessionActivity = function () {\n        previousTrackedActivityMap = {};\n    };\n    SurveyActivityListener.prototype.logActivity = function (activityName, increment, context) {\n        if (increment === void 0) { increment = 1; }\n        this.logActivity_private(activityName, 0 /* Increment */, increment, null, context);\n    };\n    SurveyActivityListener.prototype.logActivityStartTime = function (activityName, startTime) {\n        this.logActivity_private(activityName, 1 /* StartTime */, 0, startTime, null);\n    };\n    SurveyActivityListener.prototype.logActivityStopTime = function (activityName, stopTime) {\n        this.logActivity_private(activityName, 2 /* StopTime */, 0, stopTime, null);\n    };\n    SurveyActivityListener.prototype.SetActivityTrackingContracts = function (activityTrackingContracts, baseline) {\n        if (baseline === void 0) { baseline = new SurveyStatCollectionEventActivity_1.SurveyStatCollectionEventActivity(); }\n        var duplicateCounter = 0;\n        if (!activityTrackingContracts || activityTrackingContracts.length === 0 || !baseline) {\n            return;\n        }\n        // Populate a new map based on the passed in surveys, but propagating and tracking activity counts\n        // we may have seen against those events\n        // NOTE: We will lose activity counts for survey events that are no longer relevant.\n        var newMap = {};\n        var trackedSurveyIds = [];\n        for (var _i = 0, activityTrackingContracts_1 = activityTrackingContracts; _i < activityTrackingContracts_1.length; _i++) {\n            var activityTrackingContract = activityTrackingContracts_1[_i];\n            var trackingSet = activityTrackingContract.trackingSet;\n            // Added to the new set to make sure they are not duplicated. Based on MSO.\n            if (trackedSurveyIds.indexOf(activityTrackingContract.surveyId) === -1) {\n                trackedSurveyIds.push(activityTrackingContract.surveyId);\n            }\n            else {\n                // Duplicate surveyId being added, count it for the log.\n                duplicateCounter++;\n                continue;\n            }\n            // At this point, the survey\'s activities are safe to add.\n            // Set up the structures we need to transfer baseline counts (from previous sessions) or current counts (from previous trackers)\n            // Both vectors must be sorted in the same order as the trackingSet.List items\n            var baselineStats = baseline.getBySurveyId(activityTrackingContract.surveyId);\n            var baselineCounts = [trackingSet.getList().length];\n            var currentIndexedTrackers = new Array(trackingSet.getList().length);\n            var currentBaselineIndex = 0;\n            var currentIndex = 0;\n            for (var _a = 0, _b = trackingSet.getList(); _a < _b.length; _a++) {\n                var trackingData = _b[_a];\n                // Baseline stats count is 0 for events with "IsAggregate = false"\n                baselineCounts[currentIndex] = 0;\n                if (trackingData.getIsAggregate() && baselineStats && currentBaselineIndex < baselineStats.Counts.length) {\n                    baselineCounts[currentIndex] = baselineStats.Counts[currentBaselineIndex++];\n                }\n                // Session stats may be available in the previous trackedActivityMap\n                // Transfer the old "current session" count to the new tracker\n                // Is set to null if not available\n                if (previousTrackedActivityMap[trackingData.getActivity()]) {\n                    for (var _c = 0, _d = previousTrackedActivityMap[trackingData.getActivity()]; _c < _d.length; _c++) {\n                        var tracker = _d[_c];\n                        if (tracker.surveyId === activityTrackingContract.surveyId) {\n                            currentIndexedTrackers[currentIndex] = tracker;\n                            break;\n                        }\n                    }\n                }\n                currentIndex++;\n            }\n            // Make a new tracker and init the counts appropriately.\n            var newTracker = new ActivityTracker_1.default(trackingSet);\n            // If in a future change we start keeping trackers registered past activation, this will change\n            newTracker.initCounts(baselineCounts, currentIndexedTrackers, false /*wasActivatedThisSession*/);\n            // Setup the indexed trackers\n            for (var _e = 0, _f = newTracker.generateActivityIndexList(); _e < _f.length; _e++) {\n                var activityIndex = _f[_e];\n                var indexedTracker = new IndexedTracker_1.IndexedTracker();\n                indexedTracker.index = activityIndex.index;\n                indexedTracker.surveyId = activityTrackingContract.surveyId;\n                indexedTracker.tracker = newTracker;\n                if (!newMap[activityIndex.activity]) {\n                    newMap[activityIndex.activity] = [];\n                }\n                // Register the new tracker in our new map\n                newMap[activityIndex.activity].push(indexedTracker);\n            }\n        }\n        if (duplicateCounter > 0) {\n            var telemetryLogger = this.loggerCallback && this.loggerCallback();\n            if (telemetryLogger) {\n                telemetryLogger.log_Error(Constants_1.TelemetryEvent.SurveyActivity.SetActivityTrackingContracts.DuplicateSurveyID, "Duplicate surveyId passed in activityTrackingContracts. Duplicate count: " + duplicateCounter);\n            }\n        }\n        // Set the new map in place of the old\n        this.copyObject(this.trackedActivityMap, newMap);\n    };\n    SurveyActivityListener.prototype.clearSurveys = function () {\n        var _this = this;\n        Object.getOwnPropertyNames(this.trackedActivityMap).forEach(function (key) {\n            delete _this.trackedActivityMap[key];\n        });\n    };\n    SurveyActivityListener.prototype.saveSessionTrackingActivity = function (activity) {\n        // Set the new activity in place of the old\n        previousTrackedActivityMap[activity] = this.trackedActivityMap[activity];\n    };\n    // Get the indexedTracker that corresponds to the SurveyID and return that count. otherwise return 0.\n    SurveyActivityListener.prototype.getCount = function (activity, surveyId) {\n        var indexedTracker = this.getIndexedTracker(activity, surveyId);\n        if (!indexedTracker) {\n            return 0;\n        }\n        return indexedTracker.tracker.getCount(indexedTracker.index);\n    };\n    SurveyActivityListener.prototype.getSessionCount = function (activity, surveyId) {\n        var indexedTracker = this.getIndexedTracker(activity, surveyId);\n        if (!indexedTracker) {\n            return 0;\n        }\n        return indexedTracker.tracker.getSessionCount(indexedTracker.index);\n    };\n    /**\n     * An atomic get-and-set method.  Returns the current SessionCount, resetting it to zero and adding it into the established baseline\n     */\n    SurveyActivityListener.prototype.moveSessionCountIntoBaseCount = function (activity, surveyId) {\n        var indexedTracker = this.getIndexedTracker(activity, surveyId);\n        if (!indexedTracker) {\n            return 0;\n        }\n        return indexedTracker.tracker.moveSessionCountIntoBaseCount(indexedTracker.index);\n    };\n    SurveyActivityListener.prototype.getSurveyIds = function (activity) {\n        if (Utils_1.isNOU(activity)) {\n            return undefined;\n        }\n        var indexedTrackers = this.trackedActivityMap[activity];\n        if (!indexedTrackers) {\n            return undefined;\n        }\n        var surveyIds = indexedTrackers.map(function (indexedTracker) { return indexedTracker.surveyId; });\n        return surveyIds;\n    };\n    SurveyActivityListener.prototype.setCallback = function (callback) {\n        this.callback = callback;\n    };\n    SurveyActivityListener.prototype.UpdateActivityTrackingContracts = function (surveyList) {\n        if (Utils_1.isNOU(surveyList) || Object.keys(surveyList).length === 0) {\n            this.clearSurveys();\n            return;\n        }\n        for (var key in this.trackedActivityMap) {\n            if (Object.prototype.hasOwnProperty.call(this.trackedActivityMap, key)) {\n                var tracker = this.trackedActivityMap[key];\n                // loop through tracker and remove the ones not associate with given surveys\n                for (var i = tracker.length - 1; i >= 0; --i) {\n                    if (Object.prototype.hasOwnProperty.call(surveyList, tracker[i].surveyId)) {\n                        continue;\n                    }\n                    tracker.splice(i, 1);\n                }\n            }\n        }\n    };\n    SurveyActivityListener.prototype.getIndexedTracker = function (activity, surveyId) {\n        var indexedTrackers = this.trackedActivityMap[activity];\n        if (!indexedTrackers) {\n            return undefined;\n        }\n        var indexedTracker;\n        for (var _i = 0, indexedTrackers_1 = indexedTrackers; _i < indexedTrackers_1.length; _i++) {\n            var tracker = indexedTrackers_1[_i];\n            if (tracker.surveyId === surveyId) {\n                indexedTracker = tracker;\n                break;\n            }\n        }\n        return indexedTracker;\n    };\n    SurveyActivityListener.prototype.resetQueuedActivities = function () {\n        queuedActivities = [];\n    };\n    SurveyActivityListener.prototype.logActivity_private = function (activityName, logType, increment, timestamp, context) {\n        var _this = this;\n        if (this.callback && !this.callback.shouldAcceptActivity(activityName)) {\n            pendingActivityCount++;\n            if (queuedActivities.length < SurveyActivityListener.MaxPendingActivitiesQueueSize) {\n                queuedActivities.push({ activityName: activityName, logType: logType, increment: increment, timestamp: timestamp });\n            }\n        }\n        // Count any activities that are posted before \'FloodgateFirstStart\' activity happens\n        if (activityName === SurveyActivityListener.FloodgateStartActivityName) {\n            if (pendingActivityCount > 0) {\n                // Get the activity names of the queued activities for telemetry, send only first 25.\n                var activityNames = queuedActivities.slice(0, 25).map(function (queuedActivity) { return queuedActivity.activityName; });\n                var telemetryLogger = this.loggerCallback && this.loggerCallback();\n                if (telemetryLogger) {\n                    // Sampling this telemetry event to 5%\n                    telemetryLogger.log_Event(Constants_1.TelemetryEvent.SurveyActivity.LogActivity.EventsReprocessed, {\n                        ActivityNames: JSON.stringify(activityNames),\n                        Count: queuedActivities.length,\n                        Dropped: pendingActivityCount - queuedActivities.length,\n                    }, 0.05);\n                }\n                // replay all the queued activities one by one as the floodgate engine has started now\n                queuedActivities.map(function (queuedActivity) { return _this.logActivity_core(queuedActivity.activityName, queuedActivity.logType, queuedActivity.increment, queuedActivity.timestamp, context); });\n            }\n            pendingActivityCount = 0;\n            this.resetQueuedActivities();\n        }\n        this.logActivity_core(activityName, logType, increment, timestamp, context);\n    };\n    SurveyActivityListener.prototype.logActivity_core = function (activityName, logType, increment, timestamp, context) {\n        var indexedTrackers = this.trackedActivityMap[activityName];\n        if (!indexedTrackers || indexedTrackers.length === 0) {\n            return;\n        }\n        var indices = [];\n        // If we have more than one tracker shuffle trackers to randomize which is evaluated first\n        if (indexedTrackers.length > 1) {\n            indices = new Array(indexedTrackers.length);\n            for (var i = 0; i < indices.length; i++) {\n                indices[i] = i;\n            }\n            indices = Utils_1.fyShuffle(indices); // shuffle and reassign\n        }\n        else {\n            indices.push(0); // just have a zero. Shuffling is not needed.\n        }\n        // Loop through trackers in shuffled order\n        for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {\n            var index = indices_1[_i];\n            var tracker = indexedTrackers[index];\n            switch (logType) {\n                case 1 /* StartTime */: {\n                    tracker.tracker.startTime(tracker.index, timestamp);\n                    continue; // Look at the next tracker. Increment not needed.\n                }\n                case 2 /* StopTime */: {\n                    increment = tracker.tracker.stopTime(tracker.index, timestamp);\n                    // fall through to increment the activity as well.\n                }\n                case 0 /* Increment */: {\n                    break;\n                }\n                default: {\n                    continue;\n                }\n            }\n            if (context) {\n                var trackerSurveyId = tracker.surveyId;\n                this.activityContext[trackerSurveyId] = this.activityContext[trackerSurveyId] || [];\n                this.activityContext[trackerSurveyId].push({ activityName: activityName, context: context });\n            }\n            var result = tracker.tracker.incrementActivity(tracker.index, increment);\n            if (result === 2 /* AllActivitiesActivated */) {\n                // Check the activated surveys list to ensure whether any previous survey is still in process\n                // If not, the length should be 1 and call to execute this survey right away\n                // This should only happen if calling to Governance Service, due to the call is asynchronous\n                this.executeCallback(tracker.surveyId);\n                break;\n                /* Breaking here to let one and only one callback to be made from a logActivity call.\n                This ensures only one survey can fully \'trigger\' for a logActivity call. Others that would also\n                have triggered must wait until the next call to trigger (without there being a cooldown, of course).\n                */\n            }\n        }\n    };\n    SurveyActivityListener.prototype.executeCallback = function (surveyId) {\n        this.callback.run(surveyId, this.activityContext[surveyId]);\n    };\n    SurveyActivityListener.prototype.copyObject = function (target, source) {\n        Object.keys(source).forEach(function (key) {\n            target[key] = source[key];\n        });\n    };\n    SurveyActivityListener.FloodgateStartActivityName = "FloodgateFirstStart";\n    // The size of the dropped activities is set to 100 due to the following two reasons.\n    // 1) To prevent the array growing too big and causing memory issues.\n    // 2) Based on the telemetry analysis of number of dropped activities, the count is very small and much lesser than 100.\n    SurveyActivityListener.MaxPendingActivitiesQueueSize = 100;\n    return SurveyActivityListener;\n}());\nexports.default = SurveyActivityListener;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/SurveyActivityListener.js\n')},"../FloodgateCore/dist/src/SurveyComponents/CVSurveyComponent.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nvar floodgate_shared_typings_1 = __webpack_require__(/*! @ms-ofb/floodgate-shared-typings */ "../FloodgateCore/node_modules/@ms-ofb/floodgate-shared-typings/dist/index.js");\nvar CVSurveyComponent = /** @class */ (function () {\n    function CVSurveyComponent(data) {\n        if (!data) {\n            throw new Error("data must not be null");\n        }\n        if (!data.customerVoiceFormId) {\n            throw new Error("data.formID must not be null or empty");\n        }\n        this.data = data;\n    }\n    CVSurveyComponent.make = function (data) {\n        try {\n            return new CVSurveyComponent(data);\n        }\n        catch (e) {\n            return null;\n        }\n    };\n    CVSurveyComponent.prototype.getType = function () {\n        return "CVSurvey" /* CVSurvey */;\n    };\n    CVSurveyComponent.prototype.getFormId = function () {\n        return this.data.customerVoiceFormId;\n    };\n    // @Override\n    CVSurveyComponent.prototype.getDomElements = function (doc) {\n        if (!doc) {\n            throw new Error("Document must not be null");\n        }\n        var element = doc.createElement(floodgate_shared_typings_1.DOM_CVSURVEY_TAGNAME);\n        return [element];\n    };\n    // @Override\n    CVSurveyComponent.prototype.getJsonElements = function () {\n        var result = {};\n        result[floodgate_shared_typings_1.JSON_CVSURVEY_KEYNAME] = this.getFormId();\n        return result;\n    };\n    // @Override\n    CVSurveyComponent.prototype.getComponentJson = function () {\n        var _a;\n        return _a = {},\n            _a[floodgate_shared_typings_1.JSON_CVSURVEYFORMID_KEYNAME] = this.getFormId(),\n            _a;\n    };\n    return CVSurveyComponent;\n}());\n(function (CVSurveyComponent) {\n    var CVSurveyComponentData = /** @class */ (function () {\n        function CVSurveyComponentData() {\n        }\n        return CVSurveyComponentData;\n    }());\n    CVSurveyComponent.CVSurveyComponentData = CVSurveyComponentData;\n})(CVSurveyComponent || (CVSurveyComponent = {}));\nexports.default = CVSurveyComponent;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/SurveyComponents/CVSurveyComponent.js\n')},"../FloodgateCore/dist/src/SurveyComponents/CommentComponent.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nvar floodgate_shared_typings_1 = __webpack_require__(/*! @ms-ofb/floodgate-shared-typings */ "../FloodgateCore/node_modules/@ms-ofb/floodgate-shared-typings/dist/index.js");\nvar CommentComponent = /** @class */ (function () {\n    function CommentComponent(data) {\n        if (!data) {\n            throw new Error("data must not be null");\n        }\n        if (!data.question) {\n            throw new Error("data.question must not be null or empty");\n        }\n        this.data = data;\n        this.userComment = "";\n    }\n    CommentComponent.make = function (data) {\n        try {\n            return new CommentComponent(data);\n        }\n        catch (e) {\n            return null;\n        }\n    };\n    // @Override\n    CommentComponent.prototype.getType = function () {\n        return "Comment" /* Comment */;\n    };\n    // @Override\n    CommentComponent.prototype.getQuestion = function () {\n        return this.data.question;\n    };\n    // @Override\n    CommentComponent.prototype.setSubmittedText = function (userComment) {\n        this.userComment = userComment;\n    };\n    // @Override\n    CommentComponent.prototype.getSubmittedText = function () {\n        return this.userComment;\n    };\n    // @Override\n    CommentComponent.prototype.getDomElements = function (doc) {\n        if (!doc) {\n            throw new Error("Document must not be null");\n        }\n        var element = doc.createElement(floodgate_shared_typings_1.DOM_COMMENT_TAGNAME);\n        element.appendChild(doc.createTextNode(this.getSubmittedText()));\n        return [element];\n    };\n    // @Override\n    CommentComponent.prototype.getJsonElements = function () {\n        var result = {};\n        result[floodgate_shared_typings_1.JSON_COMMENT_KEYNAME] = this.getSubmittedText();\n        return result;\n    };\n    // @Override\n    CommentComponent.prototype.getComponentJson = function () {\n        var _a;\n        return _a = {},\n            _a[floodgate_shared_typings_1.JSON_QUESTION_KEYNAME] = this.getQuestion(),\n            _a;\n    };\n    return CommentComponent;\n}());\n(function (CommentComponent) {\n    var CommentComponentData = /** @class */ (function () {\n        function CommentComponentData() {\n        }\n        return CommentComponentData;\n    }());\n    CommentComponent.CommentComponentData = CommentComponentData;\n})(CommentComponent || (CommentComponent = {}));\nexports.default = CommentComponent;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/SurveyComponents/CommentComponent.js\n')},"../FloodgateCore/dist/src/SurveyComponents/InterceptComponent.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nvar floodgate_shared_typings_1 = __webpack_require__(/*! @ms-ofb/floodgate-shared-typings */ "../FloodgateCore/node_modules/@ms-ofb/floodgate-shared-typings/dist/index.js");\nvar InterceptComponent = /** @class */ (function () {\n    function InterceptComponent(data) {\n        if (!data) {\n            throw new Error("data must not be null");\n        }\n        if (!data.question) {\n            throw new Error("data.question must not be null or empty");\n        }\n        if (!data.title) {\n            throw new Error("data.title must not be null or empty");\n        }\n        if (!data.url) {\n            throw new Error("data.url must not be null or empty");\n        }\n        this.data = data;\n    }\n    InterceptComponent.make = function (data) {\n        try {\n            return new InterceptComponent(data);\n        }\n        catch (e) {\n            return null;\n        }\n    };\n    // @Override\n    InterceptComponent.prototype.getType = function () {\n        return "Intercept" /* Intercept */;\n    };\n    // @Override\n    InterceptComponent.prototype.getTitle = function () {\n        return this.data.title;\n    };\n    // @Override\n    InterceptComponent.prototype.getQuestion = function () {\n        return this.data.question;\n    };\n    // @Override\n    InterceptComponent.prototype.getUrl = function () {\n        return this.data.url;\n    };\n    // @Override\n    InterceptComponent.prototype.getDomElements = function (doc) {\n        if (!doc) {\n            throw new Error("Document must not be null");\n        }\n        return [doc.createElement(floodgate_shared_typings_1.DOM_INTERCEPT_TAGNAME)];\n    };\n    // @Override\n    InterceptComponent.prototype.getJsonElements = function () {\n        var _a;\n        return _a = {}, _a[floodgate_shared_typings_1.JSON_INTERCEPT_KEYNAME] = "", _a;\n    };\n    // @Override\n    InterceptComponent.prototype.getComponentJson = function () {\n        var _a;\n        return _a = {},\n            _a[floodgate_shared_typings_1.JSON_TITLE_KEYNAME] = this.getTitle(),\n            _a[floodgate_shared_typings_1.JSON_QUESTION_KEYNAME] = this.getQuestion(),\n            _a[floodgate_shared_typings_1.JSON_INTERCEPTURL_KEYNAME] = this.getUrl(),\n            _a;\n    };\n    return InterceptComponent;\n}());\n(function (InterceptComponent) {\n    var InterceptComponentData = /** @class */ (function () {\n        function InterceptComponentData() {\n        }\n        return InterceptComponentData;\n    }());\n    InterceptComponent.InterceptComponentData = InterceptComponentData;\n})(InterceptComponent || (InterceptComponent = {}));\nexports.default = InterceptComponent;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/SurveyComponents/InterceptComponent.js\n')},"../FloodgateCore/dist/src/SurveyComponents/MultipleChoiceComponent.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nvar floodgate_shared_typings_1 = __webpack_require__(/*! @ms-ofb/floodgate-shared-typings */ "../FloodgateCore/node_modules/@ms-ofb/floodgate-shared-typings/dist/index.js");\nvar MultipleChoiceComponent = /** @class */ (function () {\n    function MultipleChoiceComponent(data) {\n        if (!data) {\n            throw new Error("data must not be null");\n        }\n        if (!data.question) {\n            throw new Error("data.question must not be null or empty");\n        }\n        if (!data.availableOptions || data.availableOptions.length < 2) {\n            throw new Error("data.availableOptions must not be null or have less than two choices");\n        }\n        data.availableOptions.forEach(function (option) {\n            if (!option) {\n                throw new Error("Option values must not contain null or empty");\n            }\n        });\n        this.data = data;\n        this.optionStates = new Array(data.availableOptions.length);\n        // Initialize with all false values\n        for (var i = 0; i < this.optionStates.length; i++) {\n            this.optionStates[i] = false;\n        }\n    }\n    MultipleChoiceComponent.make = function (data) {\n        try {\n            return new MultipleChoiceComponent(data);\n        }\n        catch (e) {\n            return null;\n        }\n    };\n    MultipleChoiceComponent.prototype.getType = function () {\n        return "MultipleChoice" /* MultipleChoice */;\n    };\n    MultipleChoiceComponent.prototype.getQuestion = function () {\n        return this.data.question;\n    };\n    MultipleChoiceComponent.prototype.getAvailableOptions = function () {\n        return this.data.availableOptions;\n    };\n    MultipleChoiceComponent.prototype.getOptionSelectedStates = function () {\n        return this.optionStates;\n    };\n    MultipleChoiceComponent.prototype.getMinNumberofSelectedOptions = function () {\n        return this.data.minNumberOfSelectedOptions;\n    };\n    MultipleChoiceComponent.prototype.getMaxNumberofSelectedOptions = function () {\n        return this.data.maxNumberOfSelectedOptions;\n    };\n    MultipleChoiceComponent.prototype.setOptionSelectedStates = function (selectedStates) {\n        for (var i = 0; i < selectedStates.length; i++) {\n            this.optionStates[i] = selectedStates[i];\n        }\n    };\n    MultipleChoiceComponent.prototype.ValidateMinNumberofSelectedOptions = function () {\n        var result = 0;\n        this.optionStates.forEach(function (element) {\n            if (element) {\n                result++;\n            }\n        });\n        return (result >= this.getMinNumberofSelectedOptions());\n    };\n    MultipleChoiceComponent.prototype.ValidateMaxNumberofSelectedOptions = function () {\n        var result = 0;\n        this.optionStates.forEach(function (element) {\n            if (element) {\n                result++;\n            }\n        });\n        return (result <= this.getMaxNumberofSelectedOptions());\n    };\n    MultipleChoiceComponent.prototype.getDomElements = function (doc) {\n        if (!doc) {\n            throw new Error("Document must not be null");\n        }\n        var element = doc.createElement(floodgate_shared_typings_1.DOM_MULTIPLECHOICE_TAGNAME);\n        element.appendChild(doc.createTextNode(this.getOptionSelectedStates().toString()));\n        return [element];\n    };\n    // @Override\n    MultipleChoiceComponent.prototype.getJsonElements = function () {\n        var result = {};\n        result[floodgate_shared_typings_1.JSON_MULTIPLECHOICE_KEYNAME] = this.getOptionSelectedStates().toString();\n        return result;\n    };\n    // @Override\n    MultipleChoiceComponent.prototype.getComponentJson = function () {\n        var _a;\n        return _a = {},\n            _a[floodgate_shared_typings_1.JSON_QUESTION_KEYNAME] = this.getQuestion(),\n            _a[floodgate_shared_typings_1.JSON_RATINGOPTIONS_KEYNAME] = this.getAvailableOptions(),\n            _a;\n    };\n    return MultipleChoiceComponent;\n}());\n(function (MultipleChoiceComponent) {\n    var MultipleChoiceComponentData = /** @class */ (function () {\n        function MultipleChoiceComponentData() {\n        }\n        return MultipleChoiceComponentData;\n    }());\n    MultipleChoiceComponent.MultipleChoiceComponentData = MultipleChoiceComponentData;\n})(MultipleChoiceComponent || (MultipleChoiceComponent = {}));\nexports.default = MultipleChoiceComponent;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/SurveyComponents/MultipleChoiceComponent.js\n')},"../FloodgateCore/dist/src/SurveyComponents/PromptComponent.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nvar floodgate_shared_typings_1 = __webpack_require__(/*! @ms-ofb/floodgate-shared-typings */ "../FloodgateCore/node_modules/@ms-ofb/floodgate-shared-typings/dist/index.js");\nvar PromptComponent = /** @class */ (function () {\n    function PromptComponent(data) {\n        if (!data) {\n            throw new Error("data must not be null");\n        }\n        if (!data.question) {\n            throw new Error("data.question must not be null or empty");\n        }\n        if (!data.title) {\n            throw new Error("data.title must not be null or empty");\n        }\n        if (!data.yesButtonLabel) {\n            throw new Error("data.yesButtonLabel must not be null or empty");\n        }\n        if (!data.noButtonLabel) {\n            throw new Error("data.noButtonLabel must not be null or empty");\n        }\n        this.data = data;\n        this.selectedButton = 0 /* Unselected */;\n    }\n    PromptComponent.make = function (data) {\n        try {\n            return new PromptComponent(data);\n        }\n        catch (e) {\n            return null;\n        }\n    };\n    // @Override\n    PromptComponent.prototype.getType = function () {\n        return "Prompt" /* Prompt */;\n    };\n    // @Override\n    PromptComponent.prototype.getTitle = function () {\n        return this.data.title;\n    };\n    // @Override\n    PromptComponent.prototype.getQuestion = function () {\n        return this.data.question;\n    };\n    // @Override\n    PromptComponent.prototype.getYesButtonText = function () {\n        return this.data.yesButtonLabel;\n    };\n    // @Override\n    PromptComponent.prototype.getNoButtonText = function () {\n        return this.data.noButtonLabel;\n    };\n    // @Override\n    PromptComponent.prototype.setButtonSelected = function (selected) {\n        if (selected) {\n            this.selectedButton = selected;\n        }\n    };\n    // @Override\n    PromptComponent.prototype.getButtonSelected = function () {\n        return this.selectedButton;\n    };\n    // @Override\n    PromptComponent.prototype.getDomElements = function (doc) {\n        if (!doc) {\n            throw new Error("Document must not be null");\n        }\n        var element = doc.createElement(floodgate_shared_typings_1.DOM_PROMPT_TAGNAME);\n        element.appendChild(doc.createTextNode(this.promptButtonToString(this.getButtonSelected())));\n        return [element];\n    };\n    // @Override\n    PromptComponent.prototype.getJsonElements = function () {\n        var result = {};\n        result[floodgate_shared_typings_1.JSON_PROMPT_KEYNAME] = this.promptButtonToString(this.getButtonSelected());\n        return result;\n    };\n    // @Override\n    PromptComponent.prototype.getComponentJson = function () {\n        var _a;\n        return _a = {},\n            _a[floodgate_shared_typings_1.JSON_TITLE_KEYNAME] = this.getTitle(),\n            _a[floodgate_shared_typings_1.JSON_QUESTION_KEYNAME] = this.getQuestion(),\n            _a[floodgate_shared_typings_1.JSON_PROMPTYESTEXT_KEYNAME] = this.getYesButtonText(),\n            _a[floodgate_shared_typings_1.JSON_PROMPTNOTEXT_KEYNAME] = this.getNoButtonText(),\n            _a;\n    };\n    PromptComponent.prototype.promptButtonToString = function (value) {\n        switch (value) {\n            case 0 /* Unselected */:\n                return "Unselected";\n            case 1 /* Yes */:\n                return "Yes";\n            case 2 /* No */:\n                return "No";\n            default:\n                return "Unknown";\n        }\n    };\n    return PromptComponent;\n}());\n(function (PromptComponent) {\n    var PromptComponentData = /** @class */ (function () {\n        function PromptComponentData() {\n        }\n        return PromptComponentData;\n    }());\n    PromptComponent.PromptComponentData = PromptComponentData;\n})(PromptComponent || (PromptComponent = {}));\nexports.default = PromptComponent;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../FloodgateCore/dist/src/SurveyComponents/PromptComponent.js\n')},"../FloodgateCore/dist/src/SurveyComponents/RatingComponent.js":function(module,exports,__webpack_require__){"use strict";eval('\nObject.defineProperty(exports, "__esModule", { value: true });\nvar floodgate_shared_typings_1 = __webpack_require__(/*! @ms-ofb/floodgate-shared-typings */ "../FloodgateCore/node_modules/@ms-ofb/floodgate-shared-typings/dist/index.js");\nvar RatingComponent = /** @class */ (function () {\n    function RatingComponent(data) {\n        if (!data) {\n            throw new Error("data must not be null");\n        }\n        if (!data.question) {\n            throw new Error("data.question must not be null or empty");\n        }\n        if (!data.ratingValuesAscending || data.ratingValuesAscending.length < 2) {\n            throw new Error("data.ratingValuesAscending must not be null or have less than two choices");\n        }\n        data.ratingValuesAscending.forEach(function (rating) {\n            if (!rating) {\n                throw new Error("rating values must not contain null or empty");\n            }\n        });\n        this.data = data;\n        this.selectedIndex = -1;\n    }\n    RatingComponent.make = function (data) {\n        try {\n            return new RatingComponent(data);\n        }\n        catch (e) {\n            return null;\n        }\n    };\n    RatingComponent.prototype.getType = function () {\n        return "Rating" /* Rating */;\n    };\n    RatingComponent.prototype.getQuestion = function () {\n        return this.data.question;\n    };\n    RatingComponent.prototype.getRatingValuesAscending = function () {\n        return this.data.ratingValuesAscending;\n    };\n    RatingComponent.prototype.getSelectedRating = function () {\n        if (!this.isRatingIndexValid(this.selectedIndex)) {\n            return "";\n        }\n        return this.data.ratingValuesAscending[this.selectedIndex];\n    };\n    RatingComponent.prototype.setSelectedRatingIndex = function (selected) {\n        if (this.isRatingIndexValid(selected)) {\n            this.selectedIndex = selected;\n        }\n        else {\n            this.selectedIndex = -1;\n        }\n    };\n    RatingComponent.prototype.getSelectedRatingIndex = function () {\n        return this.selectedIndex;\n    };\n    RatingComponent.prototype.getDomElements = function (doc) {\n        if (!doc) {\n            throw new Error("Document must not be null");\n        }\n        var element = doc.createElement(floodgate_shared_typings_1.DOM_RATING_TAGNAME);\n        if (!this.isRatingIndexValid(this.getSelectedRatingIndex())) {\n            element.appendChild(doc.createTextNode("Not rated"));\n        }\n        else {\n            // Enforce six digits after the decimal\n            element.appendChild(doc.createTextNode(this.getNormalizedRatingScore().toFixed(6)));\n        }\n        return [element];\n    };\n    // @Override\n    RatingComponent.prototype.getJsonElements = function () {\n        var result = {};\n        if (!this.isRatingIndexValid(this.getSelectedRatingIndex())) {\n            result[floodgate_shared_typings_1.JSON_RATING_KEYNAME] = "Not rated";\n        }\n        else {\n            result[floodgate_shared_typings_1.JSON_RATING_KEYNAME] = this.getNormalizedRatingScore();\n        }\n        return result;\n    };\n    // @Override\n    RatingComponent.prototype.getComponentJson = function () {\n        var _a;\n        return _a = {},\n            _a[floodgate_shared_typings_1.JSON_QUESTION_KEYNAME] = this.getQuestion(),\n            _a[floodgate_shared_typings_1.JSON_RATINGOPTIONS_KEYNAME] = this.getRatingValuesAscending(),\n            _a;\n    };\n    RatingComponent.prototype.getNormalizedRatingScore = function () {\n        if (!this.isRatingIndexValid(this.getSelectedRatingIndex())) {\n            return -1;\n        }\n        if (this.data.isZeroBased) {\n            return (this.selectedIndex) / (this.data.ratingValuesAscending.length - 1);\n        }\n        else {\n            return (this.selectedIndex + 1.0) / this.data.ratingValuesAscending.length;\n        }\n    };\n    RatingComponent.prototype.isRatingIndexValid = function (index) {\n        return (index >= 0 && index < this.data.ratingValuesAscending.length);\n    };\n    return RatingComponent;\n}());\n(function (RatingComponent) {\n    var RatingComponentData = /** @class */ (function () {\n        function RatingComponentData() {\n        }\n        return RatingComponentData;\n    }());\n    RatingComponent.RatingComponentData = RatingComponentData;\n})(RatingComponent || (RatingComponent = {}));\nexports.default = RatingComponent;\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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